<?php
if (!defined('ABSPATH')) {
	exit;
}
// TCPDF Library laden
require_once('tcpdf/tcpdf.php');

// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF
{
	//Page header
	public function Header()
	{
		// Logo
		$image_file = plugin_dir_path(__DIR__) . '/img/logo.jpg';
		$this->Image($image_file, 18, 2, 36, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
		// Set font
		$this->SetFont('helvetica', 'B', 16);
		$this->Ln(15);
		// Abfrage von Prüfung und Datum und Ort
		$post_id = get_query_var('bericht');
		$termin_date = date("d.m.Y", strtotime(get_post_meta($post_id, 'termindate', true)));
		$title = get_the_title($post_id);
		$ort = get_post_meta($post_id, 'terminort', true);
		// Title
		$this->SetXY(100, 8);
		$this->Cell(100, 14, 'Parson Russell Terrier', 0, false, 'C', 0, '', 2, false, 'M', 'M');
		$this->SetXY(85, 15);
		$this->Cell(130, 14, 'Club Deutschland e.V. (PRTCD)', 0, false, 'C', 0, '', 2, false, 'M', 'M');
		$this->SetFont('helvetica', '', 8);
		$this->SetXY(85, 20);
		$this->Cell(130, 20, 'Mitglied des Verbandes für das deutsche Hundewesen e.V. (VDH)', 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->SetXY(85, 24);
		$this->Cell(130, 20, '- in der Fédération Cynologique Internationale (F.C.I.) -', 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->SetXY(85, 28);
		$this->Cell(130, 20, 'und des Jagdgebrauchshundverbandes e.V. (JGHV)', 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->SetFont('helvetica', 'B', 10);
		$this->SetXY(85, 32);
		$this->Cell(130, 20, 'Landesgruppe ' . get_option('lg_kalender_settings_name', true), 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->SetFont('times', 'B', 12);
		$this->SetXY(85, 32);
		$text = "Meldungen zu " . $title . " am " . $termin_date . " (" . $ort . ")";
		$this->Text(20, 35, $text, false, false, true, 0, 0, 'C');
	}
	// Page footer
	public function Footer()
	{
		// Position at 15 mm from bottom
		$this->SetY(-15);
		// Set font
		$this->SetFont('helvetica', 'I', 8);
		// Page number
		$this->Cell(0, 10, 'Seite ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
		$today = date("d.m.Y");
		$this->Cell(0, 10, $today, 0, false, 'R', 0, '', 0, false, 'T', 'M');
	}
}
class MYKALENDERPDF extends TCPDF
{
	//Page header
	public function Header()
	{
		// Logo
		$image_file = plugin_dir_path(__DIR__) . '/img/logo.jpg';
		$this->Image($image_file, 18, 2, 36, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
		// Set font
		$this->SetFont('helvetica', 'B', 16);
		$this->Ln(15);
		// Title
		$this->SetXY(100, 8);
		$this->Cell(100, 14, 'Parson Russell Terrier', 0, false, 'C', 0, '', 2, false, 'M', 'M');
		$this->SetXY(85, 15);
		$this->Cell(130, 14, 'Club Deutschland e.V. (PRTCD)', 0, false, 'C', 0, '', 2, false, 'M', 'M');
		$this->SetFont('helvetica', '', 8);
		$this->SetXY(85, 20);
		$this->Cell(130, 20, 'Mitglied des Verbandes für das deutsche Hundewesen e.V. (VDH)', 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->SetXY(85, 24);
		$this->Cell(130, 20, '- in der Fédération Cynologique Internationale (F.C.I.) -', 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->SetXY(85, 28);
		$this->Cell(130, 20, 'und des Jagdgebrauchshundverbandes e.V. (JGHV)', 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->SetFont('helvetica', 'B', 10);
		$this->SetXY(85, 32);
		$this->Cell(130, 20, 'Landesgruppe ' . get_option('lg_kalender_settings_name', true), 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->SetFont('times', 'B', 12);
		$this->SetXY(85, 32);
		$today = date("d.m.Y");
		$year = get_query_var('bericht');
		$text = "Kalender " . $year . " Stand " . $today;
		$this->Text(20, 35, $text, false, false, true, 0, 0, 'C');
	}
	// Page footer
	public function Footer()
	{
		// Position at 15 mm from bottom
		$this->SetY(-15);
		// Set font
		$this->SetFont('helvetica', 'I', 8);
		$this->Cell(0, 10, 'XX - Termin in Planung', 0, false, 'L', 0, '', 0, false, 'T', 'M');
		$this->SetY(-15);
		// Page number
		$this->Cell(0, 10, 'Seite ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
		$today = date("d.m.Y");
		$this->Cell(0, 10, $today, 0, false, 'R', 0, '', 0, false, 'T', 'M');
	}
}
class MYRICHTERPDF extends TCPDF
{

	//Page header
	public function Header()
	{
		// Logo
		$image_file = plugin_dir_path(__DIR__) . '/img/logo.jpg';
		$this->Image($image_file, 16, 3, 32, '', 'JPG', '', 'T', false, 330, '', false, false, 0, false, false, false);
		// Set font
		$this->SetFont('helvetica', 'B', 14);
		$this->Ln(15);
		$this->SetXY(80, 8);
		$this->Cell(80, 14, 'Parson Russell Terrier', 0, false, 'C', 0, '', 2, false, 'M', 'M');
		$this->SetXY(65, 15);
		$this->Cell(120, 14, 'Club Deutschland e.V. (PRTCD)', 0, false, 'C', 0, '', 2, false, 'M', 'M');
		$this->SetFont('helvetica', '', 7);
		$this->SetXY(65, 20);
		$this->Cell(120, 20, 'Mitglied des Verbandes für das deutsche Hundewesen e.V. (VDH)', 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->SetXY(65, 23);
		$this->Cell(120, 20, '- in der Fédération Cynologique Internationale (F.C.I.) -', 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->SetXY(65, 26);
		$this->Cell(120, 20, 'und des Jagdgebrauchshundverbandes e.V. (JGHV)', 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->SetFont('helvetica', 'B', 10);
		$this->SetXY(65, 30);
		$this->Cell(120, 20, 'Landesgruppe ' . get_option('lg_kalender_settings_name', true), 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->SetFont('times', 'B', 12);
		$today = date("d.m.Y");
		$title = 'Richterliste Stand ' . $today;
		$this->SetFont('times', 'B', 12);
		$this->Text(20, 35, $title, false, false, true, 0, 0, 'C');
	}
	// Page footer
	public function Footer()
	{
		// Position at 15 mm from bottom
		$this->SetY(-15);
		// Set font
		$this->SetFont('helvetica', 'I', 8);
		// Page number
		$this->Cell(0, 10, 'Seite ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
	}
}
class MYBUCHPDF extends TCPDF
{
	//Page header
	public function Header()
	{
		// Logo
		$image_file = plugin_dir_path(__DIR__) . '/img/logo.jpg';
		$this->Image($image_file, 18, 2, 36, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
		// Set font
		$this->SetFont('helvetica', 'B', 16);
		$this->Ln(15);
		// Abfrage von Prüfung und Datum und Ort
		$post_id = get_query_var('bericht');
		$termin_date = date("d.m.Y", strtotime(get_post_meta($post_id, 'termindate', true)));
		$title = get_the_title($post_id);
		$ort = get_post_meta($post_id, 'terminort', true);
		// Title
		$this->SetXY(100, 8);
		$this->Cell(100, 14, 'Parson Russell Terrier', 0, false, 'C', 0, '', 2, false, 'M', 'M');
		$this->SetXY(85, 15);
		$this->Cell(130, 14, 'Club Deutschland e.V. (PRTCD)', 0, false, 'C', 0, '', 2, false, 'M', 'M');
		$this->SetFont('helvetica', '', 8);
		$this->SetXY(85, 20);
		$this->Cell(130, 20, 'Mitglied des Verbandes für das deutsche Hundewesen e.V. (VDH)', 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->SetXY(85, 24);
		$this->Cell(130, 20, '- in der Fédération Cynologique Internationale (F.C.I.) -', 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->SetXY(85, 28);
		$this->Cell(130, 20, 'und des Jagdgebrauchshundverbandes e.V. (JGHV)', 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->SetFont('helvetica', 'B', 10);
		$this->SetXY(85, 32);
		$this->Cell(130, 20, 'Landesgruppe ' . get_option('lg_kalender_settings_name', true), 0, false, 'C', 0, '', 0, false, 'M', 'M');
		$this->SetFont('times', 'B', 12);
		$this->SetXY(85, 32);
		$text = "Meldungen zu " . $title . " am " . $termin_date . " (" . $ort . ")";
		$this->Text(20, 35, $text, false, false, true, 0, 0, 'C');
	}
	// Page footer
	public function Footer()
	{
		// Position at 15 mm from bottom
		$this->SetY(-15);
		// Set font
		$this->SetFont('helvetica', 'I', 8);
		// Page number
		$this->Cell(0, 10, 'Seite ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
		$today = date("d.m.Y");
		$this->Cell(0, 10, $today, 0, false, 'R', 0, '', 0, false, 'T', 'M');
	}
}
$pdfdocument = get_query_var('downloadpdf');
if ($pdfdocument == 'kalender'){
	$year=get_query_var('bericht');
	// create new PDF document
	$pdf = new MYKALENDERPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor('PRTCD - LG-' . get_option('lg_kalender_settings_name', true));
	$pdf->SetTitle('Meldungen');
	$pdf->SetSubject('Meldungen');
	//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');
	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);
	// set header and footer fonts
	$pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
	// set margins
	$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP + 15, PDF_MARGIN_RIGHT);
	$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
	// set image scale factor
	$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	// set font
	$pdf->SetFont('times', 'BI', 20);
	// add a page
	$pdf->AddPage('L', 'A4');
	$pdf->SetFont('times', '', 11);
	$lg_content = '<table cellspacing="0" cellpadding="3" border="1" style="width: 100%;">';
	$lg_content .= '<tr style="background-color: #cccccc; padding:5px;">';
	$lg_content .= '<th style="width: 10%;">Datum</th>';
	$lg_content .= '<th style="width: 30%;">Termin</th>';
	$lg_content .= '<th style="width: 15%;">Nenngeld</th>';
	$lg_content .= '<th style="width: 15%;">Meldeschluss</th>';
	$lg_content .= '<th style="width: 30%;">Meldestelle</th>';
	$lg_content .= '</tr>';

	$year = get_query_var('bericht');
	$start_date = $year . '-01-01';
	$end_date = $year . '-12-31';
	$args = array(
		'post_type' => 'lgkalender_termin',
		'post_status' => array('publish', 'draft', 'pending'),
		'posts_per_page' => -1,
		'meta_key' => 'termindate',
		'orderby' => 'meta_value',
		'order' => 'ASC',
		'meta_query' => array(
			array(
				'key' => 'termindate',
				'value' => array($start_date, $end_date),
				'compare' => 'BETWEEN',
				'type' => 'DATE'
			)
		)
	);
	$lines = 0;
	$loop = new WP_Query($args);
	// start des WordPress Loops für unseren post type
	while ($loop->have_posts()) :
		$loop->the_post();
		$lines++;
		// post id abfragen
		$post_id = get_the_ID();
		// abfrage unseres custom fields "position"
		$bpshow = get_option('lg_kalender_settings_bpshow', false);
		$title = get_the_title($post_id);
		$CB = getPruefung($title);
		$termin_ort = get_post_meta($post_id, 'terminort', true);
		if ($CB == 'BP') {
			$termin_ort = '';
		}
		$termin_date = date("d.m.Y", strtotime(get_post_meta($post_id, 'termindate', true)));
		if ('draft' == get_post_status($post_id)){
			$termin_date = 'XX '.$termin_date;
		}
		$termin_date_end = date("d.m.Y", strtotime(get_post_meta($post_id, 'termindateend', true)));
		$termin_nennschluss = date("d.m.Y", strtotime(get_post_meta($post_id, 'terminnennschluss', true)));
		if ($termin_nennschluss == '01.01.1970'){$termin_nennschluss = '';}
		$termin_date_cash = get_post_meta($post_id, 'termindatecash', true);
		$termin_user = get_post_meta($post_id, 'terminuser', true);
		$userdata = get_user_meta($termin_user);
		$lg_content .= '<tr><td>'.$termin_date.'</td><td>'.$title.'<br>'.$termin_ort.'</td><td>'.$termin_date_cash.'</td><td>'.$termin_nennschluss.'</td><td>'.$userdata['first_name'][0] . ' ' . $userdata['last_name'][0] . '</td></tr>';
		if ($lines == '11'){
			$lg_content .= '</table><tcpdf method="AddPage" />';
			$lg_content .= '<table cellspacing="0" cellpadding="3" border="1" style="width: 100%;">';
			$lg_content .= '<tr style="background-color: #cccccc; padding:5px;">';
			$lg_content .= '<th style="width: 10%;">Datum</th>';
			$lg_content .= '<th style="width: 30%;">Termin</th>';
			$lg_content .= '<th style="width: 15%;">Nenngeld</th>';
			$lg_content .= '<th style="width: 15%;">Meldeschluss</th>';
			$lg_content .= '<th style="width: 30%;">Meldestelle</th>';
			$lg_content .= '</tr>';
			$lines = 0;
		}
	endwhile;
	$lg_content .= '</table>';
	
	$pdf->writeHTMLCell(0, 0, 14, 41, $lg_content);
	// ---------------------------------------------------------
	//Close and output PDF document
	$pdf->Output('Kalender_' . $year . '.pdf', 'I');
}
$post_id = get_query_var('bericht');
$title = get_the_title($post_id);
$CB = '';
$CB = getPruefung($title);
$meldung_daten = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgmeldungendaten where postid like " . $post_id);
if ($pdfdocument == 'edvbericht') {
	// create new PDF document
	$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor('PRTCD - LG-' . get_option('lg_kalender_settings_name', true));
	$pdf->SetTitle('EDV-Bericht');
	$pdf->SetSubject('EDV-Bericht');
	//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');
	// remove default header/footer
	$pdf->setPrintHeader(false);
	$pdf->setPrintFooter(false);
	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
	// set margins
	$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP + 15, PDF_MARGIN_RIGHT);
	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
	// set image scale factor
	$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	// set font
	$pdf->SetFont('Arialbold', '', 14);
	// add a page
	$pdf->AddPage('L', 'A4');
	// Abfrage von Prüfung und Datum und Ort			
	$termin_date = date("d.m.Y", strtotime(get_post_meta($post_id, 'termindate', true)));
	$ort = stripslashes(get_post_meta($post_id, 'terminort', true));
	$pdf->SetXY(15, 20);
	$bericht_text = 'Prüfungsbericht';
	if ($CB == 'ZS') {
		$bericht_text = 'Zuchtschaubericht';
	}
	$pdf->Cell(0, 0, $bericht_text, 0, false, 'L', 0, '', 0, false, 'M', 'M');
	$pdf->SetXY(15, 20);
	$pdf->Cell(0, 0, 'Parson Russell Terrier Club Deutschland e.V.', 0, false, 'C', 0, '', 0, false, 'M', 'M');
	$pdf->SetXY(15, 20);
	$pdf->Cell(0, 0, date("Y", strtotime(get_post_meta($post_id, 'termindate', true))), 0, false, 'R', 0, '', 0, false, 'M', 'M');
	$pdf->SetXY(15, 20);
	$pdf->SetFont('Arialbold', 'B', 12);
	$Meldungen_ID = getMeldungen_ID($post_id);
	$verein_flag = false;
	if (strPos($Meldungen_ID, ',') == false) {
		$verein_flag = true;
	}
	$meldungen = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid IN (" . $Meldungen_ID . ") order by sortierung");
	$i = count($meldungen);
	$i = getMeldungen_Count($post_id);
	$meldungen_daten = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgmeldungendaten where postid like " . $post_id);
	$lg_content = '<table width="965" border="1" cellpadding="0">';
	$Datum_termin = date("d.m.Y", strtotime(get_post_meta($post_id, 'termindate', true)));
	if ($CB == 'GP') {
		$Datum_termin = date("d.", strtotime(get_post_meta($post_id, 'termindate', true))) . '-' . date("d.m.Y", strtotime(get_post_meta($post_id, 'termindateend', true)));
	}
	$lg_content .= '<tr><td>Prüfung: <b>' . $CB . '</b></td><td>Prüfungsdatum: <b>' . $Datum_termin . '</b></td><td>Ort: <b>' . stripslashes($meldungen_daten->meldung_p_ort) . '</b></td></tr>';
	$lg_content .= '<tr><td colspan="3">Landesgruppe: <b>' . get_option('lg_kalender_settings_name', true) . '</b></td></tr>';
	$name = '';
	if (($CB != 'WT') && ($CB != 'ZS')) {
		$name = getPLName($post_id, true, $verein_flag, $CB);
		//$lg_content .= ' (' . ($richternummer->richternummer ?? '') . ', ' . stripslashes($richternummer->verein ?? '') . ')';
	} else {
		$name = getPLName($post_id, false, false, $CB);
	}
	$lg_content .= '<tr><td>' . getPLTEXT($CB) . '</td><td colspan="2">' . stripslashes($name ?? '');
	$lg_content .= '</td></tr>';
	$name = getPOName($post_id, true, $verein_flag, $CB);
	$lg_content .= '<tr><td>' . getPOTEXT($CB) . '</td><td colspan="2">' . stripslashes($name ?? '') . '</td></tr>';
	$richter = $wpdb->get_row("SELECT * from " . $wpdb->prefix . "lgrichter where id like " . $richterliste->r2);
	$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . ($richter->id ?? '0') . ") and (" . $filter . " > 0)");
	if ($CB == 'ZS') {
		$name = getR2Name($post_id, false, false, $CB);
	} else {
		$name = getR2Name($post_id, true, $verein_flag, $CB);
	}
	$lg_content .= '<tr><td>' . getR2TEXT($CB) . '</td><td colspan="2">' . stripslashes($name ?? '') . '</td></tr>';
	if ($CB != 'ZS') {
		$lg_content .= '<tr><td>' . getR3TEXT($CB) . '</td><td colspan="2">';
		$name = getR3Name($post_id, true, $verein_flag, $CB);
		$lg_content .= stripslashes($name ?? '');
		$lg_content .= '</td></tr>';
	}
	$name = getRAName($post_id, true, $verein_flag, $CB);
	if (($name ?? '') > '') {
		if ($CB == 'ZS') {
			$name = getRAName($post_id, false, false, $CB);
		}
		$lg_content .= '<tr><td>' . getRATEXT($CB) . '</td><td colspan="2">' . stripslashes($name ?? '') . '</td></tr>';
	}
	$lg_content .= '<tr><td colspan="3"><table border="0"><tr><td>Gemeldet: ' . $i . '</td><td>Erschienen: ' . $meldungen_daten->meldung_p_erschienen . '</td>';
	if ($CB != 'ZS') {
		$lg_content .= '<td>Durchgeprüft: ' . $meldungen_daten->meldung_p_durchgp . '</td><td>Bestanden: ' . $meldungen_daten->meldung_p_bestanden . '</td></tr></table></td></tr>';
	} else {
		$lg_content .= '<td></td><td></td></tr></table></td></tr>';
	}
	if ($CB != 'ZS') {
		$lg_content .= '<tr><td colspan="3">Revierverhältnisse: ' . stripslashes($meldungen_daten->meldung_p_revier) . '</td></tr>';
		$lg_content .= '<tr><td colspan="3"><table border ="0"><tr><td>Wasserverhältnisse: ' . stripslashes($meldungen_daten->meldung_p_wasser) . '</td>';
		if ($CB == 'JP') {
			$lg_content .= '<td>Wildbesatz (Hase): ' . getWild($meldungen_daten->meldung_p_wild) . '</td></tr></table></td></tr>';
		} elseif (($CB == 'SJG') || ($CB == 'WT') || ($CB == 'ZS') || ($CB == 'BP')) {
			$lg_content .= '<td></td></tr></table></td></tr>';
		} else {
			$lg_content .= '<td>Wildbesatz: ' . getWild($meldungen_daten->meldung_p_wild) . '</td></tr></table></td></tr>';
		}
		$lg_content .= '<tr><td colspan="3">Witterung: ' . stripslashes($meldungen_daten->meldung_p_witterung) . '</td></tr>';
	}
	$lg_content .= '<tr><td colspan="3">besondere Vorkommnisse: ' . stripslashes($meldungen_daten->meldung_p_vorkommnisse) . '</td></tr>';
	$lg_content .= '</table>';
	$pdf->writeHTMLCell(0, 0, 15, 23, $lg_content);


	//ab hier Ergebnisse in Tabelle
	$pdf->SetFont('Arialbold', '', 10);
	$html_pos = $pdf->getLastH() + 24;
	$teiler = 9;
	if ($pdf->getLastH() > 60) {
		$teiler  = 7;
	}
	$lg_content = '<table width=100% border="0" cellpadding="2"><tr><td colspan="4"><table border="1" width=100% cellpadding="2">';
	if ($CB == 'WT') {
		$lg_content .= '<tr><td width="30" style="text-align: center; vertical-align: middle;">Nr.</td><td width="185">Name des Hundes</td><td width="30" style="text-align: center; vertical-align: middle;">R/H</td><td width="75" style="text-align: center; vertical-align: middle;">Stb.-Nr.</td><td width="180">Eigentümer<br>(Name,PLZ,Ort)</td><td width="180">Führer<br>(Name,PLZ,Ort)</td><td width="80" style="text-align: center; vertical-align: middle;">Wurftag</td><td width="75" style="text-align: center; vertical-align: middle;">Preis<br>WT best.</td><td width="65" style="text-align: center; vertical-align: middle;">Punkte<br>WT n.b.</td><td width="65" style="text-align: center; vertical-align: middle;">Laut</td></tr>';
		$i = 0;
		$missed = 0;
		foreach ($meldungen as $meldung) {
			$i++;
			if ((($i - 1 - $missed) % $teiler == 0) and ($i > 1)) {
				$lg_content .= '</table></td></tr></table>';
				$pdf->writeHTMLCell(0, 0, 15, $html_pos, $lg_content);
				$pdf->AddPage('L', 'A4');
				$pdf->SetXY(15, 20);
				$html_pos = 23;
				$teiler = 20;
				$lg_content = '<table width=100% border="1" cellpadding="0">';
			}
			if ($meldung->preis != '5') {
				$lg_content .= '<tr><td width="30" style="text-align: center; vertical-align: middle;"><b>' . $i . '</b></td><td width="185"><b>' . stripslashes($meldung->hund_name);
				$lg_content .= '</b></td><td width="30" style="text-align: center; vertical-align: middle;"><b>' . $meldung->hund_rh;
				$lg_content .= '</b></td><td width="75" style="text-align: center; vertical-align: middle;"><b>' . $meldung->hund_zbnr;
				$lg_content .= '</b></td><td width="180"><b>' . stripslashes($meldung->e_name) . '</b><br><b>' . stripslashes($meldung->e_plzort);
				$lg_content .= '</b></td><td width="180"><b>' . stripslashes($meldung->f_name) . '</b><br><b>' . stripslashes($meldung->f_plzort);
				$lg_content .= '</b></td><td width="80"style="text-align: center; vertical-align: middle;"><b>' . $meldung->hund_wurftag;
				$lg_content .= '</b></td><td width="75"style="text-align: center; vertical-align: middle;"><b>';
				if ($meldung->preis == "8") {
					$lg_content .= 'X';
				}
				$lg_content .= '</b></td><td width="65" style="text-align: center; vertical-align: middle;"><b>';
				if ($meldung->preis == "4") {
					$lg_content .= 'X';
				}
				$lg_content .= '</b></td><td width="65"></td></tr>';
			} else {
				$missed = $missed + 1;
			}
		}
	}
	if ($CB == 'SJG') {
		$lg_content .= '<tr><td width="30" style="text-align: center; vertical-align: middle;"><b>Nr.</b></td><td width="185"><b>Name des Hundes</b></td><td width="30" style="text-align: center; vertical-align: middle;"><b>R/H</b></td><td width="70"><b>ZB-Nr.<br>Reg.-Nr.</b></td><td width="190"><b>Eigentümer<br>(Name, PLZ, Ort)</b></td><td width="190"><b>Hundeführer<br>(Name, PLZ, Ort)</b></td><td width="80" style="text-align: center; vertical-align: middle;"><b>Wurfdatum</b></td><td width="50" style="text-align: center; vertical-align: middle;"><small>bestanden</small></td><td width="50" style="text-align: center; vertical-align: middle;"><small>nicht<br>bestanden</small></td><td width="60" style="text-align: center; vertical-align: middle;"><small>nicht<br>erschienen</small></td></tr>';
		$i = 0;
		foreach ($meldungen as $meldung) {
			$i++;
			if ((($i - 1) % 7 == 0) and ($i > 1)) {
				$lg_content .= '</table></td></tr></table>';
				$pdf->writeHTMLCell(0, 0, 15, $html_pos, $lg_content);
				$pdf->AddPage('L', 'A4');
				$pdf->SetXY(15, 20);
				$html_pos = 23;
				$teiler = 20;
				$lg_content = '<table width=100% border="1" cellpadding="2"><tr><td></td></tr><tr><td><table border="1" width=100% cellpadding="2"><tr><td width="30" style="text-align: center; vertical-align: middle;"><b>Nr.</b></td><td width="185"><b>Name des Hundes</b></td><td width="30" style="text-align: center; vertical-align: middle;"><b>R/H</b></td><td width="70"><b>ZB-Nr.<br>Reg.-Nr.</b></td><td width="190"><b>Eigentümer<br>(Name, PLZ, Ort)</b></td><td width="190"><b>Hundeführer<br>(Name, PLZ, Ort)</b></td><td width="80" style="text-align: center; vertical-align: middle;"><b>Wurfdatum</b></td><td width="50" style="text-align: center; vertical-align: middle;"><small>bestanden</small></td><td width="50" style="text-align: center; vertical-align: middle;"><small>nicht<br>bestanden</small></td><td width="60" style="text-align: center; vertical-align: middle;"><small>nicht<br>erschienen</small></td></tr>';
			}
			$lg_content .= "<tr><td style='text-align: center; vertical-align: middle;'>" . $i . "</td><td>" . stripslashes($meldung->hund_name);
			$lg_content .= "</td><td style='text-align: center; vertical-align: middle;'>" . $meldung->hund_rh;
			$lg_content .= "</td><td style='text-align: center; vertical-align: middle;'>" . $meldung->hund_zbnr;
			$lg_content .= "</td><td>" . stripslashes($meldung->e_name) . "<br>" . stripslashes($meldung->e_plzort);
			$lg_content .= "</td><td>" . stripslashes($meldung->f_name) . "<br>" . stripslashes($meldung->f_plzort);
			$lg_content .= "</td><td style='text-align: center; vertical-align: middle;'>" . $meldung->hund_wurftag;
			if ($meldung->preis == '8') {
				$lg_content .= '</td><td style="text-align: center; vertical-align: middle;">X';
			} else {
				$lg_content .= "</td><td>";
			}
			if ($meldung->preis == '4') {
				$lg_content .= '</td><td style="text-align: center; vertical-align: middle;">X';
			} else {
				$lg_content .= "</td><td>";
			}
			if ($meldung->preis == '5') {
				$lg_content .= '</td><td style="text-align: center; vertical-align: middle;">X';
			} else {
				$lg_content .= "</td><td>";
			}
			$lg_content .= "</td></tr>";
		}
	}
	if (($CB == 'JP') || ($CB == 'ZP') || ($CB == 'VStP') || ($CB == 'GP')) {
		if ($CB == 'VStP') {
			$lg_content .= '<tr><td width="30" style="text-align: center; vertical-align: middle;">Nr.</td><td width="185">Name des Hundes</td><td width="30" style="text-align: center; vertical-align: middle;">R/H</td><td width="75" style="text-align: center; vertical-align: middle;">Stb.-Nr.</td><td width="180">Eigentümer<br>(Name,PLZ,Ort)</td><td width="180">Führer<br>(Name,PLZ,Ort)</td><td width="80" style="text-align: center; vertical-align: middle;">Wurftag</td><td width="75" style="text-align: center; vertical-align: middle;">Ergebnis</td><td width="65" style="text-align: center; vertical-align: middle;">Punkte</td><td width="65" style="text-align: center; vertical-align: middle;">Laut</td></tr>';
		} else {
			$lg_content .= '<tr><td width="30" style="text-align: center; vertical-align: middle;">Nr.</td><td width="185">Name des Hundes</td><td width="30" style="text-align: center; vertical-align: middle;">R/H</td><td width="75" style="text-align: center; vertical-align: middle;">Stb.-Nr.</td><td width="180">Eigentümer<br>(Name,PLZ,Ort)</td><td width="180">Führer<br>(Name,PLZ,Ort)</td><td width="80" style="text-align: center; vertical-align: middle;">Wurftag</td><td width="75" style="text-align: center; vertical-align: middle;">Preis<br>WT best.</td><td width="65" style="text-align: center; vertical-align: middle;">Punkte<br>WT n.b.</td><td width="65" style="text-align: center; vertical-align: middle;">Laut</td></tr>';
		}
		$i = 0;
		$missed = 0;
		foreach ($meldungen as $meldung) {
			$i++;
			if ((($i - 1 - $missed) % $teiler == 0) and ($i > 1)) {
				$lg_content .= '</table></td></tr></table>';
				$pdf->writeHTMLCell(0, 0, 15, $html_pos, $lg_content);
				$pdf->AddPage('L', 'A4');
				$pdf->SetXY(15, 20);
				$html_pos = 23;
				$teiler = 20;
				$lg_content = '<table width=100% border="1" cellpadding="0">';
			}
			if ($meldung->preis != '5') {
				$lg_content .= '<tr><td width="30" style="text-align: center; vertical-align: middle;"><b>' . $i . '</b></td><td width="185"><b>' . stripslashes($meldung->hund_name);
				$lg_content .= '</b></td><td width="30" style="text-align: center; vertical-align: middle;"><b>' . $meldung->hund_rh;
				$lg_content .= '</b></td><td width="75" style="text-align: center; vertical-align: middle;"><b>' . $meldung->hund_zbnr;
				$lg_content .= '</b></td><td width="180"><b>' . stripslashes($meldung->e_name) . '</b><br><b>' . stripslashes($meldung->e_plzort);
				$lg_content .= '</b></td><td width="180"><b>' . stripslashes($meldung->f_name) . '</b><br><b>' . stripslashes($meldung->f_plzort);
				$lg_content .= '</b></td><td width="80" style="text-align: center; vertical-align: middle;"><b>' . $meldung->hund_wurftag;
				if (($CB == 'VStP') && (getPreis($meldung->preis) == 'bestanden')) {
					$lg_content .= '</b></td><td width="75" style="text-align: center; vertical-align: middle;"><b>best.';
				} else {
					$lg_content .= '</b></td><td width="75" style="text-align: center; vertical-align: middle;"><b>' . getPreis($meldung->preis);
				}
				$lg_content .= '</b></td><td width="65" style="text-align: center; vertical-align: middle;"><b>' . $meldung->punkte;
				$lg_content .= '</b></td><td width="65" style="text-align: center; vertical-align: middle;"><b>' . getLaut($meldung->laut);
				$lg_content .= "</b></td></tr>";
			} else {
				$missed = $missed + 1;
			}
		}
	}
	if (($CB == 'BP')) {
		$lg_content .= '<tr><td width="30" style="text-align: center; vertical-align: middle;">Nr.</td><td width="185">Name des Hundes</td><td width="30" style="text-align: center; vertical-align: middle;">R/H</td><td width="75" style="text-align: center; vertical-align: middle;">Stb.-Nr.</td><td width="180">Eigentümer<br>(Name,PLZ,Ort)</td><td width="180">Führer<br>(Name,PLZ,Ort)</td><td width="80" style="text-align: center; vertical-align: middle;">Wurftag</td><td width="75" style="text-align: center; vertical-align: middle;">Preis<br>WT best.</td><td width="65" style="text-align: center; vertical-align: middle;">Punkte<br>WT n.b.</td><td width="65" style="text-align: center; vertical-align: middle;">Laut</td></tr>';
		$i = 0;
		$missed = 0;
		foreach ($meldungen as $meldung) {
			$i++;
			if ((($i - 1 - $missed) % $teiler == 0) and ($i > 1)) {
				$lg_content .= '</table></td></tr></table>';
				$pdf->writeHTMLCell(0, 0, 15, $html_pos, $lg_content);
				$pdf->AddPage('L', 'A4');
				$pdf->SetXY(15, 20);
				$html_pos = 23;
				$teiler = 20;
				$lg_content = '<table width=100% border="1" cellpadding="0">';
			}
			if ($meldung->preis != '5') {
				$lg_content .= '<tr><td width="30" style="text-align: center; vertical-align: middle;"><b>' . $i . '</b></td><td width="185"><b>' . stripslashes($meldung->hund_name);
				$lg_content .= '</b></td><td width="30" style="text-align: center; vertical-align: middle;"><b>' . $meldung->hund_rh;
				$lg_content .= '</b></td><td width="75" style="text-align: center; vertical-align: middle;"><b>' . $meldung->hund_zbnr;
				$lg_content .= '</b></td><td width="180"><b>' . stripslashes($meldung->e_name) . '</b><br><b>' . stripslashes($meldung->e_plzort);
				$lg_content .= '</b></td><td width="180"><b>' . stripslashes($meldung->f_name) . '</b><br><b>' . stripslashes($meldung->f_plzort);
				$lg_content .= '</b></td><td width="80" style="text-align: center; vertical-align: middle;"><b>' . $meldung->hund_wurftag;
				$lg_content .= '</b></td><td width="75" style="text-align: center; vertical-align: middle;"><b>' . getPreis($meldung->preis);
				$lg_content .= '</b></td><td width="65" style="text-align: center; vertical-align: middle;"><b>' . $meldung->punkte;
				$lg_content .= '</b></td><td width="65" style="text-align: center; vertical-align: middle;"><b>' . getLaut($meldung->laut);
				$lg_content .= '</b></td></tr>';
			} else {
				$missed = $missed + 1;
			}
		}
	}
	if (($CB == 'ZS')) {
		$lg_content .= '<tr><td width="30" style="text-align: center; vertical-align: middle;"><b>Nr.</b></td><td width="195"><b>Name des Hundes</b></td><td width="30" style="text-align: center; vertical-align: middle;"><b>R/H</b></td><td width="80"><b>Stb-Nr.</b></td><td width="190"><b>Eigentümer<br>(Name,PLZ,Ort)</b></td><td width="80" style="text-align: center; vertical-align: middle;"><b>Wurftag</b></td><td width="40" style="text-align: center; vertical-align: middle;"><b>FW</b></td><td width="40" style="text-align: center; vertical-align: middle;"><b>WH</b></td><td width="40" style="text-align: center; vertical-align: middle;"><b>BU</b></td><td width="40" style="text-align: center; vertical-align: middle;"><b>Haar</b></td><td width="170" style="text-align: center; vertical-align: middle;"><b>Gebiss</b></td></tr>';
		$i = 0;
		$missed = 0;
		foreach ($meldungen as $meldung) {
			$i++;
			if ((($i - 1 - $missed) % $teiler == 0) and ($i > 1)) {
				$lg_content .= '</table></td></tr></table>';
				$pdf->writeHTMLCell(0, 0, 15, $html_pos, $lg_content);
				$pdf->AddPage('L', 'A4');
				$pdf->SetXY(15, 20);
				$html_pos = 23;
				$teiler = 20;
				$lg_content = '<table width=100% border="1" cellpadding="0">';
			}
			if ($meldung->fw != '5') {
				$lg_content .= '<tr><td style="text-align: center; vertical-align: middle;"><b>' . $i . '</b></td><td><b>' . stripslashes($meldung->hund_name);
				$lg_content .= '</b></td><td style="text-align: center; vertical-align: middle;"><b>' . $meldung->hund_rh;
				$lg_content .= '</b></td><td style="text-align: center; vertical-align: middle;"><b>' . $meldung->hund_zbnr;
				$lg_content .= '</b></td><td><b>' . stripslashes($meldung->e_name) . '</b><br><b>' . stripslashes($meldung->e_plzort);
				$lg_content .= '</b></td><td style="text-align: center; vertical-align: middle;"><b>' . $meldung->hund_wurftag;
				$lg_content .= '</b></td><td style="text-align: center; vertical-align: middle;"><b>' . getFormwert($meldung->fw);
				$lg_content .= '</b></td><td style="text-align: center; vertical-align: middle;"><b>' . $meldung->wh;
				$lg_content .= '</b></td><td style="text-align: center; vertical-align: middle;"><b>' . $meldung->bu;
				$lg_content .= '</b></td><td style="text-align: center; vertical-align: middle;"><b>' . $meldung->haar;
				$lg_content .= '</b></td><td style="text-align: center; vertical-align: middle;"><b>' . stripslashes($meldung->gebiss);
				$lg_content .= '</b></td></tr>';
			} else {
				$missed = $missed + 1;
			}
		}
	}
	$lg_content .= '</table></td></tr>';
	$lg_content .= '</table>';

	$pdf->writeHTMLCell(0, 0, 15, $html_pos, $lg_content);
	// ---------------------------------------------------------
	//Close and output PDF document
	$pdf->Output('EDV_Bericht_' . $title . '_' . $termin_date . '_' . $ort . '.pdf', 'I');
}
if ($pdfdocument == 'meldungen') {
	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor('PRTCD - LG-' . get_option('lg_kalender_settings_name', true));
	$pdf->SetTitle('Meldungen');
	$pdf->SetSubject('Meldungen');
	//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');
	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);
	// set header and footer fonts
	$pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
	// set margins
	$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP + 15, PDF_MARGIN_RIGHT);
	$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
	// set image scale factor
	$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	// set font
	$pdf->SetFont('times', 'BI', 20);
	// add a page
	$pdf->AddPage('L', 'A4');
	$style = array(
		'border' => 2,
		'vpadding' => 'auto',
		'hpadding' => 'auto',
		'fgcolor' => array(0, 0, 0),
		'bgcolor' => false,
		//array(255,255,255)
		'module_width' => 1,
		// width of a single module in points
		'module_height' => 1 // height of a single module in points
	);
	// Abfrage von Prüfung und Datum und Ort			
	$termin_date = date("d.m.Y", strtotime(get_post_meta($post_id, 'termindate', true)));
	$ort = get_post_meta($post_id, 'terminort', true);
	$insert_code = get_post_meta($post_id, 'terminmeldescheincode', true);;
	// set font
	// QRCODE,H : QR-CODE Best error correction
	$pdf->write2DBarcode(get_page_link(get_option('lg_kalender_settings_pagemeldungen', '')) . '?bericht=' . $post_id . '&insert=' . $insert_code, 'QRCODE,H', 255, 5, 25, 25, $style, 'N');
	$theLink = '<a href="' . get_page_link(get_option('lg_kalender_settings_pagemeldungen', '')) . '?bericht=' . $post_id . '&insert=' . $insert_code . '">Ergebnisse mitteilen</a>';
	$pdf->SetFont('times', '', 8);
	$pdf->writeHTMLCell(0, 0, 255, 31, $theLink);
	$pdf->SetFont('times', '', 11);
	$meldungen = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id);
	$lg_content = '<table cellspacing="0" cellpadding="3" border="1" style="width: 100%;"><tr style="background-color: #cccccc; padding:5px;"><th style="width: 4%;">Nr.</th><th style="width: 20%;">Name Hund</th><th style="width: 4%;">R/H</th><th style="width: 15%;">Chip-Nr./ZB-Nr.</th><th style="width: 20%;">Eigentümer</th><th style="width: 20%;">Hundeführer</th><th style="width: 10%;">Wurfdatum</th><th style="width: 9%;">bezahlt</th></tr>';
	$zaehler = 0;
	$i = 0;
	foreach ($meldungen as $meldung) {
		$i++;
		if ((($i - 1) % 4 == 0) and ($i > 1)) {
			$lg_content .= '</table><tcpdf method="AddPage" />';
			$lg_content .= '<table cellspacing="0" cellpadding="3" border="1" style="width: 100%;"><tr style="background-color: #cccccc; padding:5px;"><th style="width: 4%;">Nr.</th><th style="width: 20%;">Name Hund</th><th style="width: 4%;">R/H</th><th style="width: 15%;">Chip-Nr./ZB-Nr.</th><th style="width: 20%;">Eigentümer</th><th style="width: 20%;">Hundeführer</th><th style="width: 10%;">Wurfdatum</th><th style="width: 9%;">bezahlt</th></tr>';
		}
		$lg_content .= "<tr><td>" . $i . "</td><td>" . stripslashes($meldung->hund_name);
		$lg_content .= "</td><td>" . $meldung->hund_rh;
		$lg_content .= "</td><td>" . $meldung->hund_chipnr . "<br>" . $meldung->hund_zbnr;
		$lg_content .= "</td><td>" . stripslashes($meldung->e_name) . "<br>" . stripslashes($meldung->e_plzort) . "<br>Tel.:" . $meldung->e_telefon . "<br>Mitgl.Nr.:" . $meldung->e_mitglied;
		$lg_content .= "</td><td>" . stripslashes($meldung->f_name) . "<br>" . stripslashes($meldung->f_plzort) . "<br>Tel.:" . $meldung->f_telefon;
		$lg_content .= "</td><td>" . $meldung->hund_wurftag;
		$lg_content .= "</td><td>" . $meldung->zahlung_betrag . " €";
		$lg_content .= "</td></tr>";
		if (($CB == 'JP') || ($CB == 'ZP') || ($CB == 'GP')) {
			$lg_content .= '<tr><td> </td><td>BP vorhanden: ';
				if ($meldung->bp_vorhanden == '1') {
					$lg_content .= 'Ja';
				} else {
					$lg_content .= 'Nein';
				}	
			$lg_content .= '<br>Laut:</td><td colspan="3">Punkte:<br></td><td colspan="3">Preis:</td></tr>';
		}
		if (($CB == 'BP')) {
			if ($CB == 'BP'){
				$lg_content .= '<tr><td> </td><td>Schussfest JP: ';
			if ($meldung->schussjp_vorhanden == '1') {
				$lg_content .= 'Ja';
			} else {
				$lg_content .= 'Nein';
			}
			}
			
			$lg_content .= '</td><td colspan="3">Punkte:<br></td><td colspan="3">Preis:</td></tr>';
		}
		if (($CB == 'SJG')) {
			$lg_content .= '<tr><td> </td><td>Lautnachweis vorhanden:<br>';
			if ($meldung->lt_vorhanden == '1') {
				$lg_content .= 'Ja';
			} else {
				$lg_content .= 'Nein';
			}
			$lg_content .= '</td><td colspan="3"></td><td colspan="3">bestanden:</td></tr>';
		}
		if (($CB == 'WT')) {
			$lg_content .= '<tr><td> </td><td></td><td colspan="3"></td><td colspan="3">bestanden:</td></tr>';
		}
		if (($CB == 'ZS')) {
			$lg_content .= '<tr><td colspan="3">Gebiss<br></td><td>WH</td><td>BU</td><td>Haar</td><td colspan="2">FW</td></tr>';
		}
	}
	$lg_content .= "</table>";
	$richterliste = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgmeldungenrichter WHERE postid like " . $post_id);
	$lg_content .= '<tcpdf method="AddPage" />';
	$lg_content .= "<p>Pin zur Onlineeingabe Ergebnisse: " . get_post_meta($post_id, 'terminmeldescheinpin', true) . "<br><br>";
	$lg_content .= '<table cellspacing="0" cellpadding="3" border="1" style="width: 100%;">';
	$richter = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgrichter WHERE id like " . $richterliste->pl);
	$lg_content .= "<tr><td>" . getPLTEXT($CB) . "</td><td>" . stripslashes($richter->vorname ?? '') . " " . stripslashes($richter->nachname ?? '') . "<br>" . stripslashes($richter->strasse ?? '') . "<br>" . ($richter->plz ?? '') . " " . stripslashes($richter->ort ?? '') . "</td><td>" . ($richter->telefon ?? '') . "<br>" . ($richter->mobil ?? '') . "</td></tr>";
	$richter = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgrichter WHERE id like " . $richterliste->po);
	$lg_content .= "<tr><td>" . getPOTEXT($CB) . "</td><td>" . stripslashes($richter->vorname ?? '') . " " . stripslashes($richter->nachname ?? '') . "<br>" . stripslashes($richter->strasse ?? '') . "<br>" . ($richter->plz ?? '') . " " . stripslashes($richter->ort ?? '') . "</td><td>" . ($richter->telefon ?? '') . "<br>" . ($richter->mobil ?? '') . "</td></tr>";
	$richter = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgrichter WHERE id like " . $richterliste->r2);
	$lg_content .= "<tr><td>" . getR2TEXT($CB) . "</td><td>" . stripslashes($richter->vorname ?? '') . " " . stripslashes($richter->nachname ?? '') . "<br>" . stripslashes($richter->strasse ?? '') . "<br>" . ($richter->plz ?? '') . " " . stripslashes($richter->ort ?? '') . "</td><td>" . ($richter->telefon ?? '') . "<br>" . ($richter->mobil ?? '') . "</td></tr>";
	$richter = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgrichter WHERE id like " . $richterliste->r3);
	$lg_content .= "<tr><td>" . getR3TEXT($CB) . "</td><td>" . stripslashes($richter->vorname ?? '') . " " . stripslashes($richter->nachname ?? '') . "<br>" . stripslashes($richter->strasse ?? '') . "<br>" . ($richter->plz ?? '') . " " . stripslashes($richter->ort ?? '') . "</td><td>" . ($richter->telefon ?? '') . "<br>" . ($richter->mobil ?? '') . "</td></tr>";
	$richter = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgrichter WHERE id like " . $richterliste->ra);
	$lg_content .= "<tr><td>" . getRATEXT($CB) . "</td><td>" . stripslashes($richter->vorname ?? '') . " " . stripslashes($richter->nachname ?? '') . "<br>" . stripslashes($richter->strasse ?? '') . "<br>" . ($richter->plz ?? '') . " " . stripslashes($richter->ort ?? '') . "</td><td>" . ($richter->telefon ?? '') . "<br>" . ($richter->mobil ?? '') . "</td></tr>";
	$lg_content .= "</table>";
	$pdf->writeHTMLCell(0, 0, 14, 41, $lg_content);
	// ---------------------------------------------------------
	//Close and output PDF document
	$pdf->Output('Meldungen_' . $title . '_' . $termin_date . '_' . $ort . '.pdf', 'I');
} elseif ($pdfdocument == 'richter') {
	// create new PDF document
	$pdf = new MYRICHTERPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor('PRTCD - LG-' . get_option('lg_kalender_settings_name', true));
	$pdf->SetTitle('Richter');
	$pdf->SetSubject('Richter');
	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);
	// set header and footer fonts
	$pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
	// set margins
	$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP + 15, PDF_MARGIN_RIGHT);
	$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
	// set image scale factor
	$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	// set font
	$pdf->SetFont('times', 'BI', 20);
	// add a page
	$pdf->AddPage('P', 'A4');
	$pdf->SetFont('times', '', 10);
	$meldungen = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgrichter ORDER BY nachname,vorname");
	$lg_content = '<table cellspacing="0" cellpadding="3" border="1" style="width: 100%;"><tr style="background-color: #cccccc; padding:5px;"><th style="width: 4%;">Nr.</th><th style="width: 25%;">Name</th><th style="width: 25%;">Adresse</th><th style="width: 18%;">Telefon/Mobil</th><th style="width: 6%;">JGHV</th><th style="width: 5%;">Bau</th><th style="width: 5%;">SW</th><th style="width: 5%;">WT</th><th style="width: 5%;">ZS</th></tr>';
	$i = 0;
	foreach ($meldungen as $meldung) {
		$i++;
		if ((($i - 1) % 18 == 0) and ($i > 1)) {
			$lg_content .= '</table><tcpdf method="AddPage" />';
			$lg_content .= '<table cellspacing="0" cellpadding="3" border="1" style="width: 100%;"><tr style="background-color: #cccccc; padding:5px;"><th style="width: 4%;">Nr.</th><th style="width: 25%;">Name</th><th style="width: 25%;">Adresse</th><th style="width: 18%;">Telefon/Mobil</th><th style="width: 6%;">JGHV</th><th style="width: 5%;">Bau</th><th style="width: 5%;">SW</th><th style="width: 5%;">WT</th><th style="width: 5%;">ZS</th></tr>';
		}

		$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(norm) as norm from " . $wpdb->prefix . "lgrichternummer where (richterid like " . $meldung->id . ") and (norm > 0)");
		$jghv = $richternummer->richternummer . '(' . $richternummer->verein . ')';
		$lg_content .= "<tr><td>" . $i . "<br>";
		$lg_content .= "</td><td>" . stripslashes($meldung->nachname) . ", " . stripslashes($meldung->vorname);
		if ($richternummer->norm > 0) {
			$lg_content .= "<br>" . $jghv;
		}
		$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(wt) as wt from " . $wpdb->prefix . "lgrichternummer where (richterid like " . $meldung->id . ") and (wt > 0)");
		$wsnr = $richternummer->richternummer . '(' . $richternummer->verein . ')';
		if ($richternummer->wt > 0) {
			$lg_content .= "<br>" . $wsnr;
		}
		$lg_content .= "</td><td>" . stripslashes($meldung->strasse) . "<br>" . $meldung->plz . " " . stripslashes($meldung->ort);
		$lg_content .= "</td><td>" . $meldung->telefon . "<br>" . $meldung->mobil;
		$meldungen_2 = $wpdb->get_row("SELECT SUM(bau) AS bau, SUM(wt) AS wt, SUM(norm) AS norm, SUM(sw) AS sw, SUM(ra) AS ra, SUM(zs) AS zs FROM " . $wpdb->prefix . "lgrichternummer WHERE richterid LIKE '" . $meldung->id . "'");
		$lg_content .= '</td><td style="text-align: center;">';
		if ($meldungen_2->norm > 0) {
			$lg_content .= 'x';
		}
		$lg_content .= '</td><td style="text-align: center;">';
		if ($meldungen_2->bau > 0) {
			$lg_content .= 'x';
		}
		$lg_content .= '</td><td style="text-align: center;">';
		if ($meldungen_2->sw > 0) {
			$lg_content .= 'x';
		}
		$lg_content .= '</td><td  style="text-align: center;">';
		if ($meldungen_2->wt > 0) {
			$lg_content .= 'x';
		}
		$lg_content .= '</td><td style="text-align: center;">';
		if ($meldungen_2->zs > 0) {
			$lg_content .= 'x';
		}
		$lg_content .= "</td></tr>";
	}
	$lg_content .= "</table>";
	$pdf->writeHTMLCell(0, 0, 14, 42, $lg_content);
	//Close and output PDF document
	$today = date("Y_m_d");
	$pdf->Output('Richterliste_Landesgruppe_' . get_option('lg_kalender_settings_name', true) . '_' . $today . '.pdf', 'I');
}
if ($pdfdocument == 'richterbuch') {
	$pdf = new MYBUCHPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor('PRTCD - LG-' . get_option('lg_kalender_settings_name', true));
	$pdf->SetTitle('Richterbucht');
	$pdf->SetSubject('Richterbuch');
	//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');
	// remove default header/footer
	$pdf->setPrintHeader(false);
	$pdf->setPrintFooter(false);
	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
	// set margins
	$pdf->SetMargins(0, 0, 0);
	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, 10);
	// set image scale factor
	$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	// set font
	$pdf->SetFont('times', 'B', 8);
	// add a page
	$pdf->AddPage('L', 'A4');
	// Abfrage von Prüfung und Datum und Ort			
	$termin_date = date("d.m.Y", strtotime(get_post_meta($post_id, 'termindate', true)));
	$termin_date_end = date("d.m.Y", strtotime(get_post_meta($post_id, 'termindateend', true)));
	$ort = stripslashes(get_post_meta($post_id, 'terminort', true));
	//$pdf->SetXY(15, 20);
	$pdf->MultiCell(128, 185, 'Notizen', 1, 'L', 0, 0, 10, 10,);
	$pdf->MultiCell(128, 185, '', 1, 'L', 0, 0, 159, 10);
	$image_file = plugin_dir_path(__DIR__) . '/img/logo.jpg';
	$pdf->IMAGE($image_file, 208, 15, 30, 30, 'JPG', '', 'T', true, 150, '', false, false, 0, true, false, false);
	$pdf->SetFont('times', 'B', 10);
	$pdf->MultiCell(128, 20, 'Parson Russell Terrier', 0, 'C', 0, 0, 159, 47);
	$pdf->MultiCell(128, 20, 'Club Deutschland e.V. (PRTCD)', 0, 'C', 0, 0, 159, 50);
	$pdf->SetFont('helvetica', '', 6);
	$pdf->MultiCell(128, 20, 'Mitglied des Verbandes für das deutsche Hundewesen e.V. (VDH)', 0, 'C', 0, 0, 159, 54);
	$pdf->MultiCell(128, 20, '- in der Fédération Cynologique Internationale (F.C.I.) -', 0, 'C', 0, 0, 159, 56);
	$pdf->MultiCell(128, 20, 'und des Jagdgebrauchshundverbandes e.V. (JGHV)', 0, 'C', 0, 0, 159, 58);
	$pdf->SetFont('helvetica', 'B', 10);
	$pdf->MultiCell(128, 20, 'Landesgruppe ' . get_option('lg_kalender_settings_name', true), 0, 'C', 0, 0, 159, 62);
	$pdf->SetFont('helvetica', 'BU', 18);
	$pdf->MultiCell(128, 20, 'Richterbuch', 0, 'C', 0, 0, 159, 77);
	$pdf->SetFont('helvetica', 'B', 16);
	$pdf->MultiCell(128, 20, getPruefung_Text($title) . ' (' . $CB . ')', 0, 'C', 0, 0, 159, 90);
	if (($termin_date_end > '') and ($termin_date_end <> '01.01.1970')) {
		$termin_date = $termin_date . ' - ' . $termin_date_end;
	}
	$pdf->MultiCell(128, 20, $termin_date, 0, 'C', 0, 0, 159, 100);
	$pdf->MultiCell(128, 20, 'in', 0, 'C', 0, 0, 159, 110);
	$pdf->MultiCell(128, 20, stripslashes($meldung_daten->meldung_p_ort), 0, 'C', 0, 0, 159, 120);
	$content = '
			<div align="center">
			<table>';
	$filter = 'norm';
	if ($CB == 'WT') {
		$filter = 'wt';
	}
	if ($CB == 'ZS') {
		$filter = 'zs';
	}
	$richterliste = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgmeldungenrichter WHERE postid like " . $post_id);
	$richter = $wpdb->get_row("SELECT * from " . $wpdb->prefix . "lgrichter where id like " . $richterliste->pl);
	$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . ($richter->id ?? '0') . ") and (" . $filter . " > 0)");
	$content .= '
				<tr>
					<td align="right">' . getPLTEXT($CB) . ':</td>
					<td width="20px"></td>
					<td align="left">' . stripslashes($richter->vorname ?? '') . ' ' . stripslashes($richter->nachname ?? '');
	if (($CB != 'ZS') && ($CB != 'WT')) {
		$content .= '<br>' . ($richternummer->richternummer ?? '') . ' (' . stripslashes($richternummer->verein ?? '') . ')';
	}
	$content .= '
					</td>
				</tr>
			';
	$richter = $wpdb->get_row("SELECT * from " . $wpdb->prefix . "lgrichter where id like " . $richterliste->po);
	$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . ($richter->id ?? '0') . ") and (" . $filter . " > 0)");
	$content .= '
				<tr>
					<td align="right">' . getPOTEXT($CB) . ':</td>
					<td width="20px"></td>
					<td align="left">' . stripslashes($richter->vorname ?? '') . ' ' . stripslashes($richter->nachname ?? '');
	if ($CB != 'ZS') {
		$content .= '<br>' . ($richternummer->richternummer ?? '') . ' (' . stripslashes($richternummer->verein ?? '') . ')';
	}
	$content .= '
					</td>
				</tr>
			';
	$richter = $wpdb->get_row("SELECT * from " . $wpdb->prefix . "lgrichter where id like " . $richterliste->r2);
	$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . ($richter->id ?? '0') . ") and (" . $filter . " > 0)");
	$content .= '
				<tr>
					<td align="right">' . getR2TEXT($CB) . ':</td>
					<td width="20px"></td>
					<td align="left">' . stripslashes($richter->vorname ?? '') . ' ' . stripslashes($richter->nachname ?? '');
	if ($CB != 'ZS') {
		$content .= '<br>' . ($richternummer->richternummer ?? '') . ' (' . stripslashes($richternummer->verein ?? '') . ')';
	}
	$content .= '
					</td>
				</tr>
			';
	$richter = $wpdb->get_row("SELECT * from " . $wpdb->prefix . "lgrichter where id like " . $richterliste->r3);
	$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . ($richter->id ?? '0') . ") and (" . $filter . " > 0)");
	if (($CB != 'ZS') && ($CB != 'BP') && (($richter->nachname ?? '') > '')) {
		$content .= '
				<tr>
					<td align="right">' . getR3TEXT($CB) . ':</td>
					<td width="20px"></td>
					<td align="left">' . stripslashes($richter->vorname) . ' ' . stripslashes($richter->nachname);
		if (($CB != 'ZS') && ($richternummer->richternummer > '')) {
			$content .= '<br>' . $richternummer->richternummer . ' (' . stripslashes($richternummer->verein) . ')';
		}
		$content .= '
					</td>
				</tr>
			';
	}
	$richter = $wpdb->get_row("SELECT * from " . $wpdb->prefix . "lgrichter where id like " . $richterliste->ra);
	$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . ($richter->id ?? '0') . ") and (" . $filter . " > 0)");
	if (($richter->nachname ?? '') > '') {
		$content .= '
				<tr>
					<td align="right">' . getRATEXT($CB) . ':</td>
					<td width="20px"></td>
					<td align="left">' . stripslashes($richter->vorname) . ' ' . stripslashes($richter->nachname);
		if ($CB != 'ZS') {
			$content .= '<br>' . $richternummer->richternummer . ' (' . stripslashes($richternummer->verein) . ')';
		}
		$content .= '
					</td>
				</tr>
			';
	}
	$termin_user = get_post_meta($post_id, 'terminuser', true);
	$userdata = get_user_meta($termin_user);
	$content .= '
				<tr>
					<td align="right">Meldestelle:</td>
					<td width="20px"></td>
					<td align="left">' . $userdata['first_name'][0] . ' ' . $userdata['last_name'][0] . '</td>
				</tr>
			';
	$content .= '
			</table>
			</div>
		';
	$pdf->SetFont('times', 'B', 8);
	$pdf->MultiCell(128, 20, $content, 0, 'C', 0, 1, 178, 145, true, 0, true);
	$pdf->MultiCell(128, 185, '', 1, 'L', 0, 0, 159, 10);
	$pdf->AddPage('L', 'A4');
	$pdf->SetFont('times', 'B', 8);
	$pdf->MultiCell(128, 185, 'Notizen', 1, 'L', 0, 0, 10, 10,);
	$pdf->MultiCell(128, 185, '', 1, 'L', 0, 0, 159, 10);
	$pdf->AddPage('L', 'A4');
	$pdf->SetFont('times', 'B', 8);
	$pdf->MultiCell(128, 185, 'Notizen', 1, 'L', 0, 0, 10, 10,);
	$pdf->MultiCell(128, 185, '', 1, 'L', 0, 0, 159, 10);
	$image_file = plugin_dir_path(__DIR__) . '/img/' . $CB . '.jpg';
	$pdf->IMAGE($image_file, 160, 11, 126, 183, 'JPG', '', 'T', true, 150, '', false, false, 0, true, false, false);
	$pdf->AddPage('L', 'A4');
	$pdf->SetFont('times', 'B', 8);
	$pdf->MultiCell(128, 185, 'Notizen', 1, 'L', 0, 0, 10, 10,);
	$pdf->MultiCell(128, 185, '', 1, 'L', 0, 0, 159, 10);
	$image_file = plugin_dir_path(__DIR__) . '/img/' . $CB . '.jpg';
	$pdf->IMAGE($image_file, 160, 11, 126, 183, 'JPG', '', 'T', true, 150, '', false, false, 0, true, false, false);
	$pdf->AddPage('L', 'A4');
	$pdf->SetFont('times', 'B', 8);
	$pdf->MultiCell(128, 185, 'Meldungen', 1, 'L', 0, 0, 10, 10,);
	$pdf->MultiCell(128, 185, '', 1, 'L', 0, 0, 159, 10);

	$meldungen = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id);
	$content = '<table style="width: 400px;">';
	$zaehler = 0;
	$i = 0;
	foreach ($meldungen as $meldung) {
		$i++;
		$content .= '<tr><td style="width: 20px;">' . $i . '</td><td style="width: 200px;">' . stripslashes($meldung->hund_name) . '</td>';
		$content .= '<td style="width: 30px;">' . $meldung->hund_rh . '</td>';
		$content .= '<td style="width: 150px;text-align: right;">ZB-Nr.:' . $meldung->hund_zbnr . '</td></tr>';
		$content .= "<tr><td></td><td>gew.: " . $meldung->hund_wurftag . "</td>";
		$content .= '<td colspan="2" style="text-align: right;">Chip-Nr.: ' . $meldung->hund_chipnr . '</td></tr>';
		$content .= "<tr><td></td><td>nach: " . stripslashes($meldung->hund_vater) . "</td>";
		$content .= '<td colspan="2" style="text-align: right;">aus: ' . stripslashes($meldung->hund_mutter) . '</td></tr>';
		$content .= '<tr><td></td><td colspan="3">Besitzer: ' . stripslashes($meldung->e_name) . ' (' . stripslashes($meldung->e_plzort) . ')</td></tr>';
		$content .= '<tr><td></td><td colspan="3">Führer: ' . stripslashes($meldung->f_name) . '</td></tr>';
		$content .= "<tr><td></td></tr>";
	}
	$content .= "</table>";
	$pdf->MultiCell(128, 185, $content, 0, 'L', 0, 1, 10, 14, true, 0, true);


	$image_file = plugin_dir_path(__DIR__) . '/img/' . $CB . '.jpg';
	$pdf->IMAGE($image_file, 160, 11, 126, 183, 'JPG', '', 'T', true, 150, '', false, false, 0, true, false, false);
	$pdf->AddPage('L', 'A4');
	$pdf->SetFont('times', 'B', 8);
	$pdf->MultiCell(128, 185, 'Notizen', 1, 'L', 0, 0, 10, 10,);
	$pdf->MultiCell(128, 185, '', 1, 'L', 0, 0, 159, 10);
	$image_file = plugin_dir_path(__DIR__) . '/img/' . $CB . '.jpg';
	$pdf->IMAGE($image_file, 160, 11, 126, 183, 'JPG', '', 'T', true, 150, '', false, false, 0, true, false, false);
	$pdf->AddPage('L', 'A4');
	$pdf->SetFont('times', 'B', 8);
	$pdf->MultiCell(128, 185, 'Notizen', 1, 'L', 0, 0, 10, 10,);
	$pdf->MultiCell(128, 185, '', 1, 'L', 0, 0, 159, 10);
	$image_file = plugin_dir_path(__DIR__) . '/img/' . $CB . '.jpg';
	$pdf->IMAGE($image_file, 160, 11, 126, 183, 'JPG', '', 'T', true, 150, '', false, false, 0, true, false, false);
	$pdf->AddPage('L', 'A4');
	$pdf->SetFont('times', 'B', 8);
	$pdf->MultiCell(128, 185, 'Notizen', 1, 'L', 0, 0, 10, 10,);
	$pdf->MultiCell(128, 185, '', 1, 'L', 0, 0, 159, 10);
	$image_file = plugin_dir_path(__DIR__) . '/img/' . $CB . '.jpg';
	$pdf->IMAGE($image_file, 160, 11, 126, 183, 'JPG', '', 'T', true, 150, '', false, false, 0, true, false, false);
	$pdf->Output('Richterbuch_' . $title . '_' . $termin_date . '_' . $ort . '.pdf', 'I');
}
