<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
add_shortcode('LG_Statistik', 'lg_statistik');

function eintrag ($post_id)
{
    global $wpdb;
    $gemeldet = 0;
    $meldegeld = 0;
    $meldungen = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id . " ORDER BY sortierung,id");
    foreach ($meldungen as $meldung) {
        $gemeldet++;
        $wert = (int)$meldung->zahlung_betrag;
        $meldegeld = $meldegeld + $wert;
    }
    $meldegeld = getMeldegeld($post_id);
    $gemeldet = getMeldungen_Count($post_id);
    $meldung_daten = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgmeldungendaten where postid like " . $post_id);
    if ($meldung_daten <> NULL){
    $myarray = array (
        "title" => get_the_title($post_id),
        "ort" => get_post_meta($post_id, 'terminort', true),
        "datum" => date("d.m.Y", strtotime(get_post_meta($post_id, 'termindate', true))),
        "gemeldet" => $gemeldet,
        "erschienen" => $meldung_daten->meldung_p_erschienen,
        "bestanden" =>$meldung_daten->meldung_p_bestanden,
        "ausgefallen" => get_post_meta($post_id, 'terminausfall', true),
        "freigabe" => get_post_meta($post_id, 'terminfreigabe', true),
        "meldegeld" => $meldegeld,
        "richterkosten" => str_replace(',','.',stripslashes($meldung_daten->meldung_s_kostenrichter)),
        "kostensonstiges" => str_replace(',','.',stripslashes($meldung_daten->meldung_s_kostensonstige)),
        "einnahmensonstiges" => str_replace(',','.',stripslashes($meldung_daten->meldung_s_einnahmensonstige)),
        "spendenrichter" => str_replace(',','.',stripslashes($meldung_daten->meldung_s_spenderichter)),
        "ergebniss" => $meldegeld-str_replace(',','.',stripslashes($meldung_daten->meldung_s_kostenrichter))-str_replace(',','.',stripslashes($meldung_daten->meldung_s_kostensonstige))+str_replace(',','.',stripslashes($meldung_daten->meldung_s_einnahmensonstige))+str_replace(',','.',stripslashes($meldung_daten->meldung_s_spenderichter))
    );
} else {
    $myarray = array (
        "title" => get_the_title($post_id),
        "ort" => get_post_meta($post_id, 'terminort', true),
        "datum" => date("d.m.Y", strtotime(get_post_meta($post_id, 'termindate', true))),
        "gemeldet" => $gemeldet,
        "erschienen" => '0',
        "bestanden" =>'0',
        "ausgefallen" => get_post_meta($post_id, 'terminausfall', true),
        "freigabe" => get_post_meta($post_id, 'terminfreigabe', true),
        "meldegeld" => $meldegeld,
        "richterkosten" => '0',
        "kostensonstiges" => '0',
        "einnahmensonstiges" => '0',
        "spendenrichter" => '0',
        "ergebniss" => $meldegeld
    );
}
    return $myarray;
}

function lg_statistik()
{
    global $wpdb;
    require_once('forall.php');
    wp_enqueue_style("zz-shortcode-jscss-style2");
    wp_enqueue_script('jquery');
    wp_enqueue_script("zz-shortcode-jscss-script2", array('jquery'), '1.0', true);
    $lg_content = '';
    //$year_2 = '2024'; //date('Y');
    $year_2 = get_query_var('foryear',date('Y'));
	$start_date_2 = $year_2 . '-01-01';
	$end_date_2 = $year_2 . '-12-31';
    $iyear = date('Y');
	$maxyear = get_option('lg_kalender_settings_counter_jahre', '');
	$nextyear = 1;
	
    $lg_content .= '<p>Statistikseite';
    $lg_content = '
	<div class = "wrap">
    <br><br>
	<form method="POST" id="form1">
	<label for="yeartime"><h4>Jahr auswählen:</h4></label>
	<select name="foryear" id="yeartime" onchange="form.submit()">';
	
	$nextyear='1';
	for ($i = $iyear + $nextyear; $i > ($iyear - $maxyear); $i--) {
		$lg_content .= '<option value="' . ($i) . '" ';
		if (($i) == $year_2) {
			$lg_content .= 'selected ';
		}
		$lg_content .= '>' . ($i) . '</option>';
	}
	$lg_content .= '
		</select>
		</form>
		<br>
        </div>
		';

        $args_2 = array(
            'post_type' => 'lgkalender_termin',
            'post_status' => array('publish', 'draft', 'pending'),
            'posts_per_page' => -1,
            'meta_key' => 'termindate',
            'orderby' => 'meta_value',
            'order' => 'ASC',
            'meta_query' => array(
                'relation' => 'AND',
                array(
                    'key' => 'termindate',
                    'value' => array($start_date_2, $end_date_2),
                    'compare' => 'BETWEEN',
                    'type' => 'DATE'
                ),
                array(
                    'key' => 'terminmeldeschein',
                    'value' => 'on',
                    'compare' => '='
                ),
                array(
                    'key' => 'termingruppe',
                    'value' => '-1',
                    'compare' => '='
                )
            )
        );
        // start des WordPress Loops für unseren post type
        $bp = 0;
        $jp = 0;
        $zp = 0;
        $gp = 0;
        $wt = 0;
        $zs = 0;
        $vstp = 0;
        $sjg = 0;
        $loop_2 = new WP_Query($args_2);
        while ($loop_2->have_posts()):
            $loop_2->the_post();
            $post_id = get_the_ID();
            $title = get_the_title($post_id);
		    $CB=getPruefung($title);
            //$lg_content.='<p>'.$title.' : ('.$CB.') : ('.$jp.')<br>';
            if ($CB == 'JP') {
                $jp++;
                $jp_items[$jp]=$post_id;
            }
            if ($CB == 'BP') {
                $bp++;
                $bp_items[$bp]=$post_id;
            }
            if ($CB == 'ZP') {
                $zp++;
                $zp_items[$zp]=$post_id;
            }
            if ($CB == 'GP') {
                $gp++;
                $gp_items[$gp]=$post_id;
            }
            if ($CB == 'WT') {
                $wt++;
                $wt_items[$wt]=$post_id;
            }
            if ($CB == 'ZS') {
                $zs++;
                $zs_items[$zs]=$post_id;
            }
            if ($CB == 'VStP') {
                $vstp++;
                $vstp_items[$vstp]=$post_id;
            }
            if ($CB == 'SJG') {
                $sjg++;
                $sjg_items[$sjg]=$post_id;
            }
        endwhile;
        $lg_content.='
        <table class="treetable">
        <thead>
        <tr><th width=35%>Prüfung</th><th width=5%>Status</th><th width=15%>Datum</th><th width=15%>gemeldet</th><th width=15%>erschienen</th><th width=15%>bestanden</th><tr>
        </thead>
<tbody>
<tr class="c0"> <td>Junghundprüfung (JP)</td></tr>';
for ($i=1; $i<($jp+1); $i++){
    $zeile = eintrag ($jp_items[$i]);
    if ($zeile['freigabe']=='on'){$zeile_farbe ='green';}else{$zeile_farbe='red';}
    if ($zeile['ausgefallen']=='on'){$zeile_farbe = 'yellow';}
    $lg_content.='<tr class="c1"><td>'.$zeile['title'].' '.$zeile['ort'].'</td><td bgcolor="'.$zeile_farbe.'"> </td><td>'.$zeile['datum'].'</td><td>'.$zeile['gemeldet'].'</td><td>'.$zeile['erschienen'].'</td><td>'.$zeile['bestanden'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Meldegeld</td><td>'.$zeile['meldegeld'].'</td><td>Kosten Richter</td><td>'.$zeile['richterkosten'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Sonstige Einnahmen</td><td>'.$zeile['einnahmensonstiges'].'</td><td>Sonstige Ausgaben</td><td>'.$zeile['kostensonstiges'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Spenden Richter</td><td>'.$zeile['spendenrichter'].'</td><td>Ergebnis Prüfung</td><td><b><u>'.number_format($zeile['ergebniss'], 2, ',', '').'</u></b></td></tr>';
}
$lg_content.='
<tr class="c0"> <td>Bauprüfung (BP)</td></tr>';
for ($i=1; $i<($bp+1); $i++){
    $zeile = eintrag ($bp_items[$i]);
    if ($zeile['freigabe']=='on'){$zeile_farbe ='green';}else{$zeile_farbe='red';}
    if ($zeile['ausgefallen']=='on'){$zeile_farbe = 'yellow';}
    $lg_content.='<tr class="c1"><td>'.$zeile['title'].' '.$zeile['ort'].'</td><td bgcolor="'.$zeile_farbe.'"> </td><td>'.$zeile['datum'].'</td><td>'.$zeile['gemeldet'].'</td><td>'.$zeile['erschienen'].'</td><td>'.$zeile['bestanden'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Meldegeld</td><td>'.$zeile['meldegeld'].'</td><td>Kosten Richter</td><td>'.$zeile['richterkosten'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Sonstige Einnahmen</td><td>'.$zeile['einnahmensonstiges'].'</td><td>Sonstige Ausgaben</td><td>'.$zeile['kostensonstiges'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Spenden Richter</td><td>'.$zeile['spendenrichter'].'</td><td>Ergebnis Prüfung</td><td><b><u>'.number_format($zeile['ergebniss'], 2, ',', '').'</u></b></td></tr>';
}

$lg_content.='
<tr class="c0"> <td>Zuchtprüfung (ZP)</td></tr>';
for ($i=1; $i<($zp+1); $i++){
    $zeile = eintrag ($zp_items[$i]);
    if ($zeile['freigabe']=='on'){$zeile_farbe ='green';}else{$zeile_farbe='red';}
    if ($zeile['ausgefallen']=='on'){$zeile_farbe = 'yellow';}
    $lg_content.='<tr class="c1"><td>'.$zeile['title'].' '.$zeile['ort'].'</td><td bgcolor="'.$zeile_farbe.'"> </td><td>'.$zeile['datum'].'</td><td>'.$zeile['gemeldet'].'</td><td>'.$zeile['erschienen'].'</td><td>'.$zeile['bestanden'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Meldegeld</td><td>'.$zeile['meldegeld'].'</td><td>Kosten Richter</td><td>'.$zeile['richterkosten'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Sonstige Einnahmen</td><td>'.$zeile['einnahmensonstiges'].'</td><td>Sonstige Ausgaben</td><td>'.$zeile['kostensonstiges'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Spenden Richter</td><td>'.$zeile['spendenrichter'].'</td><td>Ergebnis Prüfung</td><td><b><u>'.number_format($zeile['ergebniss'], 2, ',', '').'</u></b></td></tr>';

}
$lg_content.='
<tr class="c0"> <td>Gebrauchsprüfung (GP)</td></tr>';
for ($i=1; $i<($gp+1); $i++){
    $zeile = eintrag ($gp_items[$i]);
    if ($zeile['freigabe']=='on'){$zeile_farbe ='green';}else{$zeile_farbe='red';}
    if ($zeile['ausgefallen']=='on'){$zeile_farbe = 'yellow';}
    $lg_content.='<tr class="c1"><td>'.$zeile['title'].' '.$zeile['ort'].'</td><td bgcolor="'.$zeile_farbe.'"> </td><td>'.$zeile['datum'].'</td><td>'.$zeile['gemeldet'].'</td><td>'.$zeile['erschienen'].'</td><td>'.$zeile['bestanden'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Meldegeld</td><td>'.$zeile['meldegeld'].'</td><td>Kosten Richter</td><td>'.$zeile['richterkosten'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Sonstige Einnahmen</td><td>'.$zeile['einnahmensonstiges'].'</td><td>Sonstige Ausgaben</td><td>'.$zeile['kostensonstiges'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Spenden Richter</td><td>'.$zeile['spendenrichter'].'</td><td>Ergebnis Prüfung</td><td><b><u>'.number_format($zeile['ergebniss'], 2, ',', '').'</u></b></td></tr>';
}
$lg_content.='
<tr class="c0"> <td>Wesenstest (WT)</td></tr>';
for ($i=1; $i<($wt+1); $i++){
    $zeile = eintrag ($wt_items[$i]);
    if ($zeile['freigabe']=='on'){$zeile_farbe ='green';}else{$zeile_farbe='red';}
    if ($zeile['ausgefallen']=='on'){$zeile_farbe = 'yellow';}
    $lg_content.='<tr class="c1"><td>'.$zeile['title'].' '.$zeile['ort'].'</td><td bgcolor="'.$zeile_farbe.'"> </td><td>'.$zeile['datum'].'</td><td>'.$zeile['gemeldet'].'</td><td>'.$zeile['erschienen'].'</td><td>'.$zeile['bestanden'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Meldegeld</td><td>'.$zeile['meldegeld'].'</td><td>Kosten Richter</td><td>'.$zeile['richterkosten'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Sonstige Einnahmen</td><td>'.$zeile['einnahmensonstiges'].'</td><td>Sonstige Ausgaben</td><td>'.$zeile['kostensonstiges'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Spenden Richter</td><td>'.$zeile['spendenrichter'].'</td><td>Ergebnis Prüfung</td><td><b><u>'.number_format($zeile['ergebniss'], 2, ',', '').'</u></b></td></tr>';
}
$lg_content.='
<tr class="c0"> <td>Zuchtschau (ZS)</td></tr>';
for ($i=1; $i<($zs+1); $i++){
    $zeile = eintrag ($zs_items[$i]);
    if ($zeile['freigabe']=='on'){$zeile_farbe ='green';}else{$zeile_farbe='red';}
    if ($zeile['ausgefallen']=='on'){$zeile_farbe = 'yellow';}
    $lg_content.='<tr class="c1"><td>'.$zeile['title'].' '.$zeile['ort'].'</td><td bgcolor="'.$zeile_farbe.'"> </td><td>'.$zeile['datum'].'</td><td>'.$zeile['gemeldet'].'</td><td>'.$zeile['erschienen'].'</td><td>'.$zeile['bestanden'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Meldegeld</td><td>'.$zeile['meldegeld'].'</td><td>Kosten Richter</td><td>'.$zeile['richterkosten'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Sonstige Einnahmen</td><td>'.$zeile['einnahmensonstiges'].'</td><td>Sonstige Ausgaben</td><td>'.$zeile['kostensonstiges'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Spenden Richter</td><td>'.$zeile['spendenrichter'].'</td><td>Ergebnis Prüfung</td><td><b><u>'.number_format($zeile['ergebniss'], 2, ',', '').'</u></b></td></tr>';
}
$lg_content.='
<tr class="c0"> <td>Saujager - Gatter (SJG)</td></tr>';
for ($i=1; $i<($sjg+1); $i++){
    $zeile = eintrag ($sjg_items[$i]);
    if ($zeile['freigabe']=='on'){$zeile_farbe ='green';}else{$zeile_farbe='red';}
    if ($zeile['ausgefallen']=='on'){$zeile_farbe = 'yellow';}
    $lg_content.='<tr class="c1"><td>'.$zeile['title'].' '.$zeile['ort'].'</td><td bgcolor="'.$zeile_farbe.'"> </td><td>'.$zeile['datum'].'</td><td>'.$zeile['gemeldet'].'</td><td>'.$zeile['erschienen'].'</td><td>'.$zeile['bestanden'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Meldegeld</td><td>'.$zeile['meldegeld'].'</td><td>Kosten Richter</td><td>'.$zeile['richterkosten'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Sonstige Einnahmen</td><td>'.$zeile['einnahmensonstiges'].'</td><td>Sonstige Ausgaben</td><td>'.$zeile['kostensonstiges'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Spenden Richter</td><td>'.$zeile['spendenrichter'].'</td><td>Ergebnis Prüfung</td><td><b><u>'.number_format($zeile['ergebniss'], 2, ',', '').'</u></b></td></tr>';
    
}
$lg_content.='
<tr class="c0"> <td>Verbands-Stöberprüfung (VStP)</td></tr>';
for ($i=1; $i<($vstp+1); $i++){
    $zeile = eintrag ($vstp_items[$i]);
    if ($zeile['freigabe']=='on'){$zeile_farbe ='green';}else{$zeile_farbe='red';}
    if ($zeile['ausgefallen']=='on'){$zeile_farbe = 'yellow';}
    $lg_content.='<tr class="c1"><td>'.$zeile['title'].' '.$zeile['ort'].'</td><td bgcolor="'.$zeile_farbe.'"> </td><td>'.$zeile['datum'].'</td><td>'.$zeile['gemeldet'].'</td><td>'.$zeile['erschienen'].'</td><td>'.$zeile['bestanden'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Meldegeld</td><td>'.$zeile['meldegeld'].'</td><td>Kosten Richter</td><td>'.$zeile['richterkosten'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Sonstige Einnahmen</td><td>'.$zeile['einnahmensonstiges'].'</td><td>Sonstige Ausgaben</td><td>'.$zeile['kostensonstiges'].'</td></tr>';
    $lg_content.='<tr class="c2" bgcolor="eeeeee"><td colspan=2></td><td>Spenden Richter</td><td>'.$zeile['spendenrichter'].'</td><td>Ergebnis Prüfung</td><td><b><u>'.number_format($zeile['ergebniss'], 2, ',', '').'</u></b></td></tr>';
}

$lg_content.='
</tbody>
<tfoot>
<tr><td colspan=6><br>
 <table>
    <tr>
    <td width=5% bgcolor="green"> </td>
    <td width=28%> - Bericht freigegeben</td>
    <td width=5% bgcolor="red"> </td>
    <td width=28%> - Bericht steht noch aus</td>
    <td width=5% bgcolor="yellow"> </td>
    <td width=29%> - ausgefallen</td>
    </tr>
 </table>
</td></tr>
</tfoot>
</table>
        ';
        
    if (is_user_logged_in()) {
		return $lg_content;
	} else {
		return '';
	}
}