<?php
add_shortcode('LG_Kalendershort', 'lg_kalendershort'); //deprecated

add_shortcode('LG_Kalender_kurz', 'lg_kalendershort'); //neu ab V1.6.13

function lg_kalendershort()
{
	wp_enqueue_style("zz-shortcode-jscss-style");
	$css = '
		#lg_kalender_hinweis {color:' . get_option('lg_kalender_settings_farbe_hinweis', '#ff0000') . ';}
		#lg_kalender_hinweis {font-size:' . get_option('lg_kalender_settings_size_hinweis_short', 'unset') . ';}
	';
	wp_add_inline_style('zz-shortcode-jscss-style', $css);
	$year = get_query_var('foryear',date('Y'));
	$year_today = date('Y');
	$day_today = date('d.m.Y');
	$start_date = $year . '-01-01';
	$month_now = date('n');
	$nextyear = get_option('lg_kalender_settings_next_year', false);
	if ($nextyear != '1') {
		$nextyear = '0';
	} 
	if ((($month_now < '9') && ($nextyear == '1'))&&(!is_user_logged_in())){
		$nextyear = '0';
		update_option('lg_kalender_settings_next_year', false);
	}
	$end_date = ($year + $nextyear) . '-12-31';
	$tags = 0;
	$maxtags = get_option('lg_kalender_settings_counter_termine', '1');
	$lg_content = '
	<div class = "kalender_short">
		';

	$lg_content .= '
		<table>
			';
	$args = array(
		'post_type' => 'lgkalender_termin',
		'post_status' => array('publish'),
		'posts_per_page' => -1,
		'meta_key' => 'termindate',
		'orderby' => 'meta_value',
		'order' => 'ASC',
		'meta_query' => array(
			array(
				'key' => 'termindate',
				'meta-value' => $value,
				'value' => array($start_date, $end_date),
				'compare' => 'BETWEEN',
				'type' => 'DATE'
			)
		)
	);
	$loop = new WP_Query($args);
	// start des WordPress Loops für unseren post type

	while ($loop->have_posts()):
		$loop->the_post();
		// post id abfragen
		$post_id = get_the_ID();
		// abfrage unseres custom fields "position"
		$title = get_the_title($post_id);
		$post_url = get_post_permalink($post_id);
		$datum1 = new DateTime($day_today);
		$datum2 = new DateTime(date("Y-m-d", strtotime(get_post_meta($post_id, 'termindate', true))));
		$termin_ort = stripslashes(get_post_meta($post_id, 'terminort', true));
		$termin_neu = get_post_meta($post_id, 'terminneu', true);
		$termin_aenderung = get_post_meta($post_id, 'terminaenderung', true);
		$termin_date = date("d.m.Y", strtotime(get_post_meta($post_id, 'termindate', true)));
		$termin_date_BP = date("m.Y", strtotime(get_post_meta($post_id, 'termindate', true)));
		$termin_date_end = date("d.m.Y", strtotime(get_post_meta($post_id, 'termindateend', true)));
		$termin_date_time = get_post_meta($post_id, 'termindatetime', true);
		$termin_date_cash = get_post_meta($post_id, 'termindatecash', true);
		$termin_user = get_post_meta($post_id, 'terminuser', true);
		$userdata = get_user_meta($termin_user);
		$termin_user = '<b>Nennung an:</b> ' . $userdata['first_name'][0] . ' ' . $userdata['last_name'][0] . ',' . $userdata['description'][0];
		$termin_min = get_post_meta($post_id, 'terminmin', true);
		$termin_max = get_post_meta($post_id, 'terminmax', true);
		$termin_ausfall = get_post_meta($post_id, 'terminausfall', true);
		$termin_ausgebucht = get_post_meta($post_id, 'terminausgebucht', true);
		$termin_meldeschein = get_post_meta($post_id, 'terminmeldeschein', true);
		$termin_bilderanzahl = esc_attr(get_post_meta($post_id, 'terminbilderanzahl', true));
		$termin_dateilink = get_post_meta($post_id, 'termindateilink', true);
		$termin_dateitext = get_post_meta($post_id, 'termindateitext', true);
		$termin_meldeschein = get_post_meta($post_id, 'terminmeldeschein', true);
		if ($termin_neu == 'on') {
			$termin_neu = 'Neu';
		} else {
			$termin_neu = '';
		}
		if ($termin_aenderung == 'on') {
			$termin_aenderung = 'Änderung';
		} else {
			$termin_aenderung = '';
		}
		if (($termin_date_end > '') and ($termin_date_end <> '01.01.1970')) {
			$termin_date = $termin_date . ' - ' . $termin_date_end;
		}
		if ($termin_date_time > '') {
			$termin_date = $termin_date . '<br>' . $termin_date_time . ' Uhr';
		}
		if ($termin_date_cash > '') {
			$termin_date_cash = 'Meldegebühr: <b>' . $termin_date_cash . '</b>';
		}
		if ($termin_min > '') {
			$termin_min = '(min. ' . $termin_min;
		} else {
			$termin_min = '';
		}
		if ($termin_max > '') {
			$termin_min = $termin_min . ', max. ' . $termin_max;
		}
		if ($termin_min > '') {
			$termin_min = $termin_min . ' PRT)';
		}
		if ($termin_ausfall == 'on') {
			$termin_ausfall = '>>fällt leider aus<<';
		} else {
			$termin_ausfall = '';
		}
		if ($termin_ausgebucht == 'on') {
			$termin_ausgebucht = '>>bereits ausgebucht<<';
		} else {
			$termin_ausgebucht = '';
		}
		if ($termin_bilderanzahl > 0) {
			$post_url = '<p><a href="' . $post_url . '">Bericht</a></p>';
		} else {
			$post_url = '';
		}
		if ($termin_dateitext > '') {
		} else {
			$termin_dateitext = 'Link';
		}
		if ($termin_dateilink > '') {
			$termin_dateilink = '<p><a href="' . $termin_dateilink . '" target="_blank">' . $termin_dateitext . '</a></p>';
		} else {
			$termin_dateilink = '';
		}
		if ($termin_meldeschein == 'on') {
			$termin_meldeschein = '<p><a href="' . get_post_permalink($post_id) . '&downloadmeldeschein=true" class="button">download Meldeschein</a></p>';
		} else {
			$termin_meldeschein = '';
		}
		if ($year <> $year_today) {
			$termin_ausgebucht = '';
			$termin_dateilink = '<br>';
			$termin_user = '';
		}
		if ($datum1 > $datum2) {
			$termin_meldeschein = '';
			if ($termin_ausfall == '>>fällt leider aus<<') {
				$termin_ausfall = '>>ist leider ausgefallen<<';
			}
		}
		//prüfen, ob Prüfung BP ist. Dann Ort löschen und Termin nur Monat ausgeben
		if (strpos($title, '(BP)') !== false) {
			$termin_ort = '';
			$termin_date = $termin_date_BP;
		}
		// Template Ausgabe
		if (($datum2 >= $datum1) and ($tags < $maxtags)) {
			$lg_content .= '
	<tr>
		<td valign=top><b>' . $termin_date . '</b><br><br><p id="lg_kalender_hinweis">' . $termin_neu . '<br>' . $termin_aenderung . '</p></td>
		<td colspan=2 valign=top><b>' . $title . '</b><br><small><b>' . $termin_ort . '</b></small><br><p id="lg_kalender_hinweis">' . $termin_ausgebucht . '<br>' . $termin_ausfall . '</p></td>
	</tr>';
			$tags = $tags + 1;
		}
	endwhile;
	$lg_content .= '
</table>';
	$lg_content .= '</div>';
	return $lg_content;
}
?>