<?php

// the full http path to the PDF form
require_once('FPDI-master/src/autoload.php');
require_once('FPDF-master/fpdf.php');
require_once('pdf-merger-main/src/PDFMerger/PDFMerger.php');
$zahl = rand(1000, 9999999); //Zufallszahl für Dateinamen_prefix
$post_id = get_query_var('bericht');
$title = get_the_title($post_id);
$data['flattern'] = false;
$url = 'https://nienhausen.com/mypdftk';
$url = file_get_contents($url);
/*
if (strstr($title, '(JP)')) {
	$CB = 'JP';
}
if (strstr($title, '(BP)')) {
	$CB = 'BP';
}
if (strstr($title, '(ZP)')) {
	$CB = 'ZP';
}
if (strstr($title, '(WT)')) {
	$CB = 'WT';
}
if (strstr($title, '(ZS)')) {
	$CB = 'ZS';
}
if (strstr($title, '(GP)')) {
	$CB = 'GP';
}
if (strstr($title, '(SJG)')) {
	$CB = 'SJG';
}
if (strstr($title, '(VStP)')) {
	$CB = 'VStP';
}
*/
$CB = getPruefung($title);
// Formblatt 2 JGHV
if (get_query_var('leistungsnachweis') == 'form2') {
	$data['file'] = get_option('lg_kalender_settings_pfad7', true);
	$data['newfile'] = 'Formblatt_2.pdf';
	$data['Veranstaltender Verein bzw Vereine'] = 'Parson Russell Terrier Club Deutschland';
	$data['EDVNr'] = '3305';
	$data['Ort ein Wort'] = get_post_meta($post_id, 'terminort', true);
	$data['am'] = date('d.m.Y', strtotime(get_post_meta($post_id, 'termindate', true)));
	//$data['undefined_62'] = date('d.m.Y', strtotime(get_post_meta($post_id, 'termindate', true)));
	$richterliste = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgmeldungenrichter WHERE postid like " . $post_id);
	$richter = $wpdb->get_row("SELECT * from " . $wpdb->prefix . "lgrichter where id like " . $richterliste->pl);
	$filter = 'norm';
	$row = 0;
	$richterid = 0;
	$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . ($richter->id ?? '0') . ") and (" . $filter . " > 0)");
	$data['Name'] = ($richter->vorname ?? '') . ' ' . ($richter->nachname ?? '');
	$data['VRNummer'] = ($richternummer->richternummer ?? '');
	//$data['VRNummerRow'.$row] = $richternummer->richternummer;
	$data['Anschrift'] = ($richter->strasse ?? '') . ', ' . ($richter->plz ?? '') . ' ' . ($richter->ort ?? '');
	//$data['Name Vorname PLZ WohnortRow'.$row]=$richter->nachname . ', ' . $richter->vorname.', '.$richter->plz.' '.$richter->ort;
	$data['TelNr'] = ($richter->mobil ?? '');
	$richterliste2 = $wpdb->get_results("SELECT * from " . $wpdb->prefix . "lgrichter where (id = " . $richterliste->po . ") or (id = " . $richterliste->pl . ") or (id = " . $richterliste->r2 . ") or (id = " . $richterliste->r3 . ") order by nachname, vorname");
	foreach ($richterliste2 as $richter) {
		if ($richterid <> $richter->id) {
			if ($richterliste->pl == $richter->id) {
				$richterid = $richter->id;
			}
			$row++;
			$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . $richter->id . ") and (" . $filter . " > 0)");
			//$data['Name'] = $richter->vorname . ' ' . $richter->nachname;
			//$data['VRNummer'] = $richternummer->richternummer;
			$data['VRNummerRow' . $row] = ($richternummer->richternummer ?? '');
			//$data['Anschrift'] = $richter->strasse .', '.$richter->plz.' '.$richter->ort;
			$data['Name Vorname PLZ WohnortRow' . $row] = ($richter->nachname ?? '') . ', ' . ($richter->vorname ?? '') . ', ' . ($richter->plz ?? '') . ' ' . ($richter->ort ?? '');
			//$data['TelNr'] = $richter-> mobil;
		}
	}
	$richter = $wpdb->get_row("SELECT * from " . $wpdb->prefix . "lgrichter where (id = " . $richterliste->ra . ")");
	if (($richterid <> $richter->id) && ($richter->id > 0)) {
		$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . ($richter->id ?? '0') . ") and (" . $filter . " > 0)");
		//$data['Name'] = $richter->vorname . ' ' . $richter->nachname;
		//$data['VRNummer'] = $richternummer->richternummer;
		$data['RANummerRow1'] = ($richternummer->richternummer ?? '');
		//$data['Anschrift'] = $richter->strasse .', '.$richter->plz.' '.$richter->ort;
		$data['Name VornameRow1'] = ($richter->nachname ?? '') . ', ' . ($richter->vorname ?? '');
		//$data['TelNr'] = $richter-> mobil;
	}
}
// Formblatt 91 JGHV
elseif (get_query_var('leistungsnachweis') == 'form91') {
	/*
	$laut = array(
		"0" => "--",
		"1" => "spl",
		"2" => "sil",
		"3" => "fl",
		"4" => "lt",
		"5" => "wdl",
		"6" => "stumm",
		"7" => "frgl.",
	);
	$wild = array(
		"1" => "sehr gut",
		"2" => "gut",
		"3" => "ausreichend",
		"4" => "kein",
	);
	$preis = array(
		"0" => "--",
		"1" => "I.",
		"2" => "II.",
		"3" => "III.",
		"4" => "n.b.",
		"5" => "nicht erschienen",
		"7" => "zurückgestellt",
		"8" => "bestanden",
	);
	*/
	$data['file'] = get_option('lg_kalender_settings_pfad8', true);
	$meldungen = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id . " order by sortierung");
	//$data['flattern'] = 'false';
	$data['newfile'] = 'Formblatt_91.pdf';
	$data['Name des Vereins'] = 'Parson Russell Terrier Club Deutschland';
	$data['EDVNr beim JGHV'] = '3305';
	$data['Prüfungsort'] = get_post_meta($post_id, 'terminort', true);
	$data['Prüfungsdatum'] = date('d.m.Y', strtotime(get_post_meta($post_id, 'termindate', true)));
	$gemeldet = 0;
	foreach ($meldungen as $meldung) {
		$gemeldet++;
		$row = $gemeldet - 1;
		$data['Name des HundesRow1__' . $row] = $meldung->hund_name ?? '';
		$data['RasseRow1__' . $row] = 'PRT';
		$data['ZBNrRow1__' . $row] = $meldung->hund_zbnr ?? '';
		$data['WurfdatumRow1__' . $row] = $meldung->hund_wurftag ?? '';
		$data['Name des FührersRow1__' . $row] = $meldung->f_name ?? '';
		$data['GesamtpktRow1__' . $row] = $meldung->punkte ?? '';
		$data['LautRow1__' . $row] = getLaut($meldung->laut);
		if ($meldung->preis == '4') {
			$data['PreisRow1__' . $row] = 'n.best.';
		}
		if ($meldung->preis == '5') {
			$data['PreisRow1__' . $row] = 'n.ersch.';
		}
	}
	$meldungen_daten = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgmeldungendaten where postid like " . $post_id);
	$data['gemeldet'] = $gemeldet;
	$data['erschienen'] = $meldungen_daten->meldung_p_erschienen ?? '';
	$data['durchgeprüft'] = $meldungen_daten->meldung_p_durchgp ?? '';
	$data['prämiert'] = $meldungen_daten->meldung_p_bestanden ?? '';
	$data['nicht bestanden'] = $meldungen_daten->meldung_p_erschienen - $meldungen_daten->meldung_p_bestanden;
	$data['Wildvorkommen'] = getWild($meldungen_daten->meldung_p_wild);
	$data['Wetter'] = $meldungen_daten->meldung_p_witterung ?? '';
}
// Reisekostenbeleg
elseif (get_query_var('leistungsnachweis') == 'rkbeleg') {
	$data['file'] = get_option('lg_kalender_settings_pfad5', true);
	$meldung = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgrichter where id like " . get_query_var('insert'));
	$data['Name'] = ''.($meldung->vorname ?? '') . ' ' . ($meldung->nachname ?? '');
	$data['newfile'] = 'Reisekostenabrechnung_' . ($meldung->vorname ?? '') . '_' . ($meldung->nachname ?? '') . '.pdf';
	if (isset($meldung->strasse)) {
		$strasse = $meldung->strasse;
	} else {
		$strasse = '';
	}
	$data['Strasse'] = $strasse;
	if (isset($meldung->plz)) {
		$plz = $meldung->plz;
	} else {
		$plz = '';
	}
	if (isset($meldung->ort)) {
		$ort = $meldung->ort;
	} else {
		$ort = '';
	}
	$data['PLZOrt'] = $plz . ' ' . $ort;
	$data['genehmigt'] = 'LG-' . get_option('lg_kalender_settings_name', true);
	$data['ADatum'] = date('d.m.Y', strtotime(get_post_meta($post_id, 'termindate', true)));
	$data['RDatum'] = date('d.m.Y', strtotime(get_post_meta($post_id, 'termindate', true)));
	$data['Datum'] = date('d.m.Y', strtotime(get_post_meta($post_id, 'termindate', true)));
	if (getPruefung($title) == 'JP') {
		$data['Zweck'] = 'Junghundprüfung';
		$data['Tage1'] = '1';
	}
	if (getPruefung($title) == 'BP') {
		$data['Zweck'] = 'Bauprüfung';
		$data['Tage1'] = '1';
	}
	if (getPruefung($title) == 'ZP') {
		$data['Zweck'] = 'Zuchtprüfung';
		$data['Tage1'] = '1';
	}
	if (getPruefung($title) == 'GP') {
		$data['Zweck'] = 'Gebrauchsprüfung';
		$data['Tage1'] = '2';
		$data['RDatum'] = date('d.m.Y', strtotime(get_post_meta($post_id, 'termindate', true)) + (3600 * 24));
		$data['Datum'] = date('d.m.Y', strtotime(get_post_meta($post_id, 'termindate', true)) + (3600 * 24));
	}
	if (getPruefung($title) == 'WT') {
		$data['Zweck'] = 'Wesenstest';
		$data['Tage1'] = '1';
	}
	if (getPruefung($title) == 'ZS') {
		$data['Zweck'] = 'Zuchtschau';
		$data['Tage2'] = '1';
	}
	if (getPruefung($title) == 'SJG') {
		$data['Zweck'] = 'Leistungsnachweis SJG';
		$data['Tage1'] = '1';
	}
	if (getPruefung($title) == 'VStP') {
		$data['Zweck'] = 'Verbandsstöberprüfung';
		$data['Tage1'] = '1';
	}
	$data['VOrt'] = get_post_meta($post_id, 'terminort', true) . ', ' . date('d.m.Y', strtotime(get_post_meta($post_id, 'termindate', true)));
	$data['IBAN'] = $meldung->iban ?? '';
	$data['Bank'] = $meldung->bank ?? '';
} elseif (get_query_var('leistungsnachweis') == 'alle') { //alle Zensurentafeln / Formblätter in einer Datei zu drucken auf Formularpapier
	$meldungen = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id);
	$data['flattern'] = 'true';
	$files = 0;
	foreach ($meldungen as $meldung) {
		$files++;
		$data['file'] = get_option('lg_kalender_settings_pfad4', true);
		if (getPruefung($title) == 'VStP') {
			$data['file'] = get_option('lg_kalender_settings_pfad6', true);
		}
		//$meldung = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where id like " . get_query_var('leistungsnachweis'));
		$data['newfile'] = 'Formblatt_' . getPruefung($title) . '_' . $meldung->e_name . '.pdf';
		$data['POrt'] = get_post_meta($post_id, 'terminort', true);
		$data['PDatum'] = date('d.m.Y', strtotime(get_post_meta($post_id, 'termindate', true)));
		$data['Name_Hund'] = $meldung->hund_name;
		$data['ZBNR'] = $meldung->hund_zbnr;
		$data['Mutter'] = $meldung->hund_mutter;
		$data['ZBNr_2'] = $meldung->hund_mutter_zbnr;
		$data['Vater'] = $meldung->hund_vater;
		$data['ZBNr_3'] = $meldung->hund_vater_zbnr;
		$data['W_Tag'] = $meldung->hund_wurftag;
		$data['Hund_RH'] = $meldung->hund_rh;
		if ($data['Hund_RH'] == 'R') {
			$data['CheckBox4'] = 'male';
			$data['Geschlecht1'] = 'On1';
		}
		if ($data['Hund_RH'] == 'H') {
			$data['CheckBox4'] = 'female';
			$data['Geschlecht1'] = 'On2';
		}
		///$data['Geschlecht1'] = 'On1';
		$data['POrt'] = get_post_meta($post_id, 'terminort', true);
		$data['PDatum'] = date('d.m.Y', strtotime(get_post_meta($post_id, 'termindate', true)));
		$data['Datum_Ort'] = get_post_meta($post_id, 'terminort', true) . ', ' . date('d.m.Y', strtotime(get_post_meta($post_id, 'termindate', true)));
		$data['Ort'] = get_post_meta($post_id, 'terminort', true);
		$data['Datum'] = date('d.m.Y', strtotime(get_post_meta($post_id, 'termindate', true)));
		$data['B_Name'] = $meldung->e_name;
		$data['B_PLZOrt'] = $meldung->e_plzort;
		$data['B_Strasse'] = $meldung->e_strasse;
		$data['HF_Name'] = $meldung->f_name;
		$data['HF_PLZOrt'] = $meldung->f_plzort;
		$data['PLZ'] = substr($meldung->f_plzort, 0, 5);
		$data['Wohnort'] = substr($meldung->f_plzort, 6);
		$data['HF_Strasse'] = $meldung->f_strasse;
		$data['Nr_1'] = substr($meldung->e_mitglied, 0, 1);
		$data['Nr_2'] = substr($meldung->e_mitglied, 1, 1);
		$data['Nr_3'] = substr($meldung->e_mitglied, 2, 1);
		$data['Nr_4'] = substr($meldung->e_mitglied, 3, 1);
		$options = array(
			'http' => array(
				'header' => "Content-type: application/x-www-form-urlencoded\r\n",
				'method' => 'POST',
				'content' => http_build_query($data)
			)
		);
		$context = stream_context_create($options);
		$result[$files] = file_get_contents($url, false, $context);
		$myfile = fopen(WP_PLUGIN_DIR . "/lg-kalender/inc/temp/" . $zahl . "newfile_$files.pdf", "w");
		fwrite($myfile, $result[$files]);
		fclose($myfile);
	}

	$pdf = new \SB\PDFMerger\PDFMerger;
	for ($i = 1; $i < ($files + 1); $i++) {
		$pdf->addPDF(WP_PLUGIN_DIR . "/lg-kalender/inc/temp/" . $zahl . "newfile_$i.pdf", '1');
	}
	$pdf->merge('download', 'Formblatt_alle.pdf', 'P');
	for ($i = 1; $i < ($files + 1); $i++) {
		unlink(WP_PLUGIN_DIR . "/lg-kalender/inc/temp/" . $zahl . "newfile_$i.pdf");
	}
	exit;
} else { // wenn Parameter leistungsnachweis id übergeben wird wird das Formblatt / Zensurentafel für id Teilnehmer gedruckt
	$data['file'] = get_option('lg_kalender_settings_pfad4', true);
	if ($CB == 'VStP') {
		$data['file'] = get_option('lg_kalender_settings_pfad6', true);
	}
	$meldung = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where id like " . get_query_var('leistungsnachweis'));
	$data['newfile'] = 'Formblatt_' . getPruefung($tile) . '_' . $meldung->e_name . '.pdf';
	$data['POrt'] = get_post_meta($post_id, 'terminort', true);
	$data['PDatum'] = date('d.m.Y', strtotime(get_post_meta($post_id, 'termindate', true)));
	$data['Name_Hund'] = $meldung->hund_name;
	$data['ZBNR'] = $meldung->hund_zbnr;
	$data['Mutter'] = $meldung->hund_mutter;
	$data['ZBNr_2'] = $meldung->hund_mutter_zbnr;
	$data['Vater'] = $meldung->hund_vater;
	$data['ZBNr_3'] = $meldung->hund_vater_zbnr;
	$data['W_Tag'] = $meldung->hund_wurftag;
	$data['Hund_RH'] = $meldung->hund_rh;
	if ($data['Hund_RH'] == 'R') {
		$data['CheckBox4'] = 'male';
		$data['Geschlecht1'] = 'On1';
	}
	if ($data['Hund_RH'] == 'H') {
		$data['CheckBox4'] = 'female';
		$data['Geschlecht1'] = 'On2';
	}
	///$data['Geschlecht1'] = 'On1';
	$data['POrt'] = get_post_meta($post_id, 'terminort', true);
	$data['PDatum'] = date('d.m.Y', strtotime(get_post_meta($post_id, 'termindate', true)));
	$data['Datum_Ort'] = get_post_meta($post_id, 'terminort', true) . ', ' . date('d.m.Y', strtotime(get_post_meta($post_id, 'termindate', true)));
	$data['Ort'] = get_post_meta($post_id, 'terminort', true);
	$data['Datum'] = date('d.m.Y', strtotime(get_post_meta($post_id, 'termindate', true)));
	$data['B_Name'] = $meldung->e_name;
	$data['B_PLZOrt'] = $meldung->e_plzort;
	$data['B_Strasse'] = $meldung->e_strasse;
	$data['HF_Name'] = $meldung->f_name;
	$data['HF_PLZOrt'] = $meldung->f_plzort;
	$data['PLZ'] = substr($meldung->f_plzort, 0, 5);
	$data['Wohnort'] = substr($meldung->f_plzort, 6);
	$data['HF_Strasse'] = $meldung->f_strasse;
	$data['Nr_1'] = substr($meldung->e_mitglied, 0, 1);
	$data['Nr_2'] = substr($meldung->e_mitglied, 1, 1);
	$data['Nr_3'] = substr($meldung->e_mitglied, 2, 1);
	$data['Nr_4'] = substr($meldung->e_mitglied, 3, 1);
}
//PDF ausfüllen zum zum Download senden
$options = array(
	'http' => array(
		'header' => "Content-type: application/x-www-form-urlencoded\r\n",
		'method' => 'POST',
		'content' => http_build_query($data)
	)
);
$context = stream_context_create($options);
$result = file_get_contents($url, false, $context);
if ($result === FALSE) { /* Handle error */
}
header("Pragma: public");
header("Expires: 0");
header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
header("Content-Type: application/pdf");
header("Content-Disposition: attachment; filename=" . $data['newfile']);
header("Content-Transfer-Encoding: binary");
ob_clean();
flush();
var_dump($result);
