<?php

/**
Plugin Name: PRTCD LG Kalender
Plugin URI: https://nienhausen.com/lg-kalender
Description: Erstellen eines Kalenders für die LG des PRTCD, mit der Möglichkeit die Prüfungstermine und Ergebnisse zu veröffentlichen
Version: 1.6.36
Author: Christoph Nienhausen
Author URI: https://nienhausen.com
License: GPLv2
 */

defined('ABSPATH') or die('No script kiddies please!');

require_once(plugin_dir_path(__FILE__) . '/inc/forall.php');
//ob_clean();
//ob_start();
function make_seed()
{
	list($usec, $sec) = explode(' ', microtime());
	return (float) $sec + ((float) $usec * 100000);
}

function randomString($len)
{
	srand(floor(make_seed()));
	//Der String $possible enthält alle Zeichen, die verwendet werden sollen
	$possible = "abcdefghikmnpqrtuvwxyz1234567890";
	$str = "";
	while (strlen($str) < $len) {
		$str .= substr($possible, (rand() % (strlen($possible))), 1);
	}
	return ($str);
}

if (!class_exists('lgkalenderUpdateChecker')) {
	class lgkalenderUpdateChecker
	{
		public $plugin_slug;
		public $version;
		public $cache_key;
		public $cache_allowed;
		public function __construct()
		{
			$this->plugin_slug = plugin_basename(__DIR__);
			$this->version = '1.6.36';
			$this->cache_key = 'lgkalender_custom_upd';
			$this->cache_allowed = false;
			add_filter('plugins_api', array($this, 'info'), 20, 3);
			add_filter('site_transient_update_plugins', array($this, 'update'));
			add_action('upgrader_process_complete', array($this, 'purge'), 10, 2);
		}
		public function request()
		{
			$remote = get_transient($this->cache_key);
			if (false === $remote || !$this->cache_allowed) {
				$remote = wp_remote_get(
					'https://nienhausen.com/wp-content/uploads/LG-Kalender/Setup/info.json',
					array(
						'timeout' => 10,
						'headers' => array(
							'Accept' => 'application/json'
						)
					)
				);
				if (is_wp_error($remote) || 200 !== wp_remote_retrieve_response_code($remote) || empty(wp_remote_retrieve_body($remote))) {
					return false;
				}
				set_transient($this->cache_key, $remote, DAY_IN_SECONDS);
			}
			$remote = json_decode(wp_remote_retrieve_body($remote));
			return $remote;
		}
		function info($res, $action, $args)
		{
			if ('plugin_information' !== $action) {
				return $res;
			}
			// do nothing if it is not our plugin
			if ($this->plugin_slug !== $args->slug) {
				return $res;
			}
			// get updates
			$remote = $this->request();
			if (!$remote) {
				return $res;
			}
			$res = new stdClass();
			$res->name = $remote->name;
			$res->slug = $remote->slug;
			$res->version = $remote->version;
			$res->tested = $remote->tested;
			$res->requires = $remote->requires;
			$res->author = $remote->author;
			$res->author_profile = $remote->author_profile;
			$res->download_link = $remote->download_url;
			$res->trunk = $remote->download_url;
			$res->requires_php = $remote->requires_php;
			$res->last_updated = $remote->last_updated;
			$res->sections = array(
				'description' => $remote->sections->description,
				'installation' => $remote->sections->installation,
				'changelog' => $remote->sections->changelog
			);
			if (!empty($remote->banners)) {
				$res->banners = array(
					'low' => $remote->banners->low,
					'high' => $remote->banners->high
				);
			}
			return $res;
		}
		public function update($transient)
		{
			if (empty($transient->checked)) {
				return $transient;
			}
			$remote = $this->request();
			if ($remote && version_compare($this->version, $remote->version, '<') && version_compare($remote->requires, get_bloginfo('version'), '<=') && version_compare($remote->requires_php, PHP_VERSION, '<')) {
				$res = new stdClass();
				$res->slug = $this->plugin_slug;
				$res->plugin = plugin_basename(__FILE__);
				$res->new_version = $remote->version;
				$res->tested = $remote->tested;
				$res->package = $remote->download_url;
				$transient->response[$res->plugin] = $res;
			}
			return $transient;
		}
		public function purge($upgrader, $options)
		{
			if ($this->cache_allowed && 'update' === $options['action'] && 'plugin' === $options['type']) {
				// just clean the cache when new plugin version is installed
				delete_transient($this->cache_key);
			}
		}
	}
	new lgkalenderUpdateChecker();
}


// Add the duplicate link to action list for post_row_actions
// for "post" and custom post types
add_filter('post_row_actions', 'rd_duplicate_post_link', 10, 2);
// for "page" post type
//add_filter( 'page_row_actions', 'rd_duplicate_post_link', 10, 2 );


function rd_duplicate_post_link($actions, $post)
{
	if (!current_user_can('edit_posts')) {
		return $actions;
	}
	$url = wp_nonce_url(
		add_query_arg(
			array(
				'action' => 'rd_duplicate_post_as_draft',
				'post' => $post->ID,
			),
			'admin.php'
		),
		basename(__FILE__),
		'duplicate_nonce'
	);
	$actions['duplicate'] = '<a href="' . $url . '" title="Dupliziere diesen Termin" rel="permalink">Duplizieren</a>';
	return $actions;
}

/*
 * Function creates post duplicate as a draft and redirects then to the edit post screen
 */
add_action('admin_action_rd_duplicate_post_as_draft', 'rd_duplicate_post_as_draft');

function rd_duplicate_post_as_draft()
{

	// check if post ID has been provided and action
	if (empty($_GET['post'])) {
		wp_die('No post to duplicate has been provided!');
	}

	// Nonce verification
	//if ( ! isset( $_GET[ 'duplicate_nonce' ] ) || ! wp_verify_nonce( $_GET[ 'duplicate_nonce' ], basename( __FILE__ ) ) ) {
	//	echo ('Nonce Fehler...');
	//	return;
	//}

	// Get the original post id
	$post_id = absint($_GET['post']);

	// And all the original post data then
	$post = get_post($post_id);

	/*
	 * if you don't want current user to be the new post author,
	 * then change next couple of lines to this: $new_post_author = $post->post_author;
	 */
	$current_user = wp_get_current_user();
	$new_post_author = $current_user->ID;

	// if post data exists (I am sure it is, but just in a case), create the post duplicate
	if ($post) {

		// new post data array
		$args = array(
			'comment_status' => $post->comment_status,
			'ping_status' => $post->ping_status,
			'post_author' => $new_post_author,
			'post_content' => $post->post_content,
			'post_excerpt' => $post->post_excerpt,
			'post_name' => $post->post_name,
			'post_parent' => $post->post_parent,
			'post_password' => $post->post_password,
			'post_status' => 'draft',
			'post_title' => $post->post_title,
			'post_type' => $post->post_type,
			'to_ping' => $post->to_ping,
			'menu_order' => $post->menu_order
		);

		// insert the post by wp_insert_post() function
		$new_post_id = wp_insert_post($args);

		/*
		 * get all current post terms ad set them to the new post draft
		 */
		$taxonomies = get_object_taxonomies(get_post_type($post)); // returns array of taxonomy names for post type, ex array("category", "post_tag");
		if ($taxonomies) {
			foreach ($taxonomies as $taxonomy) {
				$post_terms = wp_get_object_terms($post_id, $taxonomy, array('fields' => 'slugs'));
				wp_set_object_terms($new_post_id, $post_terms, $taxonomy, false);
			}
		}

		// duplicate all post meta
		$post_meta = get_post_meta($post_id);
		if ($post_meta) {
			foreach ($post_meta as $meta_key => $meta_values) {
				if ('_wp_old_slug' == $meta_key) { // do nothing for this meta key
					continue;
				}
				foreach ($meta_values as $meta_value) {
					add_post_meta($new_post_id, $meta_key, $meta_value);
				}
			}
		}
		// finally, redirect to the edit post screen for the new draft
		wp_safe_redirect(
			add_query_arg(
				array(
					'action' => 'edit',
					'post' => $new_post_id
				),
				admin_url('post.php')
			)
		);
		exit;
		// or we can redirect to all posts with a message

		//wp_safe_redirect(
		//	add_query_arg(
		//		array(
		//			'post_type' => ( 'post' !== get_post_type( $post ) ? get_post_type( $post ) : false ),
		//			'saved' => 'post_duplication_created' // just a custom slug here
		//		),
		//		admin_url( 'edit.php' )
		//	)
		//);
		//exit;

	} else {
		wp_die('Post creation failed, could not find original post.');
	}
}

/*
 * In case we decided to add admin notices
 */
add_action('admin_notices', 'rudr_duplication_admin_notice');

function rudr_duplication_admin_notice()
{

	// Get the current screen
	$screen = get_current_screen();

	if ('edit' !== $screen->base) {
		return;
	}

	//Checks if settings updated
	if (isset($_GET['saved']) && 'post_duplication_created' == $_GET['saved']) {

		echo '<div class="notice notice-success is-dismissible"><p>Post copy created.</p></div>';
	}
}

/*
add_action('personal_options_update', 'my_save_extra_profile_fields');
add_action('edit_user_profile_update', 'my_save_extra_profile_fields');

function my_save_extra_profile_fields($user_id)
{

	if (!current_user_can('edit_user', $user_id)) {
		return false;
	}
	// In der nachfolgenden Zeile wird das Feld definiert.
	update_usermeta($user_id, 'vorstandfunktion', $_POST['worstandfunktion']);
}
*/

add_action('admin_bar_menu', 'modify_admin_bar');

function modify_admin_bar($wp_admin_bar)
{
	// do something with $wp_admin_bar;
	$args = array(
		'id' => 'wpbeginner',
		'title' => 'MySite - ' . get_the_title(get_option('lg_kalender_settings_pagewebsite')),
		'href' => get_page_link(get_option('lg_kalender_settings_pagewebsite')),
		'meta' => array(
			'class' => 'wpbeginner',
			'title' => 'LG-Kalender Link zur Seite'
		)
	);
	$wp_admin_bar->add_node($args);
}

/*
add_action('show_user_profile', 'my_show_extra_profile_fields');
add_action('edit_user_profile', 'my_show_extra_profile_fields');


function my_show_extra_profile_fields($user)
{
	?>
	<h3>Vorstand Funktion</h3>
	<table class="form-table">
		<tr>
			<th><label for="vorstandfunktion">Vorstand Funktion</label></th>
		</tr>
		<tr>
			<td><select name="vorstandfunktion" id="vorstandfunktion">
					<option value="1V" <?php echo (get_the_author_meta('vorstandfunktion', $user->ID) == "1V") ? 'selected="selected"' : '' ?>>1. Vorsitz</option>
					<option value="2V" <?php echo (get_the_author_meta('vorstandfunktion', $user->ID) == "2V") ? 'selected="selected"' : '' ?>>2. Vorsitz</option>
					<option value="KW" <?php echo (get_the_author_meta('vorstandfunktion', $user->ID) == "KW") ? 'selected="selected"' : '' ?>>Kasse</option>
					<option value="SF" <?php echo (get_the_author_meta('vorstandfunktion', $user->ID) == "SF") ? 'selected="selected"' : '' ?>>Schrift</option>
					<option value="PO" <?php echo (get_the_author_meta('vorstandfunktion', $user->ID) == "PO") ? 'selected="selected"' : '' ?>>Prüfungswesen</option>
					<option value="ZW" <?php echo (get_the_author_meta('vorstandfunktion', $user->ID) == "ZW") ? 'selected="selected"' : '' ?>>Zucht</option>
				</select>
			</td>
		</tr>
	</table>
	<?php
}


add_action('personal_options_update', 'save_user_fields');
add_action('edit_user_profile_update', 'save_user_fields');

function save_user_fields($user_id)
{

	if (!current_user_can('edit_user', $user_id)) {
		return false;
	}
	//save dropdown
	update_usermeta($user_id, 'vorstandfunktion', $_POST['vorstandfunktion']);
}
*/

function zz_shortcode_resource()
{
	wp_register_script("zz-shortcode-jscss-script", plugins_url("/js/hund_script.js", __FILE__), array('jquery'), "1.0", false);
	wp_register_style("zz-shortcode-jscss-style", plugins_url("/css/hund_style.css", __FILE__), array(), "1.3", "all");
}
add_action('init', 'zz_shortcode_resource');

function zz_shortcode_resource2()
{
	wp_register_script("zz-shortcode-jscss-script2", plugins_url("/js/statistik_script.js", __FILE__), array('jquery'), "1.0", false);
	wp_register_style("zz-shortcode-jscss-style2", plugins_url("/css/statistik_style.css", __FILE__), array(), "1.1", "all");
}
add_action('init', 'zz_shortcode_resource2');

function zz_shortcode_resource3()
{
	wp_register_script("zz-shortcode-jscss-script3", plugins_url("/js/meldung_script.js", __FILE__), array('jquery'), "1.1", false);
}
add_action('init', 'zz_shortcode_resource3');

//Einbindung des Media Browsers und des JacaScripts um Bilder auszuwählen
function admin_scripts()
{
	wp_enqueue_media();
	wp_enqueue_script('backend-mediaselector', plugins_url('/js/mediaselector.js', __FILE__), array(), '20210407', true);
}
add_action('admin_enqueue_scripts', 'admin_scripts');

//Registrien der Variable zur Benutzung des Plugins
add_action('init', 'add_get_val');
function add_get_val()
{
	global $wp;
	$wp->add_query_var('foryear'); //Auswahl des Jahres im Kalender
	$wp->add_query_var('downloadmeldeschein'); //Setzen der Variabel auf true zum herunterladen des Meldescheines
	$wp->add_query_var('downloadpdf'); //Setzen der Variabel auf true zum herunterladen des Druck-PDF
	$wp->add_query_var('leistungsnachweis'); //Setzen der Variabel auf id des Teilnehmers zum herunterladen des Leistungsnachweises
	$wp->add_query_var('bericht'); //Variabel zum speichern der Post_ID des Posts Prüfungsergebnis
	$wp->add_query_var('setbericht'); //Variabel zum speichern der Post_ID des Posts Prüfungsergebnis
	$wp->add_query_var('insert'); //Variabel zum einfügen einer Meldung. new = manuel, import = via Meldeschein PDF
	$wp->add_query_var('mailcode'); //Variable zum übertragen des Codes für die Lesebestätigung einer Einladung
	$wp->add_query_var('warnung'); //Variabel zum einfügen einer Warnung.
}

// Registrieren der Felder für die Einstellungen des Pluginns
include(plugin_dir_path(__FILE__) . '/inc/adminmenue.php');


//Einbindung des Shortcodes
include(plugin_dir_path(__FILE__) . '/inc/shortcode.php');
include(plugin_dir_path(__FILE__) . '/inc/shortcode_3days.php');
include(plugin_dir_path(__FILE__) . '/inc/shortcode_hund.php');
include(plugin_dir_path(__FILE__) . '/inc/shortcode_beitrag.php');
include(plugin_dir_path(__FILE__) . '/inc/shortcode_meldungen.php');
include(plugin_dir_path(__FILE__) . '/inc/shortcode_richter.php');
include(plugin_dir_path(__FILE__) . '/inc/shortcode_statistik.php');



//Download des Meldescheines, einbinden des Scriptes
function custom_post_type_download($single)
{
	global $post;
	/* Checks for single template by post type */
	if ($post->post_type == 'lgkalender_termin') {
		if (get_query_var('downloadmeldeschein')) {
			if (file_exists(plugin_dir_path(__FILE__) . '/inc/meldeschein.php')) {
				return plugin_dir_path(__FILE__) . '/inc/meldeschein.php';
			}
		}
	}
	return $single;
}
add_filter('single_template', 'custom_post_type_download');

//Download der Formblätter / Zensurentafel, einbinden des Scriptes
function tpl_download_nachweis($single)
{
	global $post;
	/* Checks for single template by post type */
	if (is_user_logged_in()) {
		if (get_query_var('leistungsnachweis')) {
			if (file_exists(plugin_dir_path(__FILE__) . '/inc/leistungsnachweis.php')) {
				return plugin_dir_path(__FILE__) . '/inc/leistungsnachweis.php';
			}
		}
	}
	return $single;
}
add_filter('page_template', 'tpl_download_nachweis');

//Download des Druck-PDF, einbinden des Scriptes
function tpl_download_pdf($single)
{
	//global $post;
	/* Checks for single template by post type */
	if (is_user_logged_in()) {
		if (get_query_var('downloadpdf')) {
			if (file_exists(plugin_dir_path(__FILE__) . '/inc/printpdf.php')) {
				return plugin_dir_path(__FILE__) . '/inc/printpdf.php';
			}
		}
	}
	return $single;
}
add_filter('page_template', 'tpl_download_pdf');

function lgkalender_register_post_type()
{
	$labels = array(
		'name' => __('alle Termine', 'lgkalender'),
		'menu_name' => __('LG Kalender', 'lgkalender'),
		'all_items' => __('alle Termine', 'lgkalender'),
		'singular_name' => __('Termin', 'lgkalender'),
		'add_new' => __('neuer Termin', 'lgkalender'),
		'add_new_item' => __('neuen Termin hinzufügen', 'lgkalender'),
		'edit_item' => __('Termin bearbeiten', 'lgkalender'),
		'new_item' => __('neuer Termin', 'lgkalender'),
		'view_item' => __('Termin ansehen', 'lgkalender'),
		'search_items' => __('Termin suchen', 'lgkalender'),
		'not_found' => __('kein Termin gefunden', 'lgkalender'),
		'not_found_in_trash' => __('kein Termin gefunden im Mülleimer', 'lgkalender'),
	);
	$args = array(
		'labels' => $labels,
		'has_archive' => true,
		'public' => true,
		'hierarchical' => false,
		'supports' => array(
			'title',
			'page-attributes',
			'author'
		),
		'rewrite' => array('slug' => 'termine'),
		'show_in_rest' => false,
		'show_in_menu' => true,
		'menu_position' => 2
	);
	register_post_type('lgkalender_termin', $args);
}

add_action('init', 'lgkalender_register_post_type');


add_action('add_meta_boxes', 'termin_data_add_meta_boxes');
if (!function_exists('termin_data_add_meta_boxes')) {
	function termin_data_add_meta_boxes()
	{
		global $post;
		add_meta_box('termin_data', __('Daten des Termins', 'your_text_domain'), 'termin_data_data_content', 'lgkalender_termin', 'normal', 'core');
		add_meta_box('termin_footer', __('Ergebnis', 'your_text_domain'), 'termin_footer_data_content', 'lgkalender_termin', 'advanced', 'core');
	}
}


function termin_data_data_content()
{
	global $post;
	$the_id = $post;
	$termin_gruppe = get_post_meta($post->ID, 'termingruppe', true);
	$termin_ort = get_post_meta($post->ID, 'terminort', true);
	$termin_aenderung = get_post_meta($post->ID, 'terminaenderung', true);
	$termin_neu = get_post_meta($post->ID, 'terminneu', true);
	$termin_date = get_post_meta($post->ID, 'termindate', true);
	$termin_date_end = get_post_meta($post->ID, 'termindateend', true);
	$termin_date_time = get_post_meta($post->ID, 'termindatetime', true);
	$termin_date_cash = get_post_meta($post->ID, 'termindatecash', true);
	$editable_ids = get_users();
	$termin_user = get_post_meta($post->ID, 'terminuser', true);
	$termin_min = get_post_meta($post->ID, 'terminmin', true);
	$termin_max = get_post_meta($post->ID, 'terminmax', true);
	$termin_ausfall = get_post_meta($post->ID, 'terminausfall', true);
	$termin_ausgebucht = get_post_meta($post->ID, 'terminausgebucht', true);
	$termin_area = get_post_meta($post->ID, 'terminarea', true);
	$termin_dateilink = get_post_meta($post->ID, 'termindateilink', true);
	$termin_dateitext = get_post_meta($post->ID, 'termindateitext', true);
	$termin_meldeschein = get_post_meta($post->ID, 'terminmeldeschein', true);
	$termin_nennschluss = get_post_meta($post->ID, 'terminnennschluss', true);
	$termin_meldeschein_counter = get_post_meta($post->ID, 'terminmeldescheincounter', true);
	$termin_meldeschein_code = get_post_meta($post->ID, 'terminmeldescheincode', true);
	if (strlen($termin_meldeschein_code) <> 20) {
		$termin_meldeschein_code = randomString(20);
	}
	$termin_meldeschein_pin = get_post_meta($post->ID, 'terminmeldescheinpin', true);
	if (strlen($termin_meldeschein_pin) <> 6) {
		$termin_meldeschein_pin = randomString(6);
	}
?>
	<table border=1>
		<tr>
			<th>Beschreibung</th>
			<th colspan=2>Wert</th>
		</tr>
		<tr>
			<td>Gehört zu Termin</td>

<?
	$the_content = '<td colspan=2><select name="termin_gruppe" id="termin_gruppe" class="postbox">';
	$the_content .= "<option value='-1' " . selected(-1, $termin_gruppe, false) . ">---</option>";
	$year_2 = date("Y", strtotime($termin_date));
	$start_date_2 = $year_2 . '-01-01';
	$end_date_2 = $year_2 . '-12-31';
	$args_2 = array(
		'post_type' => 'lgkalender_termin',
		'post_status' => array('publish', 'draft', 'pending'),
		'posts_per_page' => -1,
		'meta_key' => 'termindate',
		'orderby' => 'meta_value',
		'order' => 'ASC',
		'meta_query' => array(
			'relation' => 'AND',
			array(
				'key' => 'termindate',
				'value' => array($start_date_2, $end_date_2),
				'compare' => 'BETWEEN',
				'type' => 'DATE'
			),
			array(
				'key' => 'terminmeldeschein',
				'value' => 'on',
				'compare' => '='
			)
		)
	);
	$post_id_this = $post->ID;
	$loop_2 = new WP_Query($args_2);
	// start des WordPress Loops für unseren post type
	while ($loop_2->have_posts()) :
		$loop_2->the_post();
		// post id abfragen
		$post_id_2 = get_the_ID();
		$title_2 = get_the_title($post_id_2);
		$termin_date_2 = date("d.m.Y", strtotime(get_post_meta($post_id_2, 'termindate', true)));
		$termin_ort_2 = get_post_meta($post_id_2, 'terminort', true);
		if ($post_id_2 == $post_id_this){
			//$the_content .= "<option value='" . $post_id_2 . "' " . selected($post_id_2, $termin_gruppe, false) . ">keine Zuordnung</option>";
		} else{
			$the_content .= "<option value='" . $post_id_2 . "' " . selected($post_id_2, $termin_gruppe, false) . ">" . $title_2 . " " . $termin_ort_2 . "(" . $termin_date_2 . ")</option>";
		}

	endwhile;
	$post = $the_id;
	$the_content .= "</select></td>";
	echo ($the_content);
?>
		</tr>
		<tr>
			<td>Ort des Termins</td>
			<td colspan=2><input type="text" name="termin_ort" id="termin_ort" size="90" value="<?php echo ($termin_ort); ?>" class="postbox"></td>
		</tr>
		<tr>
			<td>Termininfo</td>
			<td><input id="termin_neu" name="termin_neu" type="checkbox" <?php if ($termin_neu == 'on') {
																				echo ("checked");
																			} ?>><label for="termin_neu">neuer Termin</label></td>
			<td><input id="termin_aenderung" name="termin_aenderung" type="checkbox" <?php if ($termin_aenderung == 'on') {
																							echo ("checked");
																						} ?>><label for="termin_aenderung">Änderung Datum</label></td>
		</tr>
		<tr>
			<td>Startdatum des Termins</td>
			<td colspan=2><input id="termin_date" name="termin_date" type="date" value="<?php echo ($termin_date); ?>"></td>
		</tr>
		<tr>
			<td>Enddatum des Termins<br>optional</td>
			<td colspan=2><input id="termin_date_end" name="termin_date_end" type="date" value="<?php echo ($termin_date_end); ?>"></td>
		</tr>
		<tr>
			<td>Nennschluss</td>
			<td colspan=2><input id="termin_nennschluss" name="termin_nennschluss" type="date" value="<?php echo ($termin_nennschluss); ?>"></td>
		</tr>
		<tr>
			<td>Uhrzeit des Termins<br>optional</td>
			<td colspan=2><input id="termin_date_time" name="termin_date_time" type="time" value="<?php echo ($termin_date_time); ?>"></td>
		</tr>
		<tr>
			<td>Meldegebühr<br>Format xx,xx €(xx,xx €)</td>
			<td colspan=2><input id="termin_date_cash" name="termin_date_cash" type="text" size="25" value="<?php echo ($termin_date_cash); ?>"></td>
		</tr>
		<tr>
			<td>Meldestelle</td>
			<td colspan=2><?php wp_dropdown_users(array('include' => $editable_ids, 'show_option_all' => __('View all Owners'), 'name' => 'termin_user', 'selected' => isset($termin_user) ? $termin_user : 0)); ?></td>
		</tr>
		<tr>
			<td>Anzahl PRT</td>
			<td>min:<input id="termin_min" name="termin_min" type="text" size="2" value="<?php echo ($termin_min); ?>"></td>
			<td>max:<input id="termin_max" name="termin_max" type="text" size="2" value="<?php echo ($termin_max); ?>"></td>
		</tr>
		<tr>
			<td>Marker</td>
			<td><input id="termin_ausfall" name="termin_ausfall" type="checkbox" <?php if ($termin_ausfall == 'on') {
																						echo ("checked");
																					} ?>><label for="termin_ausfall">fällt aus</label></td>
			<td><input id="termin_ausgebucht" name="termin_ausgebucht" type="checkbox" <?php if ($termin_ausgebucht == 'on') {
																							echo ("checked");
																						} ?>><label for="termin_ausgebucht">ausgebucht</label></td>
		</tr>
		<tr>
			<td>Hinweistext</td>
			<td colspan=2><textarea rows="4" cols="100" name="termin_area" id="termin_area"><?php echo ($termin_area); ?></textarea></td>
		</tr>
		<tr>
			<td>Dateilink</td>
			<td colspan=2><input id="termin_dateilink" name="termin_dateilink" type="text" size="25" value="<?php echo ($termin_dateilink); ?>"></td>
		</tr>
		<tr>
			<td>Datei Link Beschriftung</td>
			<td colspan=2><input id="termin_dateitext" name="termin_dateitext" type="text" size="25" value="<?php echo ($termin_dateitext); ?>"></td>
		</tr>
		<tr>
			<td>Termin<br>ist eine Prüfung</td>
			<td><input id="termin_meldeschein" name="termin_meldeschein" type="checkbox" <?php if ($termin_meldeschein == 'on') {
																								echo ("checked");
																							} ?>><label for="termin_meldeschein">Prüfung
					aktivieren</label></td>
		</tr>
		<tr>
			<td>Zähler Meldeschein download</td>
			<td colspan=2><input id="termin_meldeschein_counter" name="termin_meldeschein_counter" type="text" size="25" value="<?php echo ($termin_meldeschein_counter); ?>"></td>
		</tr>
		<tr>
			<td>Linkzusatz Meldung online</td>
			<td colspan=2><input id="termin_meldeschein_code" name="termin_meldeschein_code" type="text" readonly size="25" value="<?php echo ($termin_meldeschein_code); ?>"></td>
		</tr>
		<tr>
			<td>Meldung online Pin</td>
			<td colspan=2><input id="termin_meldeschein_pin" name="termin_meldeschein_pin" type="text" size="25" value="<?php echo ($termin_meldeschein_pin); ?>"></td>
		</tr>
	</table>
<?php
}

function termin_footer_data_content()
{
	global $post;
	$the_id = $post->ID;
	$termin_freigabe = get_post_meta($post->ID, 'terminfreigabe', true);
	$termin_footer = get_post_meta($post->ID, 'terminfooter', true);
	$termin_bericht = get_post_meta($post->ID, 'terminbericht', true);
	$termin_bilderanzahl = get_post_meta($post->ID, 'terminbilderanzahl', true);
	if ($termin_bilderanzahl > '') {
	} else {
		$termin_bilderanzahl = '0';
	}
	if ($termin_bilderanzahl > 10) {
		$termin_bilderanzahl = '10';
	}
	for ($i = 1; $i < ($termin_bilderanzahl + 1); $i++) {
		$parameter_path = 'imagePath' . $i;
		$parameter_text = 'termintext' . $i;
		$parameter_smaller = 'imagesmall' . $i;
		$image_url[$i] = esc_attr(get_post_meta($post->ID, $parameter_path, true));
		$termin_text[$i] = get_post_meta($post->ID, $parameter_text, true);
		$termin_imagesmall[$i] = get_post_meta($post->ID, $parameter_smaller, true);
	}
?>
	<table border=1>
		<tr>
			<th>Beschreibung</th>
			<th>Wert</th>
		</tr>
		<tr>
			<td>Ergebnisse<br>freigeben</td>
			<td><input id="termin_freigabe" name="termin_freigabe" type="checkbox" <?php if ($termin_freigabe == 'on') {
																						echo ("checked");
																					} ?>><label for="termin_freigabe">Ergebnisse freigeben</label></td>
		</tr>
		<tr>
			<td>Anzahl Bilder</td>
			<td><input type="number" min="0" max="10" name="termin_bilderanzahl" id="termin_bilderanzahl" value="<?php echo ($termin_bilderanzahl); ?>" class="postbox"></td>
		</tr>
		<?php
		for ($i = 1; $i < ($termin_bilderanzahl + 1); $i++) {
			$parameter_path = 'imagePath' . $i;
			$parameter_text = 'termintext' . $i;
			$parameter_smaller = 'imagesmall' . $i;
		?>
			<tr>
				<td>Bild
					<?php echo ($i); ?>
				</td>
				<td>
					<div>
						<button class="imgSelectorBtn" data-refinput="image_Path<?php echo ($i); ?>" data-refimage="image<?php echo ($i); ?>">Bild <?php echo ($i); ?> öffnen</button>
						<input type="text" id="image_Path<?php echo ($i); ?>" name="image_Path<?php echo ($i); ?>" value="<?php echo ($image_url[$i]); ?>" class="regular-text" />
						<img id="image<?php echo ($i); ?>" name="image<?php echo ($i); ?>" src="<?php echo ($image_url[$i]); ?>" width="500px" height="*" />
					</div>
				</td>
			</tr>
			<tr>
				<td>Bild
					<?php echo ($i); ?> Text
				</td>
				<td><input type="text" name="termin_text<?php echo ($i); ?>" id="termin_text<?php echo ($i); ?>" size="90" value="<?php echo ($termin_text[$i]); ?>" class="postbox"></td>
			</tr>
			<tr>
				<td>Bild
					<?php echo ($i); ?> Eigenschaft
				</td>
				<td><input id="termin_imagesmall<?php echo ($i); ?>" name="termin_imagesmall<?php echo ($i); ?>" type="checkbox" <?php if ($termin_imagesmall[$i] == 'on') {
																																		echo ("checked");
																																	} ?>><label for="termin_imagesmall<?php echo ($i); ?>">Bild kleiner darstellen</label></td>
			</tr>
			<tr>
				<td colspan="2">
					<p align="center">--- Bild
						<?php echo ($i); ?> Absatz Ende ---
				</td>
			</tr>
		<?php
		}
		?>
		<tr>
			<td>Bericht</td>
			<td><textarea rows="25" cols="100" name="termin_bericht" id="termin_bericht"><?php echo ($termin_bericht); ?></textarea></td>
		</tr>
	</table>
	<script>
		var inputElement = '-undefined-';
		var imageElement = '-undefined-';
		jQuery('.imgSelectorBtn').on('click', function(e) {
			inputElement = jQuery(this).data("refinput");
			imageElement = jQuery(this).data("refimage");
			e.preventDefault();
			customMediaLibrary.open();
		});
		jQuery(function() {
			customMediaLibrary.on('select', function() {
				var selectionCollection = customMediaLibrary.state().get('selection').first().toJSON();
				jQuery('#' + inputElement).val(selectionCollection.url);
				jQuery('#' + imageElement).attr("src", selectionCollection.url);
			});
		});
	</script>
<?php
}

function termin_data_save_postdata($post_id)
{
	if (array_key_exists('termin_gruppe', $_POST)) {
		update_post_meta(
			$post_id,
			'termingruppe',
			$_POST['termin_gruppe']
		);
	}
	if (array_key_exists('termin_ort', $_POST)) {
		update_post_meta(
			$post_id,
			'terminort',
			$_POST['termin_ort']
		);
	}
	if (array_key_exists('termin_neu', $_POST)) {
		update_post_meta(
			$post_id,
			'terminneu',
			$_POST['termin_neu']
		);
	} else {
		update_post_meta(
			$post_id,
			'terminneu',
			'off'
		);
	}
	if (array_key_exists('termin_aenderung', $_POST)) {
		update_post_meta(
			$post_id,
			'terminaenderung',
			$_POST['termin_aenderung']
		);
	} else {
		update_post_meta(
			$post_id,
			'terminaenderung',
			'off'
		);
	}
	if (array_key_exists('termin_date', $_POST)) {
		update_post_meta(
			$post_id,
			'termindate',
			$_POST['termin_date']
		);
	}
	if (array_key_exists('termin_date_end', $_POST)) {
		update_post_meta(
			$post_id,
			'termindateend',
			$_POST['termin_date_end']
		);
	}
	if (array_key_exists('termin_nennschluss', $_POST)) {
		update_post_meta(
			$post_id,
			'terminnennschluss',
			$_POST['termin_nennschluss']
		);
	}
	if (array_key_exists('termin_date_time', $_POST)) {
		update_post_meta(
			$post_id,
			'termindatetime',
			$_POST['termin_date_time']
		);
	}
	if (array_key_exists('termin_date_cash', $_POST)) {
		update_post_meta(
			$post_id,
			'termindatecash',
			$_POST['termin_date_cash']
		);
	}
	if (array_key_exists('termin_user', $_POST)) {
		update_post_meta(
			$post_id,
			'terminuser',
			$_POST['termin_user']
		);
	}
	if (array_key_exists('termin_min', $_POST)) {
		update_post_meta(
			$post_id,
			'terminmin',
			$_POST['termin_min']
		);
	}
	if (array_key_exists('termin_max', $_POST)) {
		update_post_meta(
			$post_id,
			'terminmax',
			$_POST['termin_max']
		);
	}
	if (array_key_exists('termin_ausfall', $_POST)) {
		update_post_meta(
			$post_id,
			'terminausfall',
			$_POST['termin_ausfall']
		);
	} else {
		update_post_meta(
			$post_id,
			'terminausfall',
			'off'
		);
	}
	if (array_key_exists('termin_ausgebucht', $_POST)) {
		update_post_meta(
			$post_id,
			'terminausgebucht',
			$_POST['termin_ausgebucht']
		);
	} else {
		update_post_meta(
			$post_id,
			'terminausgebucht',
			'off'
		);
	}
	if (array_key_exists('termin_area', $_POST)) {
		update_post_meta(
			$post_id,
			'terminarea',
			$_POST['termin_area']
		);
	}
	if (array_key_exists('termin_dateilink', $_POST)) {
		update_post_meta(
			$post_id,
			'termindateilink',
			$_POST['termin_dateilink']
		);
	}
	if (array_key_exists('termin_dateitext', $_POST)) {
		update_post_meta(
			$post_id,
			'termindateitext',
			$_POST['termin_dateitext']
		);
	}
	if (array_key_exists('termin_meldeschein', $_POST)) {
		update_post_meta(
			$post_id,
			'terminmeldeschein',
			$_POST['termin_meldeschein']
		);
	} else {
		update_post_meta(
			$post_id,
			'terminmeldeschein',
			'off'
		);
	}
	if (array_key_exists('termin_meldeschein_counter', $_POST)) {
		update_post_meta(
			$post_id,
			'terminmeldescheincounter',
			$_POST['termin_meldeschein_counter']
		);
	}
	if (array_key_exists('termin_meldeschein_code', $_POST)) {
		update_post_meta(
			$post_id,
			'terminmeldescheincode',
			$_POST['termin_meldeschein_code']
		);
	} else {
		update_post_meta(
			$post_id,
			'terminmeldescheincode',
			randomString(20)
		);
	}
	if (array_key_exists('termin_meldeschein_pin', $_POST)) {
		update_post_meta(
			$post_id,
			'terminmeldescheinpin',
			$_POST['termin_meldeschein_pin']
		);
	} else {
		update_post_meta(
			$post_id,
			'terminmeldescheinpin',
			randomString(6)
		);
	}
	if (array_key_exists('termin_freigabe', $_POST)) {
		update_post_meta(
			$post_id,
			'terminfreigabe',
			$_POST['termin_freigabe']
		);
	} else {
		update_post_meta(
			$post_id,
			'terminfreigabe',
			'off'
		);
	}
	if (array_key_exists('termin_bilderanzahl', $_POST)) {
		update_post_meta(
			$post_id,
			'terminbilderanzahl',
			$_POST['termin_bilderanzahl']
		);
		//}
		for ($i = 1; $i < ($_POST['termin_bilderanzahl'] + 1); $i++) {
			$parameter_path = 'imagePath' . $i;
			$parameter_text = 'termintext' . $i;
			$parameter_smaller = 'imagesmall' . $i;
			$parameter_path_key = 'image_Path' . $i;
			$parameter_text_key = 'termin_text' . $i;
			$parameter_smaller_key = 'termin_imagesmall' . $i;
			if (array_key_exists($parameter_path_key, $_POST)) {
				update_post_meta(
					$post_id,
					$parameter_path,
					$_POST[$parameter_path_key]
				);
			}
			if (array_key_exists($parameter_text_key, $_POST)) {
				update_post_meta(
					$post_id,
					$parameter_text,
					$_POST[$parameter_text_key]
				);
			}
			if (array_key_exists($parameter_smaller_key, $_POST)) {
				update_post_meta(
					$post_id,
					$parameter_smaller,
					$_POST[$parameter_smaller_key]
				);
			} else {
				update_post_meta(
					$post_id,
					$parameter_smaller,
					'off'
				);
			}
		}
	}
	if (array_key_exists('termin_bericht', $_POST)) {
		update_post_meta(
			$post_id,
			'terminbericht',
			$_POST['termin_bericht']
		);
	}
}
add_action('save_post', 'termin_data_save_postdata');


// Tabellenkopf und -fuß um Felder erweitern
add_filter('manage_edit-lgkalender_termin_columns', 'lgkalender_edit_admin_columns');
function lgkalender_edit_admin_columns($columns)
{
	$columns = array(
		'cb' => '<input type="checkbox" />',
		'title' => __('Title'),
		'begin' => __('Termin'),
		'place' => __('Ort'),
		'stelle' => __('Meldestelle'),
		'minmax' => __('min/max'),
		'ausgebucht' => __('ausgebucht'),
		'ausfall' => __('fällt aus'),
		'date' => __('Date')
	);
	return $columns;
}

// Inhalte aus benutzerdefinierten Feldern holen und den Spalten hinzufügen
add_action('manage_lgkalender_termin_posts_custom_column', 'lgkalender_post_custom_columns');
function lgkalender_post_custom_columns($column)
{
	global $post;
	$custom = get_post_custom();
	switch ($column) {
		case "begin":
			$from = get_post_meta($post->ID, 'termindate', true);
			$date = new DateTime($from);
			echo $date->format('d.m.Y');
			break;
		case "stelle":
			$to = get_post_meta($post->ID, 'terminuser', true);
			$user_meta = get_userdata($to);
			echo $user_meta->display_name;
			break;
		case "place":
			$ort = get_post_meta($post->ID, 'terminort', true);
			echo $ort;
			break;
		case "minmax":
			$min = get_post_meta($post->ID, 'terminmin', true);
			$max = get_post_meta($post->ID, 'terminmax', true);
			echo ("$min/$max");
			break;
		case "ausgebucht":
			$ausgebucht = get_post_meta($post->ID, 'terminausgebucht', true);
			if ($ausgebucht == 'on') {
				echo "X";
			}
			break;
		case "ausfall":
			$ausfall = get_post_meta($post->ID, 'terminausfall', true);
			if ($ausfall == 'on') {
				echo "X";
			}
			break;
	}
}

//Beitrag (Termin) umleiten auf eingestellte Seite
add_action('template_redirect', 'redirect_post_type_single_lgkalender');
function redirect_post_type_single_lgkalender()
{
	global $post;
	if (is_singular('lgkalender_termin')) {
		$post_id = get_queried_object()->ID;
		//$post_id = get_the_ID();
		if (get_query_var('downloadmeldeschein')) {
			return;
		}
		wp_redirect(get_page_link(get_option('lg_kalender_settings_pagebericht')) . '?bericht=' . $post_id, '301');
		exit;
	}
}

function archive_to_custom_archive()
{
	if (is_post_type_archive('lgkalender_termin')) {
		wp_redirect(get_page_link(get_option('lg_kalender_settings_pagetermine')), 301);
		exit();
	}
}
add_action('template_redirect', 'archive_to_custom_archive');

// Hinzugefügte Spalten sortierbar machen
add_filter('manage_edit-lgkalender_termin_sortable_columns', 'lgkalender_post_sortierbare_columns');
function lgkalender_post_sortierbare_columns($columns)
{
	$columns['begin'] = 'termindate';
	//$columns['stelle'] = 'terminuser';
	//$columns['place'] = 'terminort';
	return $columns;
}

add_action('pre_get_posts', 'my_slice_orderby');
function my_slice_orderby($query)
{
	if (!is_admin()) {
		return;
	}
	$orderby = $query->get('orderby');
	$kalender = $query->get('post_type');
	if ('termindate' == $orderby) {
		$query->set('meta_key', 'termindate');
		$query->set('orderby', 'meta_value');
	} else {
		// ab hier den Kalender im Adminbereich nach Veranstalltungstermin sortieren, wenn keine andere sortieung erfolgt
		if (!$orderby) {
			if ('lgkalender_termin' == $kalender) {
				$query->set('meta_key', 'termindate');
				$query->set('orderby', 'meta_value');
			}
		}
	}
}

//Erstellen bzw. Update der Datenbanktabelle (Struktur) für die Meldungen
global $mytable_db_version;
$mytable_db_version = '1.0.19';

function mytable_install()
{
	global $wpdb;
	global $mytable_db_version;
	$installed_ver = get_option("mytable_db_version");
	if ($installed_ver != $mytable_db_version) {
		$charset_collate = $wpdb->get_charset_collate();
		require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		//Tabellenstruktur für Meldungen
		$table_name = $wpdb->prefix . 'lgmeldungen';
		$sql = "CREATE TABLE $table_name (
			id int(11) NOT NULL AUTO_INCREMENT,
			postid int(11) NULL DEFAULT NULL,
			hund_name varchar(100) DEFAULT '' NOT NULL,
			hund_rh varchar(1) DEFAULT '' NOT NULL,
			hund_zbnr varchar(30) DEFAULT '' NOT NULL,
			hund_wurftag varchar(20) DEFAULT '' NOT NULL,
			hund_chipnr varchar(30) DEFAULT '' NOT NULL,
			hund_mutter varchar(100) DEFAULT '' NOT NULL,
			hund_mutter_zbnr varchar(30) DEFAULT '' NOT NULL,
			hund_vater varchar(100) DEFAULT '' NOT NULL,
			hund_vater_zbnr varchar(30) DEFAULT '' NOT NULL,
			e_name varchar(100) DEFAULT '' NOT NULL,
			e_mitglied varchar(10) DEFAULT '' NOT NULL,
			e_plzort varchar(100) DEFAULT '' NOT NULL,
			e_strasse varchar(100) DEFAULT '' NOT NULL,
			e_email varchar(150) DEFAULT '' NOT NULL,
			e_telefon varchar(50) DEFAULT '' NOT NULL,
			f_name varchar(100) DEFAULT '' NOT NULL,
			f_telefon varchar(50) DEFAULT '' NOT NULL,
			f_plzort varchar(100) DEFAULT '' NOT NULL,
			f_strasse varchar(100) DEFAULT '' NOT NULL,
			posteingang varchar(1) DEFAULT 'N' NOT NULL,
			meldungok varchar(1) DEFAULT 'N' NOT NULL,
			zahlung varchar(1) DEFAULT 'N' NOT NULL,
			zahlung_datum varchar(20) DEFAULT '' NOT NULL,
			zahlung_betrag varchar(10) DEFAULT '' NOT NULL,
			punkte varchar(3) DEFAULT '' NOT NULL,
			preis varchar(3) DEFAULT '' NOT NULL,
			laut varchar(3) DEFAULT '' NOT NULL,
			bestanden varchar(1) DEFAULT '' NOT NULL,
			haar varchar(20) DEFAULT '' NOT NULL,
			bu varchar(5) DEFAULT '' NOT NULL,
			wh varchar(5) DEFAULT '' NOT NULL,
			fw varchar(10) DEFAULT '' NOT NULL,
			gebiss varchar(150) DEFAULT '' NOT NULL,
			sortierung int(11) DEFAULT 1,
			bp_vorhanden varchar(1) DEFAULT '0' NOT NULL,
			lt_vorhanden varchar(1) DEFAULT '0' NOT NULL,
			schussjp_vorhanden varchar(3) DEFAULT '0' NOT NULL,
			gelesen varchar(1) DEFAULT 'N' NOT NULL,
			mail_code varchar(30) DEFAULT '' NOT NULL,
			PRIMARY KEY (id)
		) $charset_collate;";
		dbDelta($sql);

		//Tabellenstruktur für Richteradressen
		$table_name = $wpdb->prefix . 'lgrichter';
		$sql = "CREATE TABLE $table_name (
			id int(11) NOT NULL AUTO_INCREMENT,
			postid int(11) NULL DEFAULT NULL,
			nachname varchar(100) DEFAULT '' NOT NULL,
			vorname varchar(100) DEFAULT '' NOT NULL,
			strasse varchar(100) DEFAULT '' NOT NULL,
			plz varchar(10) DEFAULT '' NOT NULL,
			ort varchar(100) DEFAULT '' NOT NULL,
			telefon varchar(50) DEFAULT '' NOT NULL,
			mobil varchar(50) DEFAULT '' NOT NULL,
			email varchar(150) DEFAULT '' NOT NULL,
			richternummer varchar(50) DEFAULT '' NOT NULL,
			mitgliedschaft varchar(1) DEFAULT '' NOT NULL,
			verein varchar(100) DEFAULT '' NOT NULL,
			richternummer_bau varchar(50) DEFAULT '' NOT NULL,
			verein_bau varchar(100) DEFAULT '' NOT NULL,
			richternummer_sw varchar(50) DEFAULT '' NOT NULL,
			verein_sw varchar(100) DEFAULT '' NOT NULL,
			iban varchar(50) DEFAULT '' NOT NULL,
			bank varchar(100) DEFAULT '' NOT NULL,
			PRIMARY KEY (id)
		) $charset_collate;";
		dbDelta($sql);

		//Tabellenstruktur für Richternummern / Fächer
		$table_name = $wpdb->prefix . 'lgrichternummer';
		$sql = "CREATE TABLE $table_name (
			id int(11) NOT NULL AUTO_INCREMENT,
			richterid int(11) NULL DEFAULT NULL,
			richternummer varchar(50) DEFAULT '' NOT NULL,
			verein varchar(100) DEFAULT '' NOT NULL,
			bau varchar(1) DEFAULT '' NOT NULL,
			sw varchar(1) DEFAULT '' NOT NULL,
			wt varchar(1) DEFAULT '' NOT NULL,
			norm varchar(1) DEFAULT '' NOT NULL,
			zs varchar(1) DEFAULT '' NOT NULL,
			ra varchar(1) DEFAULT '' NOT NULL,
			PRIMARY KEY (id)
		) $charset_collate;";
		dbDelta($sql);

		//Tabellenstruktur für Zuordnung Richter zu Prüfungen
		$table_name = $wpdb->prefix . 'lgmeldungenrichter';
		$sql = "CREATE TABLE $table_name (
			id int(11) NOT NULL AUTO_INCREMENT,
			postid int(11) NULL DEFAULT NULL,
			pl varchar(50) DEFAULT '' NOT NULL,
			pl_check varchar(1) DEFAULT '0' NOT NULL,
			po varchar(50) DEFAULT '' NOT NULL,
			po_check varchar(1) DEFAULT '0' NOT NULL,
			r2 varchar(50) DEFAULT '' NOT NULL,
			r2_check varchar(1) DEFAULT '0' NOT NULL,
			r3 varchar(50) DEFAULT '' NOT NULL,
			r3_check varchar(1) DEFAULT '0' NOT NULL,
			ra varchar(50) DEFAULT '' NOT NULL,
			ra_check varchar(1) DEFAULT '0' NOT NULL,
			gelesen_pl varchar(1) DEFAULT 'N' NOT NULL,
			gelesen_po varchar(1) DEFAULT 'N' NOT NULL,
			gelesen_r2 varchar(1) DEFAULT 'N' NOT NULL,
			gelesen_r3 varchar(1) DEFAULT 'N' NOT NULL,
			gelesen_ra varchar(1) DEFAULT 'N' NOT NULL,
			mail_code_pl varchar(30) DEFAULT '' NOT NULL,
			mail_code_po varchar(30) DEFAULT '' NOT NULL,
			mail_code_r2 varchar(30) DEFAULT '' NOT NULL,
			mail_code_r3 varchar(30) DEFAULT '' NOT NULL,
			mail_code_ra varchar(30) DEFAULT '' NOT NULL,
			PRIMARY KEY (id)
		) $charset_collate;";
		dbDelta($sql);

		//Tabellenstruktur für Daten zu Prüfungen
		$table_name = $wpdb->prefix . 'lgmeldungendaten';
		$sql = "CREATE TABLE $table_name (
			id int(11) NOT NULL AUTO_INCREMENT,
			postid int(11) NULL DEFAULT NULL,
			meldung_p_ort varchar(100) DEFAULT '' NOT NULL,
			meldung_p_erschienen varchar(2) DEFAULT '0' NOT NULL,
			meldung_p_durchgp varchar(2) DEFAULT '0' NOT NULL,
			meldung_p_bestanden varchar(2) DEFAULT '0' NOT NULL,
			meldung_p_revier varchar(150) DEFAULT '' NOT NULL,
			meldung_p_wasser varchar(150) DEFAULT '-' NOT NULL,
			meldung_p_wild varchar(1) DEFAULT '1' NOT NULL,
			meldung_p_witterung varchar(150) DEFAULT '' NOT NULL,
			meldung_p_vorkommnisse varchar(150) DEFAULT '' NOT NULL,
			versendet varchar(15) DEFAULT '' NOT NULL,
			meldung_s_kostenrichter varchar(10) DEFAULT '0' NOT NULL,
			meldung_s_kostensonstige varchar(10) DEFAULT '0' NOT NULL,
			meldung_s_spenderichter varchar(10) DEFAULT '0' NOT NULL,
			meldung_s_einnahmensonstige varchar(10) DEFAULT '0' NOT NULL,
			PRIMARY KEY (id)
		) $charset_collate;";
		dbDelta($sql);

		add_option('mytable_db_version', $mytable_db_version); //Aktualisierung der DB-Version in WP
	}
}
register_activation_hook(__FILE__, 'mytable_install');

function myplugin_update_db_check()
{
	global $mytable_db_version;
	if (get_site_option('mytable_db_version') != $mytable_db_version) {
		mytable_install();
	}
}
add_action('plugins_loaded', 'myplugin_update_db_check');
?>
