//------------------------------------------------------------------------------
//	$Id: treetable.js,v 1.9 2018/10/03 02:16:23 wolf Exp $
//------------------------------------------------------------------------------
//	Creates a tree structure on a table
//------------------------------------------------------------------------------
//	This program is free software. It comes without any warranty, to
//	the extent permitted by applicable law. You can redistribute it
//	and/or modify it under the terms of the Do What The Fuck You Want
//	To Public License, Version 2, as published by Sam Hocevar. See
//	http://www.wtfpl.net/ for more details.
//------------------------------------------------------------------------------

/*jsl:option explicit*/

'use strict';

window.addListener = function (element, eventName, handler) {

	if (element.addEventListener) {
		element.addEventListener(eventName, handler, false);
	} else if (window.document.attachEvent) {
		element.attachEvent('on'+eventName, handler);
	} else {
		window.alert ('Neither addEventListener nor attachEvent defined.');
	}
};

window.addListener (window, 'load', function() {

	function createTreetable (tableElement) {

		var nesting	= tableElement.getAttribute('data-treetable-nesting');
		var nestingStep	= parseFloat(nesting) || 1.2;
		var nestingUnit	= nesting && nesting.replace(/^[\d\.]*/, '') || 'em';

		var patternText	= tableElement.getAttribute('data-treetable-class-pattern');
		var pattern	= patternText && new RegExp(patternText) || (/^c(\d+)$/);

		var entries = tableElement.getElementsByTagName('tbody')[0].getElementsByTagName('tr');
		var childs  = [];

		function hide (list) {

			if (!list)  return;

			for (var i in list) {

				var r = list[i];
				var tr = entries[r];
				tr.style.display = 'none';
				if (tr.className=='open') hide (childs[r]);
			}
		}

		function unhide (list) {

			if (!list)  return;

			for (var i in list) {

				var r = list[i];
				var tr = entries[r];
				tr.style.display = '';
				if (tr.className=='open') unhide (childs[r]);
			}
		}

		function toggle (index) {

			var entry = entries[index];

			if (entry.className=='closed') {

				entry.className = 'open';
				unhide (childs[index]);
				return;
			}

			if (entry.className=='open') {

				entry.className = 'closed';
				hide (childs[index]);
				return;
			}
		}

		var currentLevels = [];
		var currentChilds = [];

		var r, tr, td;

		for (r=0; r<entries.length; r++) {

			tr = entries[r];

			var level = 99;
			var classes = tr.className.split(/\x20/);

			for (var c in classes) {

				var match = classes[c].match(pattern);
				if (match) level = parseInt(match[1], 10);
			}

			while (currentLevels.length && level <= currentLevels[currentLevels.length-1]) {

				currentLevels.pop();
				currentChilds.pop();
			}

			if (currentChilds.length) currentChilds[currentChilds.length-1].push(r);

			var myNesting = currentLevels.length;
			currentLevels.push(level);
			currentChilds.push(childs[r] = []);

			if (myNesting > 0) tr.style.display = 'none';

			td = tr.getElementsByTagName('td')[0];
			var span = document.createElement('span'); span.className = 'marker';
			td.insertBefore (span, td.firstChild);
			td.style.paddingLeft = (myNesting * nestingStep) + nestingUnit;
		}

		for (r=0; r<entries.length; r++) {

			if (!childs[r].length) continue;

			tr = entries[r];
			td = tr.getElementsByTagName('td')[0];
			tr.className = 'closed';
			td.style.cursor = 'pointer';

			(function(n) {
				td.onclick = function() { toggle(n); };
			})(r);
		}

		tableElement.style.display = 'table';
	}

	//----------------------------------------------------------------------
	//	attach functions to links
	//----------------------------------------------------------------------

	var tableElements = window.document.getElementsByClassName('treetable');
	for (var t=0; t<tableElements.length; t++) {

		createTreetable (tableElements[t]);
	}
});

//------------------------------------------------------------------------------
//	$Id: treetable.js,v 1.9 2018/10/03 02:16:23 wolf Exp $
//------------------------------------------------------------------------------