<?php
if (!defined('ABSPATH')) {
	exit;
}
function getKalenderVersion() //Gibt die Version des Plugins zurück
{
	if (!function_exists('get_plugin_data')) {
		require_once(ABSPATH . 'wp-admin/includes/plugin.php');
	}
	$data = get_plugin_data(plugin_dir_path(__DIR__) . '/lg-kalender.php');
	$version = $data['Version'];
	return $version;
}
function getLaut($wert) // Bei den Ergebnissen wird der Laut als Integer gespeicher. Funktion gibt den Text zurück
{
	$laut = array(
		"0" => "--",
		"1" => "spl",
		"2" => "sil",
		"3" => "fl",
		"4" => "lt",
		"5" => "wdl",
		"6" => "stumm",
		"7" => "frgl.",
	);
	return $laut[$wert];
}

function getWild($wert) // Bei der Angabe des Wildbesatzes wird der Wert als Integer gespeichert. Funktion gibt den Text zurück
{
	$wild = array(
		"1" => "sehr gut",
		"2" => "gut",
		"3" => "ausreichend",
		"4" => "kein",
		"5" => "nicht relevant",
	);
	return $wild[$wert];
}

function getPreis($wert) // Bei den Ergebnissen wird der Preis als Integer gespeichert. Funktion gibt den Text zurück
{
	$preis = array(
		"0" => "--",
		"1" => "I.",
		"2" => "II.",
		"3" => "III.",
		"4" => "n.b.",
		"5" => "nicht erschienen",
		"6" => "nicht durchgeprüft",
		"7" => "zurückgestellt",
		"8" => "bestanden",
	);
	return $preis[$wert];
}
function getFormwert($wert) // Bei den Ergebnissen wird der Formwert als Integer gespeichert. Funktion gibt den Text zurück
{
	$formwert = array(
		"0" => "--",
		"1" => "v",
		"2" => "sg",
		"3" => "g",
		"4" => "disq.",
		"5" => "nicht erschienen",
	);
	return $formwert[$wert];
}

function getPLTEXT($CB) // Funktion gibt je nach Prüfung die Bezeichnung der Prüfungsleitung zurück
{
	$PL_TEXT = array(
		"JP" => "Prüfungsleitung",
		"BP" => "Prüfungsleitung",
		"ZP" => "Prüfungsleitung",
		"GP" => "Prüfungsleitung",
		"WT" => "Wesenstest-Leitung",
		"ZS" => "Zuchtschauleitung",
		"SJG" => "Organisation vor Ort",
		"VStP" => "Prüfungsleitung",
		"VSwP" => "Prüfungsleitung"
	);
	return $PL_TEXT[$CB];
}

function getPOTEXT($CB) // Funktion gibt je nach Prüfung die Bezeichnung der Prüfungsobmanns zurück
{
	$PO_TEXT = array(
		"JP" => "Prüfungsobmann",
		"BP" => "Prüfungsobmann",
		"ZP" => "Prüfungsobmann",
		"GP" => "Prüfungsobmann",
		"WT" => "WSV-Obmann",
		"ZS" => "Zuchtrichter",
		"SJG" => "Richter",
		"VStP" => "Prüfungsobmann",
		"VSwP" => "Prüfungsobmann"
	);
	return $PO_TEXT[$CB];
}

function getR2TEXT($CB) // Funktion gibt je nach Prüfung die Bezeichnung des 2. Richters zurück
{
	$R2_TEXT = array(
		"JP" => "Richter",
		"BP" => "Richter",
		"ZP" => "Richter",
		"GP" => "Richter",
		"WT" => "WSV-Richter",
		"ZS" => "Ringschreiber",
		"SJG" => "Richter",
		"VStP" => "Richter",
		"VSwP" => "Richter"
	);
	return $R2_TEXT[$CB];
}

function getR3TEXT($CB) // Funktion gibt je nach Prüfung die Bezeichnung des 3. Richters zurück
{
	$R3_TEXT = array(
		"JP" => "Richter",
		"BP" => "Richter",
		"ZP" => "Richter",
		"GP" => "Richter",
		"WT" => "WSV-Richter",
		"ZS" => "-",
		"SJG" => "Richter",
		"VStP" => "Richter",
		"VSwP" => "Richter"
	);
	return $R3_TEXT[$CB];
}

function getRATEXT($CB) // Funktion gibt je nach Prüfung die Bezeichnung des Richteranwärters zurück
{
	$RA_TEXT = array(
		"JP" => "Richteranwärter",
		"BP" => "Richteranwärter",
		"ZP" => "Richteranwärter",
		"GP" => "Richteranwärter",
		"WT" => "WSV-Richteranwärter",
		"ZS" => "ZS-Richteranwärter",
		"SJG" => "-",
		"VStP" => "Richteranwärter",
		"VSwP" => "Richteranwärter"
	);
	return $RA_TEXT[$CB];
}

function getPruefung($title)  // Funktion prüft den Titel eines Termines auf Prüfungsart. Gibt dann den Prüfungkürzel zurück oder false, wenn keine Prüfung
{
	$CB = false;
	if (strstr($title, '(JP)')) {
		$CB = 'JP';
	}
	if (strstr($title, '(BP)')) {
		$CB = 'BP';
	}
	if (strstr($title, '(ZP)')) {
		$CB = 'ZP';
	}
	if (strstr($title, '(WT)')) {
		$CB = 'WT';
	}
	if (strstr($title, '(ZS)')) {
		$CB = 'ZS';
	}
	if (strstr($title, '(GP)')) {
		$CB = 'GP';
	}
	if (strstr($title, '(SJG)')) {
		$CB = 'SJG';
	}
	if (strstr($title, '(VStP)')) {
		$CB = 'VStP';
	}
	if (strstr($title, '(VSwP)')) {
		$CB = 'VSwP';
	}
	return $CB;
}

function getPruefung_Text($title) // Funktion prüft den Titel eines Termines auf Prüfungsart. Gibt dann den Prüfungs Klartext zurück oder false, wenn keine Prüfung
{
	$CB = false;
	if (strstr($title, '(JP)')) {
		$CB = 'Junghundprüfung';
	}
	if (strstr($title, '(BP)')) {
		$CB = 'Bauprüfung';
	}
	if (strstr($title, '(ZP)')) {
		$CB = 'Zuchtprüfung';
	}
	if (strstr($title, '(WT)')) {
		$CB = 'Wesenstest';
	}
	if (strstr($title, '(ZS)')) {
		$CB = 'Zuchtschau';
	}
	if (strstr($title, '(GP)')) {
		$CB = 'Gebrauchsprüfung';
	}
	if (strstr($title, '(SJG)')) {
		$CB = 'Saujager-Gatter';
	}
	if (strstr($title, '(VStP)')) {
		$CB = 'Verbands-Stöberprüfung';
	}
	if (strstr($title, '(VSwP)')) {
		$CB = 'Verbands-Schweißprüfung';
	}
	return $CB;
}

function getMeldungen_Count($post_id) // Gibt die Anzahl der Meldungen inkl. evtl. zugehöriger Gruppen zurück
{
	global $wpdb;
	$summe_meldungen = 0;
	$meldungen = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id);
	$summe_meldungen = $summe_meldungen + count($meldungen);
	$args = array(
		'post_type' => 'lgkalender_termin',
		'post_status' => array('publish', 'draft', 'pending'),
		'posts_per_page' => -1,
		'meta_key' => 'termindate',
		'orderby' => 'meta_value',
		'order' => 'ASC',
		'meta_query' => array(
			array(
				'key' => 'termingruppe',
				'value' => array($post_id),
				'compare' => '='
			)
		)
	);
	$loop = new WP_Query($args);
	// start des WordPress Loops für unseren post type
	while ($loop->have_posts()) :
		$loop->the_post();
		// post id abfragen
		$post_id_loop = get_the_ID();
		$meldungen = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id_loop);
		$summe_meldungen = $summe_meldungen + count($meldungen);
	endwhile;
	return $summe_meldungen;
}

function getMeldegeld($post_id) // Gibt die Summe der Meldegelder eines Termines zurück inkl. evtl. zugehöriger Gruppen
{
	global $wpdb;
	$meldegeld = 0;
	$meldungen = $wpdb->get_row("SELECT sum(zahlung_betrag) as meldegeld FROM " . $wpdb->prefix . "lgmeldungen where zahlung ='J' and postid like " . $post_id);
	$meldegeld = $meldegeld + $meldungen->meldegeld;
	$args = array(
		'post_type' => 'lgkalender_termin',
		'post_status' => array('publish', 'draft', 'pending'),
		'posts_per_page' => -1,
		'meta_key' => 'termindate',
		'orderby' => 'meta_value',
		'order' => 'ASC',
		'meta_query' => array(
			array(
				'key' => 'termingruppe',
				'value' => array($post_id),
				'compare' => '='
			)
		)
	);
	$loop = new WP_Query($args);
	// start des WordPress Loops für unseren post type
	while ($loop->have_posts()) :
		$loop->the_post();
		// post id abfragen
		$post_id_loop = get_the_ID();
		$meldungen = $wpdb->get_row("SELECT sum(zahlung_betrag) as meldegeld FROM " . $wpdb->prefix . "lgmeldungen where zahlung = 'J' and postid like " . $post_id_loop);
		$meldegeld = $meldegeld + $meldungen->meldegeld;
	endwhile;
	return $meldegeld;
}

function getMeldungen_ID($post_id) // Gibt alle Post_ID's des Termines und der zugehörigen Gruppen zurück
{
	global $wpdb;
	$meldung_ID = $post_id;
	$args = array(
		'post_type' => 'lgkalender_termin',
		'post_status' => array('publish', 'draft', 'pending'),
		'posts_per_page' => -1,
		'meta_key' => 'termindate',
		'orderby' => 'meta_value',
		'order' => 'ASC',
		'meta_query' => array(
			array(
				'key' => 'termingruppe',
				'value' => array($post_id),
				'compare' => '='
			)
		)
	);
	$loop = new WP_Query($args);
	// start des WordPress Loops für unseren post type
	while ($loop->have_posts()) :
		$loop->the_post();
		// post id abfragen
		$post_id_loop = get_the_ID();
		$meldung_ID = $meldung_ID . ',' . $post_id_loop;
	endwhile;
	return $meldung_ID;
}

function getPLName($post_id, $nummer, $verein, $CB) // Gibt den Namen des Prüfungsleiters zurück
{
	global $wpdb;
	$filter = 'norm';
	if ($CB == 'WT') {
		$filter = 'wt';
	}
	if ($CB == 'ZS') {
		$filter = 'zs';
	}
	if ($CB == 'BP') {
		$filter = 'bau';
	}
	$richterliste = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgmeldungenrichter WHERE postid IN (" . $post_id . ")");
	$richter = $wpdb->get_row("SELECT * from " . $wpdb->prefix . "lgrichter where id like " . $richterliste->pl);
	if (isset($richter->vorname)) {
		$vorname = $richter->vorname;
	} else {
		$vorname = '';
	}
	if (isset($richter->nachname)) {
		$nachname = $richter->nachname;
	} else {
		$nachname = '';
	}
	$zeile = stripslashes($vorname) . ' ' . stripslashes($nachname);
	if ($nummer) {
		$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . ($richter->id ?? '0') . ") and (" . $filter . " > 0)");
		$zeile .= ' (' . ($richternummer->richternummer ?? '');
		if ($verein) {
			$zeile .= ', ' . stripslashes($richternummer->verein ?? '');
		}
		$zeile .= ')';
	}
	return $zeile;
}

function getPOName($post_id, $nummer, $verein, $CB)  // Gibt den/die Namen des Prüfungsobmannes / männer zurück, inkl/exkl. Nummer / Verein (true / false)
/*
$nummer: false / true - Ausgabe der Richternummer
$verein: false / true - Ausgabe des Vereines
$CB: Angabe der Prüfung wegen BP bzw.SW Richter
*/
{
	global $wpdb;
	$filter = 'norm';
	if ($CB == 'WT') {
		$filter = 'wt';
	}
	if ($CB == 'ZS') {
		$filter = 'zs';
	}
	if ($CB == 'BP') {
		$filter = 'bau';
	}
	$zeile = '';
	$i = 0;
	$richterliste_all = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungenrichter WHERE postid IN (" . getMeldungen_ID($post_id) . ")");
	foreach ($richterliste_all as $richterliste) {
		$richter = $wpdb->get_row("SELECT * from " . $wpdb->prefix . "lgrichter where id like " . $richterliste->po);
		if (isset($richter->vorname)) {
			$vorname = $richter->vorname;
		} else {
			$vorname = '';
		}
		if (isset($richter->nachname)) {
			$nachname = $richter->nachname;
		} else {
			$nachname = '';
		}
		if ($i > 0) {
			$zeile .= ' / ';
		}
		$zeile .= stripslashes($vorname) . ' ' . stripslashes($nachname);
		if ($nummer) {
			$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . ($richter->id ?? '0') . ") and (" . $filter . " > 0)");
			$zeile .= ' (' . ($richternummer->richternummer ?? '');
			if ($verein) {
				$zeile .= ', ' . stripslashes($richternummer->verein ?? '');
			}
			$zeile .= ')';
		}
		$i++;
	}
	return $zeile;
}

function getR2Name($post_id, $nummer, $verein, $CB) // Gibt den/die Namen des/der Richter 2 zurück, inkl/exkl. Nummer / Verein (true / false)
/*
$nummer: false / true - Ausgabe der Richternummer
$verein: false / true - Ausgabe des Vereines
$CB: Angabe der Prüfung wegen BP bzw.SW Richter
*/
{
	global $wpdb;
	$filter = 'norm';
	if ($CB == 'WT') {
		$filter = 'wt';
	}
	if ($CB == 'ZS') {
		$filter = 'zs';
	}
	if ($CB == 'BP') {
		$filter = 'bau';
	}
	$zeile = '';
	$i = 0;
	$richterliste_all = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungenrichter WHERE postid IN (" . getMeldungen_ID($post_id) . ")");
	foreach ($richterliste_all as $richterliste) {
		$richter = $wpdb->get_row("SELECT * from " . $wpdb->prefix . "lgrichter where id like " . $richterliste->r2);
		if (isset($richter->vorname)) {
			$vorname = $richter->vorname;
		} else {
			$vorname = '';
		}
		if (isset($richter->nachname)) {
			$nachname = $richter->nachname;
		} else {
			$nachname = '';
		}
		if ($i > 0) {
			$zeile .= ' / ';
		}
		$zeile .= stripslashes($vorname) . ' ' . stripslashes($nachname);
		if ($nummer) {
			$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . ($richter->id ?? '0') . ") and (" . $filter . " > 0)");
			$zeile .= ' (' . ($richternummer->richternummer ?? '');
			if ($verein) {
				$zeile .= ', ' . stripslashes($richternummer->verein ?? '');
			}
			$zeile .= ')';
		}
		$i++;
	}
	return $zeile;
}

function getR3Name($post_id, $nummer, $verein, $CB) // Gibt den/die Namen des/der Richter 3 zurück, inkl/exkl. Nummer / Verein (true / false)
/*
$nummer: false / true - Ausgabe der Richternummer
$verein: false / true - Ausgabe des Vereines
$CB: Angabe der Prüfung wegen BP bzw.SW Richter
*/
{
	global $wpdb;
	$filter = 'norm';
	if ($CB == 'WT') {
		$filter = 'wt';
	}
	if ($CB == 'ZS') {
		$filter = 'zs';
	}
	if ($CB == 'BP') {
		$filter = 'bau';
	}
	$zeile = '';
	$i = 0;
	$richterliste_all = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungenrichter WHERE postid IN (" . getMeldungen_ID($post_id) . ")");
	foreach ($richterliste_all as $richterliste) {
		$richter = $wpdb->get_row("SELECT * from " . $wpdb->prefix . "lgrichter where id like " . $richterliste->r3);
		if (isset($richter->vorname)) {
			$vorname = $richter->vorname;
		} else {
			$vorname = '';
		}
		if (isset($richter->nachname)) {
			$nachname = $richter->nachname;
		} else {
			$nachname = '';
		}
		if ($i > 0) {
			$zeile .= ' / ';
		}
		if ($nachname > '') {
			$zeile .= stripslashes($vorname) . ' ' . stripslashes($nachname);
			$i++;
		}
		if ($nummer) {
			$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . ($richter->id ?? '0') . ") and (" . $filter . " > 0)");
			$zeile .= ' (' . ($richternummer->richternummer ?? '');
			if ($verein) {
				$zeile .= ', ' . stripslashes($richternummer->verein ?? '');
			}
			$zeile .= ')';
		}
	}
	return $zeile;
}

function getRAName($post_id, $nummer, $verein, $CB) // Gibt den Namen des Richteranwärters zurück, inkl/exkl. Nummer / Verein (true / false)
/*
$nummer: false / true - Ausgabe der Richternummer
$verein: false / true - Ausgabe des Vereines
$CB: Angabe der Prüfung wegen BP bzw.SW Richter
*/
{
	global $wpdb;
	$filter = 'norm';
	if ($CB == 'WT') {
		$filter = 'wt';
	}
	if ($CB == 'ZS') {
		$filter = 'zs';
	}
	if ($CB == 'BP') {
		$filter = 'bau';
	}
	$zeile = '';
	$i = 0;
	$richterliste_all = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungenrichter WHERE postid IN (" . getMeldungen_ID($post_id) . ")");
	foreach ($richterliste_all as $richterliste) {
		$richter = $wpdb->get_row("SELECT * from " . $wpdb->prefix . "lgrichter where id like " . $richterliste->ra);
		if (isset($richter->vorname)) {
			$vorname = $richter->vorname;
		} else {
			$vorname = '';
		}
		if (isset($richter->nachname)) {
			$nachname = $richter->nachname;
		} else {
			$nachname = '';
		}
		if ($i > 0) {
			$zeile .= ' / ';
		}
		if ($nachname > '') {
			$zeile .= stripslashes($vorname) . ' ' . stripslashes($nachname);
			$i++;
		}
		if (($nummer) && ($nachname > '')) {
			$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . ($richter->id ?? '0') . ") and (" . $filter . " > 0)");
			$zeile .= ' (' . ($richternummer->richternummer ?? '');
			if ($verein) {
				$zeile .= ', ' . stripslashes($richternummer->verein ?? '');
			}
			$zeile .= ')';
		}
	}
	return $zeile;
}
