<?php
if (!defined('ABSPATH')) {
	exit;
}

add_shortcode('LG_Kalender', 'lg_kalender');

function lg_kalender()
{
	wp_enqueue_style("zz-shortcode-jscss-style");
	$css = '
		#lg_kalender_hinweis {color:' . get_option('lg_kalender_settings_farbe_hinweis', '#ff0000') . ';}
		#lg_kalender_hinweis {font-size:' . get_option('lg_kalender_settings_size_hinweis', 'unset') . ';}
		
	';
	wp_add_inline_style('zz-shortcode-jscss-style', $css);
	$year = get_query_var('foryear', date('Y'));
	$year_today = date('Y');
	$month_now = date('n');
	$day_today = date('d.m.Y');
	$start_date = $year . '-01-01';
	$end_date = $year . '-12-31';
	$iyear = date('Y');
	$maxyear = get_option('lg_kalender_settings_counter_jahre', '');
	$nextyear = get_option('lg_kalender_settings_next_year', false);
	$lg_content = '
	<div class = "wrap">
		<a href="#bankverbindung" >unsere Bankverbindung</a>';
	if (is_user_logged_in()) {
		$lg_content .= ' <a href="' . get_page_link(get_option('lg_kalender_settings_pagerichter', '')) . '" >Richterverwaltung</a>';
		$lg_content .= ' <a href="' . get_page_link(get_option('lg_kalender_settings_pagestatistic', '')) . '" >Statistik</a>';
		$lg_content .= ' <a href="?downloadpdf=kalender&bericht='.$year.'" target="_blank">Kalender</a>';
		$lg_content .= ' <br><div class="lgtooltip">Pluginversion: ' . getKalenderVersion();
		$plainText = file_get_contents(plugin_dir_path(__DIR__) . '/history.txt');
		$lg_content .= '<span class="lgtooltiptext">' . nl2br(htmlspecialchars($plainText)) . '</span> </div>';
	}
	$lg_content .= '
		<br><br>
		<form method="POST" id="form1">
		<label for="yeartime"><h4>Jahr auswählen:</h4></label>
		<select name="foryear" id="yeartime" onchange="form.submit()">';

	if ($nextyear != '1') {
		$nextyear = '0';
	}
	if (is_user_logged_in()) {
		$nextyear = '1';
	}
	if ((($month_now < '9') && ($nextyear == '1')) && (!is_user_logged_in())) {
		$nextyear = '0';
		update_option('lg_kalender_settings_next_year', false);
	}

	for ($i = $iyear + $nextyear; $i > ($iyear - $maxyear); $i--) {
		$lg_content .= '<option value="' . ($i) . '" ';
		if (($i) == $year) {
			$lg_content .= 'selected ';
		}
		$lg_content .= '>' . ($i) . '</option>';
	}
	$lg_content .= '
		</select>
		</form>
		<br>
		';
	$lg_content .= '</h3>
		<table>
			<tr>
				<th id="lg_kalender_table_left">Datum</th>
				<th id="lg_kalender_table_center">Termin</th>
				<th id="lg_kalender_table_right">Hinweis</th>
			</tr>
			';
	$args = array(
		'post_type' => 'lgkalender_termin',
		'post_status' => array('publish', 'draft', 'pending'),
		'posts_per_page' => -1,
		'meta_key' => 'termindate',
		'orderby' => 'meta_value',
		'order' => 'ASC',
		'meta_query' => array(
			array(
				'key' => 'termindate',
				'value' => array($start_date, $end_date),
				'compare' => 'BETWEEN',
				'type' => 'DATE'
			)
		)
	);
	$loop = new WP_Query($args);
	// start des WordPress Loops für unseren post type
	while ($loop->have_posts()) :
		$loop->the_post();
		// post id abfragen
		$post_id = get_the_ID();
		// abfrage unseres custom fields "position"
		$bpshow = get_option('lg_kalender_settings_bpshow', false);
		$title = get_the_title($post_id);
		$CB = getPruefung($title);
		$pagebericht = get_option('lg_kalender_settings_pagebericht', '');
		$post_url = get_page_link($pagebericht) . '?bericht=' . $post_id;
		$pagemeldungen = get_option('lg_kalender_settings_pagemeldungen', '');
		$post_url_meldungen = get_page_link($pagemeldungen) . '?bericht=' . $post_id;
		$datum1 = new DateTime($day_today);
		$datum2 = new DateTime(date("Y-m-d", strtotime(get_post_meta($post_id, 'termindate', true))));
		$datum3 = new DateTime(date("Y-m-d", strtotime(get_post_meta($post_id, 'terminnennschluss', true))));

		$termin_ort = get_post_meta($post_id, 'terminort', true);
		$termin_gruppe = get_post_meta($post_id, 'termingruppe', true);
		if ($termin_gruppe == '') {
			$termin_gruppe = '-1';
		}
		$termin_neu = get_post_meta($post_id, 'terminneu', true);
		$termin_date_BP = date("m.Y", strtotime(get_post_meta($post_id, 'termindate', true)));
		$termin_aenderung = get_post_meta($post_id, 'terminaenderung', true);
		$termin_date = date("d.m.Y", strtotime(get_post_meta($post_id, 'termindate', true)));
		$termin_date_end = date("d.m.Y", strtotime(get_post_meta($post_id, 'termindateend', true)));
		$termin_nennschluss = date("d.m.Y", strtotime(get_post_meta($post_id, 'terminnennschluss', true)));
		$termin_date_time = get_post_meta($post_id, 'termindatetime', true);
		$termin_date_cash = get_post_meta($post_id, 'termindatecash', true);
		$termin_user = get_post_meta($post_id, 'terminuser', true);
		$userdata = get_user_meta($termin_user);
		$termin_min = get_post_meta($post_id, 'terminmin', true);
		$termin_max = get_post_meta($post_id, 'terminmax', true);
		$termin_ausfall = get_post_meta($post_id, 'terminausfall', true);
		$termin_ausgebucht = get_post_meta($post_id, 'terminausgebucht', true);
		$termin_area = nl2br(get_post_meta($post_id, 'terminarea', true));
		$termin_freigabe = get_post_meta($post_id, 'terminfreigabe', true);
		$termin_bilderanzahl = esc_attr(get_post_meta($post_id, 'terminbilderanzahl', true));
		$termin_dateilink = get_post_meta($post_id, 'termindateilink', true);
		$termin_dateitext = get_post_meta($post_id, 'termindateitext', true);
		$termin_meldeschein = get_post_meta($post_id, 'terminmeldeschein', true);
		$termin_meldeschein_flag = $termin_meldeschein;
		$termin_popuptext = get_option('lg_kalender_settings_popuptext', '');
		$showpopup = get_option('lg_kalender_settings_popup', false);
		$showmeldeschein = get_option('lg_kalender_settings_meldescheinshow', false);
		$text_footer = get_option('lg_kalender_settings_footer', '');
		if ((($termin_nennschluss > '') and ($termin_nennschluss <> '01.01.1970'))) {
		} else {
			$datum3 = $datum2;
		}
		if ($termin_neu == 'on') {
			$termin_neu = 'Neu';
		} else {
			$termin_neu = '';
		}
		if ($termin_aenderung == 'on') {
			$termin_aenderung = 'Änderung';
		} else {
			$termin_aenderung = '';
		}
		if (($termin_date_end > '') and ($termin_date_end <> '01.01.1970')) {
			$termin_date = $termin_date . ' - ' . $termin_date_end;
		}
		if ($termin_date_time > '') {
			$termin_date = $termin_date . '<br>' . $termin_date_time . ' Uhr';
		}
		if (($CB == 'SJG') || ($CB == false)) {
			if ($termin_date_cash > '') {
				$termin_date_cash = 'Kostenbeitrag: <b>' . $termin_date_cash . '</b>';
				$termin_nennschluss_text = 'Anmeldung bis ' . $termin_nennschluss;
			}
		} else {
			if ($termin_date_cash > '') {
				$termin_date_cash = 'Nenngeld: <b>' . $termin_date_cash . '</b>';
				$termin_nennschluss_text = 'Nennschluss: ' . $termin_nennschluss;
			}
		}
		if ((($termin_nennschluss > '') and ($termin_nennschluss <> '01.01.1970'))) {
		} else {
			$termin_nennschluss_text = '';
		}
		if (($userdata['first_name'][0] ?? '') > '') {
			$termin_user = '<b>Nennung an:</b> ' . $userdata['first_name'][0] . ' ' . $userdata['last_name'][0] . ', ' . $userdata['description'][0];
		} else {
			$termin_user = '';
		}
		if ($termin_min > '') {
			$termin_min = '(min. ' . $termin_min;
		} else {
			$termin_min = '';
		}
		if ($termin_max > '') {
			$termin_min = $termin_min . ', max. ' . $termin_max;
		}
		if ($termin_min > '') {
			$termin_min = $termin_min . ' PRT)';
		}
		if ($termin_ausfall == 'on') {
			$termin_ausfall = '>>fällt leider aus<<';
		} else {
			$termin_ausfall = '';
		}
		if ($termin_ausgebucht == 'on') {
			$termin_ausgebucht = '>>bereits ausgebucht<<';
		} else {
			$termin_ausgebucht = '';
		}
		if (($termin_freigabe == 'on') && ($termin_gruppe == '-1')) {
			$post_url = '<p><a href="' . $post_url . '">Bericht</a></p>';
		} elseif ((is_user_logged_in()) && ($termin_gruppe == '-1')) {
			$post_url = '<p><a href="' . $post_url . '">Bericht Vorschau</a></p>';
		} else {
			$post_url = '';
		}
		if ($termin_dateitext > '') {
		} else {
			$termin_dateitext = 'Link';
		}
		if ($termin_dateilink > '') {
			$termin_dateilink = '<p><a href="' . $termin_dateilink . '" target="_blank">' . $termin_dateitext . '</a></p>';
		} else {
			$termin_dateilink = '';
		}
		if ($termin_meldeschein_flag == 'on') {
			if ($showpopup != '1') {
				$termin_meldeschein = '<p><a href="' . get_post_permalink($post_id) . '?downloadmeldeschein=true" class="button" rel="nofollow">Meldeschein</a></p>';
			} else {
				$termin_meldeschein = '<p><a href="' . get_post_permalink($post_id) . '?downloadmeldeschein=true" class="button" rel="nofollow" onclick="return confirm(\'' . $termin_popuptext . '\');">Meldeschein</a></p>';
			}
			if ($termin_ausfall == '>>fällt leider aus<<') {
				$termin_meldeschein = '';
			}
		} else {
			$termin_meldeschein = '';
		}
		if ($year < $year_today) {
			$termin_ausgebucht = '<br>';
			$termin_user = '';
			$termin_neu = '';
			$termin_aenderung = '';
		}
		if (($datum1 > $datum3) && ($showmeldeschein) && (!(is_user_logged_in()))) {
			$termin_meldeschein = '';
		}
		if ($datum1 > $datum2) {
			$termin_meldeschein = '';
			$termin_neu = '';
			$termin_aenderung = '';
			$termin_ausgebucht = '';
			if ($termin_ausfall == '>>fällt leider aus<<') {
				$termin_ausfall = '>>ist leider ausgefallen<<';
			}
			$termin_nennschluss_text = '';
		}
		//prüfen, ob Prüfung BP ist. Dann Ort löschen und Termin nur Monat ausgeben
		if (($CB == 'BP') && (!$bpshow)) {
			$termin_ort = '';
			$termin_date = $termin_date_BP;
			$termin_nennschluss_text = '';
		}
		if ((is_user_logged_in()) && ($CB != false) && ($termin_meldeschein_flag == 'on')) {
			$post_url_meldungen = '<p><a href="' . $post_url_meldungen . '">Meldungen</a></p>';
		} else {
			$post_url_meldungen = '';
		}
		$user = wp_get_current_user();
		$allowed_roles = array('administrator');
		if (array_intersect($allowed_roles, $user->roles)) {
			$url_duplicate = wp_nonce_url(
				add_query_arg(
					array(
						'action' => 'rd_duplicate_post_as_draft',
						'post' => $post_id,
					),
					'admin.php'
				),
				basename(__FILE__),
				'duplicate_nonce'
			);
			if (array_intersect($allowed_roles, $user->roles)) {
				$edit_link = '<br><a href="' . get_edit_post_link() . '"  target="_blank"> bearbeiten</a><br><a href="../wp-admin/' . $url_duplicate . '"  target="_blank">duplizieren</a>';
			} else {
				$edit_link = '';
			}
			$termin_meldeschein_counter = get_post_meta($post_id, 'terminmeldescheincounter', true);
			$termin_meldeschein_counter = '<br>(' . $termin_meldeschein_counter . ')';
			if ('' == $termin_meldeschein) {
				$termin_meldeschein_counter = '';
			}
		} else {
			$edit_link = '';
			$termin_meldeschein_counter = '';
		}
		//Prüfen auf Entwurf / Freigabe
		if ((('draft' == get_post_status($post_id)) || ('pending' == get_post_status($post_id)) || (($termin_gruppe <> $post_id) && ($termin_gruppe <> '-1')))) {
			if (is_user_logged_in()) {
				$termin_entwurf = '';
				if ('draft' == get_post_status($post_id)) {
					$termin_entwurf = '** Entwurf **';
				} elseif ('pending' == get_post_status($post_id)) {
					$termin_entwurf = '** Warte auf Freigabe **';
				}
				$lg_content .= '
	<tr>
		<td valign=top><b>' . $termin_entwurf . '<br>' . $termin_date . '</b><p id="lg_kalender_hinweis">' . $termin_neu . '<br>' . $termin_aenderung . '</p>' . $edit_link . '</td>
		<td valign=top><b><big>' . $title . '</big></b><br><small><b>' . $termin_ort . '</b> ' . $termin_min . '<br>' . $termin_area . '<br>' . $termin_date_cash . '<br>' . $termin_nennschluss_text . '<br>' . $termin_user . '</small>
		';
				if ($termin_gruppe <> '-1') {
					$lg_content .= '<br><br><b><i><u>Termin gehört zu: ' . get_the_title($termin_gruppe) . ' ' . get_post_meta($termin_gruppe, 'terminort', true) . '(' . date("d.m.Y", strtotime(get_post_meta($termin_gruppe, 'termindate', true))) . ')</u></i></b><br>';
				}
				$lg_content .= '
		</td>
		<td valign=top><p id="lg_kalender_hinweis">' . $termin_ausgebucht . '<br>' . $termin_ausfall . '</p>' . $post_url . '' . $termin_dateilink . '' . $post_url_meldungen . ' ' . $termin_meldeschein_counter . '</td>
	</tr>';
			}
		} else {
			// Template Ausgabe
			$lg_content .= '
	<tr>
		<td valign=top><b>' . $termin_date . '</b><p id="lg_kalender_hinweis">' . $termin_neu . '<br>' . $termin_aenderung . '</p>' . $edit_link . '</td>
		<td valign=top><b><big>' . $title . '</big></b><br><small><b>' . $termin_ort . '</b> ' . $termin_min . '<br>' . $termin_area . '<br>' . $termin_date_cash . '<br>' . $termin_nennschluss_text . '<br>' . $termin_user . '</small></td>
		<td valign=top><p id="lg_kalender_hinweis">' . $termin_ausgebucht . '<br>' . $termin_ausfall . '</p>' . $post_url . '' . $termin_dateilink . '' . $termin_meldeschein . '' . $post_url_meldungen . ' ' . $termin_meldeschein_counter . '</td>
	</tr>';
		}
	endwhile;
	$lg_content .= '</table>';
	$lg_content .= '<p id="bankverbindung"><small>' . nl2br($text_footer);
	$lg_content .= '</div>';
	return $lg_content;
}
