<?php
/*
	Einstellungen für das Admin-Menü
*/

add_action('admin_menu', 'lg_kalender_control_menu');
add_action('admin_init', 'lg_kalender_register_settings');
function lg_kalender_main_info_page_render()
{
	include(plugin_dir_path(__FILE__) . '/info.php');
}

function lg_kalender_control_menu()
{
	add_menu_page(
		'Einstellungen',
		'LG Kal. Admin',
		'manage_options',
		'lg-kalender-main',
		'lg_kalender_main_page_render',
		'dashicons-universal-access-alt',
		'2'
	);
	add_submenu_page(
		'lg-kalender-main',
		'Einstellungen',
		'Einstellungen',
		'manage_options',
		'lg-kalender-main',
		'lg_kalender_main_page_render'
	);
	add_submenu_page(
		'lg-kalender-main',
		'Info',
		'Info',
		'manage_options',
		'lg-kalender-main-info',
		'lg_kalender_main_info_page_render'
	);
	/*
	add_submenu_page(
		'lg-kalender-main',
		'Termine',
		'alle Termine',
		'manage_options',
		'edit.php?post_type=lgkalender_termin'
	);
	*/
}
function lg_kalender_main_page_render()
{
	global $hv_main_hook;
	global $hv_page_hook;
	wp_enqueue_style("zz-shortcode-jscss-style");
	wp_enqueue_script('jquery');
	wp_enqueue_script("zz-shortcode-jscss-script", array('jquery'), '1.0', true);
	wp_enqueue_style('wp-color-picker');
	wp_enqueue_script('wp-color-picker');
?>
	<script type="text/javascript">
		jQuery(document).ready(function() {
			jQuery('.colorPicker').wpColorPicker();
		});
	</script>
	<div class="wrap">
		<h1>Einstellung Plugin LG Kalender</h1>
		<div class="tab">
			<button class="tablinks" onclick="openCity(event, 'Tab1')" id="defaultOpen">Einstellung</button>
			<button class="tablinks" onclick="openCity(event, 'Tab2')">Formulare</button>
			<button class="tablinks" onclick="openCity(event, 'Tab3')">Design</button>
			<button class="tablinks" onclick="openCity(event, 'Tab4')">Rechte</button>
		</div>
		<div id="Tab1" class="tabcontent">
			<form action="options.php" method="post">
				<?php
				settings_fields('lg_kalender_settings_group_tab1');
				do_settings_sections($hv_page_hook . '_tab1');
				submit_button();
				?>
			</form>
		</div>
		<div id="Tab2" class="tabcontent">
			<form action="options.php" method="post">
				<?php
				settings_fields('lg_kalender_settings_group_tab2');
				do_settings_sections($hv_page_hook . '_tab2');
				submit_button();
				?>
			</form>
		</div>
		<div id="Tab3" class="tabcontent">
			<form action="options.php" method="post">
				<?php
				settings_fields('lg_kalender_settings_group_tab3');
				do_settings_sections($hv_page_hook . '_tab3');
				submit_button();
				?>
			</form>
		</div>
		<div id="Tab4" class="tabcontent">
			<form action="options.php" method="post">
				<?php
				settings_fields('lg_kalender_settings_group_tab4');
				do_settings_sections($hv_page_hook . '_tab4');
				submit_button();
				?>
			</form>
		</div>
	</div>
<?php
}

function lg_kalender_register_settings()
{
	global $hv_page_hook;
	global $mm_page_hook;
	global $wp_roles;
	add_settings_section(
		'lg_kalender_settings_section_tab1',
		'Kalender Einstellung',
		'lg_kalender_settings_section',
		$hv_page_hook . '_tab1'
	);
	add_settings_section(
		'lg_kalender_settings_section_tab2',
		'Pfade Meldescheine',
		'lg_kalender_settings_section',
		$hv_page_hook . '_tab2'
	);
	add_settings_section(
		'lg_kalender_settings_section_tab3',
		'Einstellung Anzeige Kalender',
		'lg_kalender_settings_section',
		$hv_page_hook . '_tab3'
	);
	add_settings_section(
		'lg_kalender_settings_section_tab4',
		'Einstellung Rechte Kalender',
		'lg_kalender_settings_section',
		$hv_page_hook . '_tab4'
	);

	//ab hier Felder Tab1
	add_settings_field(
		'lg_kalender_settings_name',
		'Landesgruppe',
		'lg_kalender_call_landesgruppe',
		$mm_page_hook . '_tab1',
		'lg_kalender_settings_section_tab1',
		array(
			'page_hook' => $mm_page_hook . '_tab1',
			'label_for' => 'lg_kalender_settings_name'
		)
	);
	register_setting('lg_kalender_settings_group_tab1', 'lg_kalender_settings_name', 'sanitize_text_field');

	add_settings_field(
		'lg_kalender_settings_email',
		'Mail für Meldungen',
		'lg_kalender_call_email',
		$mm_page_hook . '_tab1',
		'lg_kalender_settings_section_tab1',
		array(
			'page_hook' => $mm_page_hook . '_tab1',
			'label_for' => 'lg_kalender_settings_email'
		)
	);
	register_setting('lg_kalender_settings_group_tab1', 'lg_kalender_settings_email', 'sanitize_text_field');

	add_settings_field(
		'lg_kalender_settings_counter_jahre',
		'Anzahl Jahre',
		'lg_kalender_call_counter_jahre',
		$mm_page_hook . '_tab1',
		'lg_kalender_settings_section_tab1',
		array(
			'page_hook' => $mm_page_hook . '_tab1',
			'label_for' => 'lg_kalender_settings_counter_jahre'
		)
	);
	register_setting('lg_kalender_settings_group_tab1', 'lg_kalender_settings_counter_jahre', 'sanitize_text_field');

	add_settings_field(
		'lg_kalender_settings_counter_termine',
		'Anzahl Termine Info-Box',
		'lg_kalender_call_counter_termine',
		$mm_page_hook . '_tab1',
		'lg_kalender_settings_section_tab1',
		array(
			'page_hook' => $mm_page_hook . '_tab1',
			'label_for' => 'lg_kalender_settings_counter_termine'
		)
	);
	register_setting('lg_kalender_settings_group_tab1', 'lg_kalender_settings_counter_termine', 'sanitize_text_field');

	add_settings_field(
		'lg_kalender_settings_next_year',
		'Folgejahr freigeben',
		'lg_kalender_call_next_year',
		$mm_page_hook . '_tab1',
		'lg_kalender_settings_section_tab1',
		array(
			'page_hook' => $mm_page_hook . '_tab1',
			'label_for' => 'lg_kalender_settings_next_year'
		)
	);
	register_setting('lg_kalender_settings_group_tab1', 'lg_kalender_settings_next_year');

	add_settings_field(
		'lg_kalender_settings_popup',
		'PoUp Download Meldeschein',
		'lg_kalender_call_popup',
		$mm_page_hook . '_tab1',
		'lg_kalender_settings_section_tab1',
		array(
			'page_hook' => $mm_page_hook . '_tab1',
			'label_for' => 'lg_kalender_settings_popupr'
		)
	);
	register_setting('lg_kalender_settings_group_tab1', 'lg_kalender_settings_popup');

	add_settings_field(
		'lg_kalender_settings_popuptext',
		'Text PopUp',
		'lg_kalender_call_popuptext',
		$mm_page_hook . '_tab1',
		'lg_kalender_settings_section_tab1',
		array(
			'page_hook' => $mm_page_hook . '_tab1',
			'label_for' => 'lg_kalender_settings_popuptext'
		)
	);
	register_setting('lg_kalender_settings_group_tab1', 'lg_kalender_settings_popuptext', 'sanitize_text_field');

	add_settings_field(
		'lg_kalender_settings_footer',
		'Fußzeile zum Kalender',
		'lg_kalender_call_footer',
		$mm_page_hook . '_tab1',
		'lg_kalender_settings_section_tab1',
		array(
			'page_hook' => $mm_page_hook . '_tab1',
			'label_for' => 'lg_kalender_settings_footer'
		)
	);
	register_setting('lg_kalender_settings_group_tab1', 'lg_kalender_settings_footer');

	add_settings_field(
		'lg_kalender_settings_emailbody',
		'Standardtext für E-Mail Einladung',
		'lg_kalender_call_emailbody',
		$mm_page_hook . '_tab1',
		'lg_kalender_settings_section_tab1',
		array(
			'page_hook' => $mm_page_hook . '_tab1',
			'label_for' => 'lg_kalender_settings_emailbody'
		)
	);
	register_setting('lg_kalender_settings_group_tab1', 'lg_kalender_settings_emailbody');
	//ab hier Felder im Tab2

	add_settings_field(
		'lg_kalender_settings_pfad1',
		'PDF Formular Meldeschein Prüfungen',
		'lg_kalender_call_pfad_meldeschein',
		$mm_page_hook . '_tab2',
		'lg_kalender_settings_section_tab2',
		array(
			'page_hook' => $mm_page_hook . '_tab2',
			'label_for' => 'lg_kalender_settings_pfad1'
		)
	);
	register_setting('lg_kalender_settings_group_tab2', 'lg_kalender_settings_pfad1');

	add_settings_field(
		'lg_kalender_settings_pfad1_flattern',
		'PDF Meldeschein festschreiben',
		'lg_kalender_call_pfad_meldeschein_flattern',
		$mm_page_hook . '_tab2',
		'lg_kalender_settings_section_tab2',
		array(
			'page_hook' => $mm_page_hook . '_tab2',
			'label_for' => 'lg_kalender_settings_pfad1_flattern'
		)
	);
	register_setting('lg_kalender_settings_group_tab2', 'lg_kalender_settings_pfad1_flattern');

	add_settings_field(
		'lg_kalender_settings_pfad2',
		'PDF Formular Meldeschein SJG',
		'lg_kalender_call_pfad_sjg',
		$mm_page_hook . '_tab2',
		'lg_kalender_settings_section_tab2',
		array(
			'page_hook' => $mm_page_hook . '_tab2',
			'label_for' => 'lg_kalender_settings_pfad2'
		)
	);
	register_setting('lg_kalender_settings_group_tab2', 'lg_kalender_settings_pfad2');

	add_settings_field(
		'lg_kalender_settings_pfad2_flattern',
		'PDF SJG festschreiben',
		'lg_kalender_call_pfad_sjg_flattern',
		$mm_page_hook . '_tab2',
		'lg_kalender_settings_section_tab2',
		array(
			'page_hook' => $mm_page_hook . '_tab2',
			'label_for' => 'lg_kalender_settings_pfad2_flattern'
		)
	);
	register_setting('lg_kalender_settings_group_tab2', 'lg_kalender_settings_pfad2_flattern');

	add_settings_field(
		'lg_kalender_settings_pfad3',
		'PDF Formular Meldeschein JGHV',
		'lg_kalender_call_pfad_jghv',
		$mm_page_hook . '_tab2',
		'lg_kalender_settings_section_tab2',
		array(
			'page_hook' => $mm_page_hook . '_tab2',
			'label_for' => 'lg_kalender_settings_pfad3'
		)
	);
	register_setting('lg_kalender_settings_group_tab2', 'lg_kalender_settings_pfad3');

	add_settings_field(
		'lg_kalender_settings_pfad3_flattern',
		'PDF JGHV festschreiben',
		'lg_kalender_call_pfad_jghv_flattern',
		$mm_page_hook . '_tab2',
		'lg_kalender_settings_section_tab2',
		array(
			'page_hook' => $mm_page_hook . '_tab2',
			'label_for' => 'lg_kalender_settings_pfad3_flattern'
		)
	);
	register_setting('lg_kalender_settings_group_tab2', 'lg_kalender_settings_pfad3_flattern');

	add_settings_field(
		'lg_kalender_settings_pfad4',
		'PDF Formular Leistungsnachweis SJG',
		'lg_kalender_call_pfad_leistungsnachweis',
		$mm_page_hook . '_tab2',
		'lg_kalender_settings_section_tab2',
		array(
			'page_hook' => $mm_page_hook . '_tab2',
			'label_for' => 'lg_kalender_settings_pfad4'
		)
	);
	register_setting('lg_kalender_settings_group_tab2', 'lg_kalender_settings_pfad5');

	add_settings_field(
		'lg_kalender_settings_pfad5',
		'PDF Formular Reisekostenformular',
		'lg_kalender_call_pfad_reisekosten',
		$mm_page_hook . '_tab2',
		'lg_kalender_settings_section_tab2',
		array(
			'page_hook' => $mm_page_hook . '_tab2',
			'label_for' => 'lg_kalender_settings_pfad5'
		)
	);
	register_setting('lg_kalender_settings_group_tab2', 'lg_kalender_settings_pfad4');

	add_settings_field(
		'lg_kalender_settings_pfad6',
		'PDF Formblatt VStP',
		'lg_kalender_call_pfad_vstp',
		$mm_page_hook . '_tab2',
		'lg_kalender_settings_section_tab2',
		array(
			'page_hook' => $mm_page_hook . '_tab2',
			'label_for' => 'lg_kalender_settings_pfad6'
		)
	);
	register_setting('lg_kalender_settings_group_tab2', 'lg_kalender_settings_pfad6');

	add_settings_field(
		'lg_kalender_settings_pfad7',
		'PDF Formblatt 2 JGHV',
		'lg_kalender_call_pfad_vstp_form2',
		$mm_page_hook . '_tab2',
		'lg_kalender_settings_section_tab2',
		array(
			'page_hook' => $mm_page_hook . '_tab2',
			'label_for' => 'lg_kalender_settings_pfad7'
		)
	);
	register_setting('lg_kalender_settings_group_tab2', 'lg_kalender_settings_pfad7');

	add_settings_field(
		'lg_kalender_settings_pfad8',
		'PDF Formblatt 91 JGHV',
		'lg_kalender_call_pfad_vstp_form91',
		$mm_page_hook . '_tab2',
		'lg_kalender_settings_section_tab2',
		array(
			'page_hook' => $mm_page_hook . '_tab2',
			'label_for' => 'lg_kalender_settings_pfad8'
		)
	);
	register_setting('lg_kalender_settings_group_tab2', 'lg_kalender_settings_pfad8');

	//ab hier Felder Tab3

	add_settings_field(
		'lg_kalender_settings_bpshow',
		'Datum und Ort BP anzeigen',
		'lg_kalender_call_bpshow',
		$mm_page_hook . '_tab3',
		'lg_kalender_settings_section_tab3',
		array(
			'page_hook' => $mm_page_hook . '_tab3',
			'label_for' => 'lg_kalender_settings_bpshow'
		)
	);
	register_setting('lg_kalender_settings_group_tab3', 'lg_kalender_settings_bpshow');

	add_settings_field(
		'lg_kalender_settings_meldescheinshow',
		'Meldeschein bis Nennschluss anzeigen',
		'lg_kalender_call_meldescheinshow',
		$mm_page_hook . '_tab3',
		'lg_kalender_settings_section_tab3',
		array(
			'page_hook' => $mm_page_hook . '_tab3',
			'label_for' => 'lg_kalender_settings_meldescheinshow'
		)
	);
	register_setting('lg_kalender_settings_group_tab3', 'lg_kalender_settings_meldescheinshow');

	add_settings_field(
		'lg_kalender_settings_farbe_hinweis',
		'Farbe für Hinweise',
		'lg_kalender_call_farbe_hinweis',
		$mm_page_hook . '_tab3',
		'lg_kalender_settings_section_tab3',
		array(
			'page_hook' => $mm_page_hook . '_tab3',
			'label_for' => 'lg_kalender_settings_farbe_hinweis'
		)
	);
	register_setting('lg_kalender_settings_group_tab3', 'lg_kalender_settings_farbe_hinweis', 'sanitize_text_field');

	add_settings_field(
		'lg_kalender_settings_size_hinweis',
		'Schriftgröße für Hinweise',
		'lg_kalender_call_size_hinweis',
		$mm_page_hook . '_tab3',
		'lg_kalender_settings_section_tab3',
		array(
			'page_hook' => $mm_page_hook . '_tab3',
			'label_for' => 'lg_kalender_settings_size_hinweis'
		)
	);
	register_setting('lg_kalender_settings_group_tab3', 'lg_kalender_settings_size_hinweis', 'sanitize_text_field');

	add_settings_field(
		'lg_kalender_settings_size_hinweis_short',
		'Schriftgröße für Hinweise (Info-Box)',
		'lg_kalender_call_size_hinweis_short',
		$mm_page_hook . '_tab3',
		'lg_kalender_settings_section_tab3',
		array(
			'page_hook' => $mm_page_hook . '_tab3',
			'label_for' => 'lg_kalender_settings_size_hinweis_short'
		)
	);
	register_setting('lg_kalender_settings_group_tab3', 'lg_kalender_settings_size_hinweis_short', 'sanitize_text_field');

	add_settings_field(
		'lg_kalender_settings_size_meldung',
		'Schriftgröße für Meldungen',
		'lg_kalender_call_size_meldung',
		$mm_page_hook . '_tab3',
		'lg_kalender_settings_section_tab3',
		array(
			'page_hook' => $mm_page_hook . '_tab3',
			'label_for' => 'lg_kalender_settings_size_meldung'
		)
	);
	register_setting('lg_kalender_settings_group_tab3', 'lg_kalender_settings_size_meldung', 'sanitize_text_field');

	add_settings_field(
		'lg_kalender_settings_pagebericht',
		'Seite für Bericht',
		'lg_kalender_call_pagebericht',
		$mm_page_hook . '_tab3',
		'lg_kalender_settings_section_tab3',
		array(
			'page_hook' => $mm_page_hook . '_tab3',
			'label_for' => 'lg_kalender_settings_pagebericht'
		)
	);
	register_setting('lg_kalender_settings_group_tab3', 'lg_kalender_settings_pagebericht');

	add_settings_field(
		'lg_kalender_settings_pagetermine',
		'Seite für Termine',
		'lg_kalender_call_pagetermine',
		$mm_page_hook . '_tab3',
		'lg_kalender_settings_section_tab3',
		array(
			'page_hook' => $mm_page_hook . '_tab3',
			'label_for' => 'lg_kalender_settings_pagetermine'
		)
	);
	register_setting('lg_kalender_settings_group_tab3', 'lg_kalender_settings_pagetermine');

	add_settings_field(
		'lg_kalender_settings_pagewebsite',
		'Seite für MyLink',
		'lg_kalender_call_pagewebsite',
		$mm_page_hook . '_tab3',
		'lg_kalender_settings_section_tab3',
		array(
			'page_hook' => $mm_page_hook . '_tab3',
			'label_for' => 'lg_kalender_settings_pagewebsite'
		)
	);
	register_setting('lg_kalender_settings_group_tab3', 'lg_kalender_settings_pagewebsite');

	add_settings_field(
		'lg_kalender_settings_pagemeldungen',
		'Seite für Meldungen',
		'lg_kalender_call_pagemeldungen',
		$mm_page_hook . '_tab3',
		'lg_kalender_settings_section_tab3',
		array(
			'page_hook' => $mm_page_hook . '_tab3',
			'label_for' => 'lg_kalender_settings_pagemeldungen'
		)
	);
	register_setting('lg_kalender_settings_group_tab3', 'lg_kalender_settings_pagemeldungen');

	add_settings_field(
		'lg_kalender_settings_pagerichter',
		'Seite zur Richterverwaltung',
		'lg_kalender_call_pagerichter',
		$mm_page_hook . '_tab3',
		'lg_kalender_settings_section_tab3',
		array(
			'page_hook' => $mm_page_hook . '_tab3',
			'label_for' => 'lg_kalender_settings_pagerichter'
		)
	);
	register_setting('lg_kalender_settings_group_tab3', 'lg_kalender_settings_pagerichter');

	add_settings_field(
		'lg_kalender_settings_pagestatistic',
		'Seite zur Statistik',
		'lg_kalender_call_pagestatistic',
		$mm_page_hook . '_tab3',
		'lg_kalender_settings_section_tab3',
		array(
			'page_hook' => $mm_page_hook . '_tab3',
			'label_for' => 'lg_kalender_settings_pagestatistic'
		)
	);
	register_setting('lg_kalender_settings_group_tab3', 'lg_kalender_settings_pagestatistic');

	//ab hier Felder Tab4

	add_settings_field(
		'lg_kalender_settings_allowRead',
		'Meldung Dokumente download',
		'lg_kalender_call_allowRead',
		$mm_page_hook . '_tab4',
		'lg_kalender_settings_section_tab4',
		array(
			'page_hook' => $mm_page_hook . '_tab4',
			'label_for' => 'lg_kalender_settings_allowRead'
		)
	);
	register_setting('lg_kalender_settings_group_tab4', 'lg_kalender_settings_allowRead');

	add_settings_field(
		'lg_kalender_settings_MeldungEdit',
		'Meldung bearbeiten',
		'lg_kalender_call_allowMeldungEdit',
		$mm_page_hook . '_tab4',
		'lg_kalender_settings_section_tab4',
		array(
			'page_hook' => $mm_page_hook . '_tab4',
			'label_for' => 'lg_kalender_settings_allowMeldungEdit'
		)
	);
	register_setting('lg_kalender_settings_group_tab4', 'lg_kalender_settings_allowMeldungEdit');

	add_settings_field(
		'lg_kalender_settings_MeldungKostenEdit',
		'Meldung Kosten bearbeiten',
		'lg_kalender_call_allowMeldungKostenEdit',
		$mm_page_hook . '_tab4',
		'lg_kalender_settings_section_tab4',
		array(
			'page_hook' => $mm_page_hook . '_tab4',
			'label_for' => 'lg_kalender_settings_allowMeldungKostenEdit'
		)
	);
	register_setting('lg_kalender_settings_group_tab4', 'lg_kalender_settings_allowMeldungKostenEdit');

	add_settings_field(
		'lg_kalender_settings_allowRichterEdit',
		'Richter bearbeiten',
		'lg_kalender_call_allowRichterEdit',
		$mm_page_hook . '_tab4',
		'lg_kalender_settings_section_tab4',
		array(
			'page_hook' => $mm_page_hook . '_tab4',
			'label_for' => 'lg_kalender_settings_allowRichterEdit'
		)
	);
	register_setting('lg_kalender_settings_group_tab4', 'lg_kalender_settings_allowRichterEdit');

	add_settings_field(
		'lg_kalender_settings_allowRichterNummerEdit',
		'Richternummer bearbeiten',
		'lg_kalender_call_allowRichterNummerEdit',
		$mm_page_hook . '_tab4',
		'lg_kalender_settings_section_tab4',
		array(
			'page_hook' => $mm_page_hook . '_tab4',
			'label_for' => 'lg_kalender_settings_allowRichterNummerEdit'
		)
	);
	register_setting('lg_kalender_settings_group_tab4', 'lg_kalender_settings_allowRichterNummerEdit');

	add_settings_field(
		'lg_kalender_settings_allowRichterNew',
		'Richter anlegen/löschen',
		'lg_kalender_call_allowRichterNew',
		$mm_page_hook . '_tab4',
		'lg_kalender_settings_section_tab4',
		array(
			'page_hook' => $mm_page_hook . '_tab4',
			'label_for' => 'lg_kalender_settings_allowRichterNew'
		)
	);
	register_setting('lg_kalender_settings_group_tab4', 'lg_kalender_settings_allowRichterNew');
}

function lg_kalender_settings_section()
{
}

function lg_kalender_call_landesgruppe($args)
{
	$value = get_option('lg_kalender_settings_name', '');
	echo '<input id="' . $args['label_for'] . '" class="regular-text" type="text" value="' . esc_attr($value) . '" name="lg_kalender_settings_name" />';
}
function lg_kalender_call_email($args)
{
	$value = get_option('lg_kalender_settings_email', '');
	echo '<input id="' . $args['label_for'] . '" class="regular-text" type="text" value="' . esc_attr($value) . '" name="lg_kalender_settings_email" />';
}
function lg_kalender_call_counter_jahre($args)
{
	$value = get_option('lg_kalender_settings_counter_jahre', '5');
	echo '<input min="1" max="20" id="' . $args['label_for'] . '" class="regular-text" type="number" value="' . esc_attr($value) . '" name="lg_kalender_settings_counter_jahre" />';
}
function lg_kalender_call_counter_termine($args)
{
	$value = get_option('lg_kalender_settings_counter_termine', '4');
	echo '<input min="1" max="6" id="' . $args['label_for'] . '" class="regular-text" type="number" value="' . esc_attr($value) . '" name="lg_kalender_settings_counter_termine" />';
}
function lg_kalender_call_next_year($args)
{
	echo '<input id="' . $args['label_for'] . '" type="checkbox" value="1"' . checked(1, get_option('lg_kalender_settings_next_year'), false) . ' name="lg_kalender_settings_next_year" /><p>schaltet das Folgejahr im Kalender frei (ab September möglich).<br>Wird ab Januar dann automatisch wieder deaktiviert !';
}
function lg_kalender_call_popup($args)
{
	echo '<input id="' . $args['label_for'] . '" type="checkbox" value="1"' . checked(1, get_option('lg_kalender_settings_popup'), false) . ' name="lg_kalender_settings_popup" />';
}
function lg_kalender_call_popuptext($args)
{
	$value = get_option('lg_kalender_settings_popuptext', '');
	echo '<input id="' . $args['label_for'] . '" class="regular-text" type="text" value="' . esc_attr($value) . '" name="lg_kalender_settings_popuptext" />';
}
function lg_kalender_call_footer($args)
{
	$value = get_option('lg_kalender_settings_footer', '');
	echo '<textarea rows="20" cols="150" wrap = "soft" id="' . $args['label_for'] . '" name="lg_kalender_settings_footer"/>' . esc_attr($value) . ' </textarea>';
}

function lg_kalender_call_emailbody($args)
{
	$value = get_option('lg_kalender_settings_emailbody', 'Liebe Hundeführer/innen und Richter,

	Als Anlage senden ich Euch die Einladung zur angegeben Prüfung zu.
	Bitte prüft noch einmal die Angaben zu Euren Hunden, da sich evtl. Fehler
	ansonsten auf allen Dokumenten wiederholen.
	Ich bitte Euch, eine kurze Bestätigung für den Erhalt dieser Mail zu geben.
	Dazu bitte diesen Link aufrufen:
	{maillink}
	
	Alternativ könnt ihr auch auf diese Mail antworten.
	
	
	Ich wünsche Euch viel Suchenglück und Waidmannsheil an diesem Tag.
	
	Mit freundlichen Grüßen');
	echo '<textarea rows="20" cols="150" wrap = "soft" id="' . $args['label_for'] . '" name="lg_kalender_settings_emailbody"/>' . esc_attr($value) . ' </textarea>';
}
function lg_kalender_call_pfad_meldeschein($args)
{
	$value = get_option('lg_kalender_settings_pfad1', 'PRTCD/Form_1.pdf');
	echo '<input id="' . $args['label_for'] . '" class="regular-text" type="text" value="' . esc_attr($value) . '" name="lg_kalender_settings_pfad1" /><p>Standard: PRTCD/Form_1.pdf';
}
function lg_kalender_call_pfad_meldeschein_flattern($args)
{
	echo '<input id="' . $args['label_for'] . '" type="checkbox" value="1"' . checked(1, get_option('lg_kalender_settings_pfad1_flattern'), false) . ' name="lg_kalender_settings_pfad1_flattern" />';
}
function lg_kalender_call_pfad_sjg($args)
{
	$value = get_option('lg_kalender_settings_pfad2', 'PRTCD/Form_2.pdf');
	echo '<input id="' . $args['label_for'] . '" class="regular-text" type="text" value="' . esc_attr($value) . '" name="lg_kalender_settings_pfad2" /><p>Standard: PRTCD/Form_2.pdf';
}
function lg_kalender_call_pfad_sjg_flattern($args)
{
	echo '<input id="' . $args['label_for'] . '" type="checkbox" value="1"' . checked(1, get_option('lg_kalender_settings_pfad2_flattern'), false) . ' name="lg_kalender_settings_pfad2_flattern" />';
}
function lg_kalender_call_pfad_jghv($args)
{
	$value = get_option('lg_kalender_settings_pfad3', 'PRTCD/Form_3.pdf');
	echo '<input id="' . $args['label_for'] . '" class="regular-text" type="text" value="' . esc_attr($value) . '" name="lg_kalender_settings_pfad3" /><p>Standard: PRTCD/Form_3.pdf';
}
function lg_kalender_call_pfad_jghv_flattern($args)
{
	echo '<input id="' . $args['label_for'] . '" type="checkbox" value="1"' . checked(1, get_option('lg_kalender_settings_pfad3_flattern'), false) . ' name="lg_kalender_settings_pfad3_flattern" />';
}
function lg_kalender_call_pfad_leistungsnachweis($args)
{
	$value = get_option('lg_kalender_settings_pfad4', 'PRTCD/LZ_SJG.pdf');
	echo '<input id="' . $args['label_for'] . '" class="regular-text" type="text" value="' . esc_attr($value) . '" name="lg_kalender_settings_pfad4" /><p>Standard: PRTCD/LZ_SJG.pdf';
}

function lg_kalender_call_pfad_vstp($args)
{
	$value = get_option('lg_kalender_settings_pfad6', 'PRTCD/Form_9.pdf');
	echo '<input id="' . $args['label_for'] . '" class="regular-text" type="text" value="' . esc_attr($value) . '" name="lg_kalender_settings_pfad6" /><p>Standard: PRTCD/Form_9.pdf';
}

function lg_kalender_call_pfad_vstp_form2($args)
{
	$value = get_option('lg_kalender_settings_pfad7', 'PRTCD/Form_2_JGHV.pdf');
	echo '<input id="' . $args['label_for'] . '" class="regular-text" type="text" value="' . esc_attr($value) . '" name="lg_kalender_settings_pfad7" /><p>Standard: PRTCD/Form_2_JGHV.pdf';
}

function lg_kalender_call_pfad_vstp_form91($args)
{
	$value = get_option('lg_kalender_settings_pfad8', 'PRTCD/Form_91_JGHV.pdf');
	echo '<input id="' . $args['label_for'] . '" class="regular-text" type="text" value="' . esc_attr($value) . '" name="lg_kalender_settings_pfad8" /><p>Standard: PRTCD/Form_91_JGHV.pdf';
}
function lg_kalender_call_pfad_reisekosten($args)
{
	$value = get_option('lg_kalender_settings_pfad5', 'PRTCD/Form_RK.pdf');
	echo '<input id="' . $args['label_for'] . '" class="regular-text" type="text" value="' . esc_attr($value) . '" name="lg_kalender_settings_pfad5" /><p>Standard: PRTCD/Form_RK.pdf';
}
function lg_kalender_call_bpshow($args)
{
	echo '<input id="' . $args['label_for'] . '" type="checkbox" value="1"' . checked(1, get_option('lg_kalender_settings_bpshow'), false) . ' name="lg_kalender_settings_bpshow" />';
}
function lg_kalender_call_meldescheinshow($args)
{
	echo '<input id="' . $args['label_for'] . '" type="checkbox" value="1"' . checked(1, get_option('lg_kalender_settings_meldescheinshow'), false) . ' name="lg_kalender_settings_meldescheinshow" />';
}
function lg_kalender_call_farbe_hinweis($args)
{
	$value = get_option('lg_kalender_settings_farbe_hinweis', '#ff0000');
	echo '<input id="' . $args['label_for'] . '" class="colorPicker" type="text" value="' . esc_attr($value) . '" name="lg_kalender_settings_farbe_hinweis" />';
}
function lg_kalender_call_size_hinweis($args)
{
	$value = get_option('lg_kalender_settings_size_hinweis', 'unset');

	echo '
	<select name="lg_kalender_settings_size_hinweis" id="' . $args['label_for'] . '">
		<option value="unset" ' . selected('unset', get_option('lg_kalender_settings_size_hinweis', 'unset'), false) . '>unset</option>
		<option value="small" ' . selected('small', get_option('lg_kalender_settings_size_hinweis', 'unset'), false) . '>small</option>
		<option value="x-small" ' . selected('x-small', get_option('lg_kalender_settings_size_hinweis', 'unset'), false) . '>x-small</option>
		<option value="xx-small" ' . selected('xx-small', get_option('lg_kalender_settings_size_hinweis', 'unset'), false) . '>xx-small</option>
	</select>';
}
function lg_kalender_call_size_hinweis_short($args)
{
	$value = get_option('lg_kalender_settings_size_hinweis_short', 'unset');

	echo '
	<select name="lg_kalender_settings_size_hinweis_short" id="' . $args['label_for'] . '">
		<option value="unset" ' . selected('unset', get_option('lg_kalender_settings_size_hinweis_short', 'unset'), false) . '>unset</option>
		<option value="small" ' . selected('small', get_option('lg_kalender_settings_size_hinweis_short', 'unset'), false) . '>small</option>
		<option value="x-small" ' . selected('x-small', get_option('lg_kalender_settings_size_hinweis_short', 'unset'), false) . '>x-small</option>
		<option value="xx-small" ' . selected('xx-small', get_option('lg_kalender_settings_size_hinweis_short', 'unset'), false) . '>xx-small</option>
	</select>';
}
function lg_kalender_call_size_meldung($args)
{
	$value = get_option('lg_kalender_settings_size_meldung', 'unset');

	echo '
	<select name="lg_kalender_settings_size_meldung" id="' . $args['label_for'] . '">
		<option value="unset" ' . selected('unset', get_option('lg_kalender_settings_size_meldung', 'unset'), false) . '>unset</option>
		<option value="small" ' . selected('small', get_option('lg_kalender_settings_size_meldung', 'unset'), false) . '>small</option>
		<option value="x-small" ' . selected('x-small', get_option('lg_kalender_settings_size_meldung', 'unset'), false) . '>x-small</option>
		<option value="xx-small" ' . selected('xx-small', get_option('lg_kalender_settings_size_meldung', 'unset'), false) . '>xx-small</option>
	</select>';
}
function lg_kalender_call_pagebericht($args)
{
	$value = get_option('lg_kalender_settings_pagebericht', '');
	wp_dropdown_pages([
		'name' => 'lg_kalender_settings_pagebericht',
		'id' => $args['label_for'],
		'selected' => $value,
	]);
}
function lg_kalender_call_pagetermine($args)
{
	$value = get_option('lg_kalender_settings_pagetermine', '');
	wp_dropdown_pages([
		'name' => 'lg_kalender_settings_pagetermine',
		'id' => $args['label_for'],
		'selected' => $value,
	]);
}
function lg_kalender_call_pagewebsite($args)
{
	$value = get_option('lg_kalender_settings_pagewebsite', '');
	wp_dropdown_pages([
		'name' => 'lg_kalender_settings_pagewebsite',
		'id' => $args['label_for'],
		'selected' => $value,
	]);
}
function lg_kalender_call_pagemeldungen($args)
{
	$value = get_option('lg_kalender_settings_pagemeldungen', '');
	wp_dropdown_pages([
		'name' => 'lg_kalender_settings_pagemeldungen',
		'id' => $args['label_for'],
		'selected' => $value,
	]);
}
function lg_kalender_call_pagerichter($args)
{
	$value = get_option('lg_kalender_settings_pagerichter', '');
	wp_dropdown_pages([
		'name' => 'lg_kalender_settings_pagerichter',
		'id' => $args['label_for'],
		'selected' => $value,
	]);
}

function lg_kalender_call_pagestatistic($args)
{
	$value = get_option('lg_kalender_settings_pagestatistic', '');
	wp_dropdown_pages([
		'name' => 'lg_kalender_settings_pagestatistic',
		'id' => $args['label_for'],
		'selected' => $value,
	]);
}

function lg_kalender_call_allowRead($args)
{
	$value = get_option('lg_kalender_settings_allowRead', '');
	echo '
	<select name="lg_kalender_settings_allowRead" id="' . $args['label_for'] . '">';
	wp_dropdown_roles($value);
	echo '</select>';
	/*
	wp_dropdown_roles([
		'name' => 'lg_kalender_settings_allowRead',
		'id' => $args['label_for'],
		'selected' => $value,
	]);
	*/
}

function lg_kalender_call_allowMeldungEdit($args)
{
	$value = get_option('lg_kalender_settings_allowMeldungEdit', '');
	echo '
	<select name="lg_kalender_settings_allowMeldungEdit" id="' . $args['label_for'] . '">';
	wp_dropdown_roles($value);
	echo '</select>';
}

function lg_kalender_call_allowMeldungKostenEdit($args)
{
	$value = get_option('lg_kalender_settings_allowMeldungKostenEdit', '');
	echo '
	<select name="lg_kalender_settings_allowMeldungKostenEdit" id="' . $args['label_for'] . '">';
	wp_dropdown_roles($value);
	echo '</select>';
}

function lg_kalender_call_allowRichterEdit($args)
{
	$value = get_option('lg_kalender_settings_allowRichterEdit', '');
	echo '
	<select name="lg_kalender_settings_allowRichterEdit" id="' . $args['label_for'] . '">';
	wp_dropdown_roles($value);
	echo '</select>';
}

function lg_kalender_call_allowRichterNummerEdit($args)
{
	$value = get_option('lg_kalender_settings_allowRichterNummerEdit', '');
	echo '
	<select name="lg_kalender_settings_allowRichterNummerEdit" id="' . $args['label_for'] . '">';
	wp_dropdown_roles($value);
	echo '</select>';
}

function lg_kalender_call_allowRichterNew($args)
{
	$value = get_option('lg_kalender_settings_allowRichterNew', '');
	echo '
	<select name="lg_kalender_settings_allowRichterNew" id="' . $args['label_for'] . '">';
	wp_dropdown_roles($value);
	echo '</select>';
}
?>