<?php
if (!defined('ABSPATH')) {
	exit;
}

add_shortcode('LG_Meldungen', 'lg_meldungen');

function isEmail($email)
{
	if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
		return true;
	} else {
		return false;
	}
}

// extrahiert aus der FDF-Datei die Daten heraus. $matsches['key'],['value'] wird als Ergebnis zurückgegeben
function parsefdf($text_from_file)
{
	$pos = strpos($text_from_file, "[");
	$text_from_file = substr($text_from_file, $pos + 1);
	$pos = strpos($text_from_file, "]");
	$text_from_file = substr($text_from_file, 0, $pos);
	$text_from_file = str_replace("\n", " ", $text_from_file);
	$pos = strpos($text_from_file, "<<");
	//echo ("Position:".$pos."<br>");
	while ($pos) {
		$pos = strpos($text_from_file, "(");
		$text_from_file = substr($text_from_file, $pos + 1);
		$pos = strpos($text_from_file, ")");
		$key = substr($text_from_file, 0, $pos);
		$text_from_file = substr($text_from_file, $pos);

		$pos = strpos($text_from_file, "(");
		//$pos=strpos($text_from_file,")");
		if (strpos($text_from_file, ">>") < $pos) {
			$pos = strpos($text_from_file, "/");
			$text_from_file = substr($text_from_file, $pos + 1);
			$pos = strpos($text_from_file, "/");
			$text_from_file = substr($text_from_file, $pos + 1);
			$pos = strpos($text_from_file, ">>");
			$value = substr($text_from_file, 0, $pos);
			$text_from_file = substr($text_from_file, $pos);
		} else {
			$text_from_file = substr($text_from_file, $pos + 1);
			$pos = strpos($text_from_file, ")");
			$value = substr($text_from_file, 0, $pos);
			$text_from_file = substr($text_from_file, $pos);
		}

		//echo ("Key: $key - Value: $value <br><br>");
		$pos = strpos($text_from_file, "<<");
		$text_from_file = substr($text_from_file, $pos);
		$matches[$key] = $value;
	}
	return $matches;
}
function lg_check_string($text)
{
	if (isset($text)) {
		return $text;
		exit;
	}
	return 'k.a.';
}

function lg_input_edvdata($pincode, $nummer)
{
	global $wpdb;
	$meldung_daten = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgmeldungendaten where postid like " . $nummer);
	$html = "<form method='post'><input type='hidden' name='pincode' value='" . $pincode . "'><input type='hidden' name='schleife' value='sdata'><input type='hidden' name='datenset' value='" . $meldung_daten->id . "'><table>";
	$html .= "<tr><th>Daten zur Prüfung</th></tr>";
	$html .= '<tr><td>Prüfungsort</td></tr><tr><td><input type="text" name="meldung_p_ort" size="50" maxlength="100" value="' . stripslashes($meldung_daten->meldung_p_ort) . '"></td></tr>';
	//$meldungen = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $nummer);
	$i = getMeldungen_Count($nummer);
	$html .= '<tr><td>erschienen</td></tr><tr><td><select name="meldung_p_erschienen">';
	for ($y = 0; $y < ($i + 1); $y++) {
		$html .= "<option value='" . $y . "'" . selected($y, $meldung_daten->meldung_p_erschienen, false) . ">" . $y . "</option>";
	}
	$html .= '</select></td></tr>';
	$html .= '<tr><td>durchgeprüft</td></tr><tr><td><select name="meldung_p_durchgp">';
	for ($y = 0; $y < ($i + 1); $y++) {
		$html .= "<option value='" . $y . "'" . selected($y, $meldung_daten->meldung_p_durchgp, false) . ">" . $y . "</option>";
	}
	$html .= '</select></td></tr>';
	$html .= '<tr><td>bestanden</td></tr><tr><td><select name="meldung_p_bestanden">';
	for ($y = 0; $y < ($i + 1); $y++) {
		$html .= "<option value='" . $y . "'" . selected($y, $meldung_daten->meldung_p_bestanden, false) . ">" . $y . "</option>";
	}
	$html .= '</select></td></tr>';
	$html .= '<tr><td>Revierverhältnisse</td></tr><tr><td><input type="text" name="meldung_p_revier" size="50" maxlength="150" value="' . stripslashes($meldung_daten->meldung_p_revier) . '"></td></tr>';
	$html .= '<tr><td>Wasserverhältnisse</td></tr><tr><td><input type="text" name="meldung_p_wasser" size="50" maxlength="150" value="' . stripslashes($meldung_daten->meldung_p_wasser) . '"></td></tr>';
	/*
	$wild = array(
		"1" => "sehr gut",
		"2" => "gut",
		"3" => "ausreichend",
		"4" => "kein",
	);
	*/
	$html .= "<tr><td>Wildbesatz</td></tr><tr><td><select name='meldung_p_wild'>
							<option value='1'" . selected('1', $meldung_daten->meldung_p_wild, false) . ">" . getWild('1') . "</option>
							<option value='2'" . selected('2', $meldung_daten->meldung_p_wild, false) . ">" . getWild('2') . "</option>
							<option value='3'" . selected('3', $meldung_daten->meldung_p_wild, false) . ">" . getWild('3') . "</option>
							<option value='4'" . selected('4', $meldung_daten->meldung_p_wild, false) . ">" . getWild('4') . "</option>
							<option value='5'" . selected('5', $meldung_daten->meldung_p_wild, false) . ">" . getWild('5') . "</option>
						</select>
						</td></tr>";
	$html .= '<tr><td>Witterung</td></tr><tr><td><input type="text" name="meldung_p_witterung" size="50" maxlength="150" value="' . stripslashes($meldung_daten->meldung_p_witterung) . '"></td></tr>';
	$html .= '<tr><td>besondere Vorkommnisse</td></tr><tr><td><input type="text" name="meldung_p_vorkommnisse" size="50" maxlength="150" value="' . stripslashes($meldung_daten->meldung_p_vorkommnisse) . '"></td></tr>';
	$html .= "<tr><td><input type='submit' value='weiter'></td></tr>";
	$html .= "</table></form>";
	return $html;
}

function lg_write_edvdata($nummer)
{
	global $wpdb;
	$wpdb->update(
		$wpdb->prefix . 'lgmeldungendaten',
		//Tabellenname 
		array(
			'postid' => $nummer,
			'meldung_p_ort' => esc_html($_POST['meldung_p_ort']),
			'meldung_p_erschienen' => esc_html($_POST['meldung_p_erschienen']),
			'meldung_p_durchgp' => esc_html($_POST['meldung_p_durchgp']),
			'meldung_p_bestanden' => esc_html($_POST['meldung_p_bestanden']),
			'meldung_p_revier' => esc_html($_POST['meldung_p_revier']),
			'meldung_p_wasser' => esc_html($_POST['meldung_p_wasser']),
			'meldung_p_wild' => esc_html($_POST['meldung_p_wild']),
			'meldung_p_witterung' => esc_html($_POST['meldung_p_witterung']),
			'meldung_p_vorkommnisse' => esc_html($_POST['meldung_p_vorkommnisse'])
		),
		array('id' => esc_html($_POST['datenset'])),
		array(
			'%d',
			'%s',
			'%s',
			'%s',
			'%s',
			'%s',
			'%s',
			'%s',
			'%s',
			'%s'
		),
		array('%d')
	);
}
function lg_meldungen()
{
	global $wpdb;
	$post_id = esc_html(get_query_var('bericht'));
	$termin_gruppe = get_post_meta($post_id, 'termingruppe', true);
	if ($termin_gruppe == ''){$termin_gruppe='-1';}
	$post_id_global = $post_id;
	if ($termin_gruppe <> '-1'){
		$post_id_global = $termin_gruppe;
	}
	$pagemeldungen = get_option('lg_kalender_settings_pagemeldungen');
	$post_url_meldungen = get_page_link($pagemeldungen) . '?bericht=' . $post_id;
	$title = get_the_title($post_id);
	$CB = getPruefung($title);
	wp_enqueue_style("zz-shortcode-jscss-style");
	wp_enqueue_script('jquery');
	wp_enqueue_script("zz-shortcode-jscss-script3", array('jquery'), '1.0', true);


	$css = '
		#lg_kalender_table_meldung {font-size:' . get_option('lg_kalender_settings_size_meldung', 'unset') . ';}
	';
	wp_add_inline_style('zz-shortcode-jscss-style', $css);
	$insert_code = get_post_meta($post_id, 'terminmeldescheincode', true);
	$insert_pin = get_post_meta($post_id, 'terminmeldescheinpin', true);
	$lg_content = '
<div class = "wrap">
<div id="lgkalender">
<table cellspacing="0" cellpadding="0">
';
	if ((get_query_var('bericht')) and ((is_user_logged_in()) || (get_query_var('insert') == $insert_code) || (strlen(get_query_var('mailcode')) == 30))) {
		//$post_id = get_query_var('bericht');
		//	$post_url_meldungen = get_page_link($pagemeldungen).'?bericht='.$post_id;
		if (get_query_var('insert')) {
			if ('new' == get_query_var('insert')) {
				$wpdb->insert(
					$wpdb->prefix . 'lgmeldungen',
					//Tabellenname 
					array(
						'postid' => $post_id,
						'hund_rh' => 'R',
						'zahlung' => 'N',
						'zahlung_betrag' => '0,00',
						'preis' => '0',
						'laut' => '0',
						'fw' => '0',
						'bp_vorhanden' => '0',
						'lt_vorhanden' => '0',
						'schussjp_vorhanden' => '0',
						'sortierung' => '0',
						'mail_code' => randomString(30)
					),
					array(
						'%d',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s' //String-Wert (column1)

					)
				);
				echo ("<script>location.href = '" . $post_url_meldungen . '&warnung=new' . "'</script>");
				//wp_redirect($post_url_meldungen . '&warnung=new');
				exit;
			}
			if ('import' == get_query_var('insert')) {
				if (isset($_POST['getDATA'])) {
					if ($_POST['getDATA'] == 'true') {
						define('MULTIPART_BOUNDARY', '--------------------------' . microtime(true));
						$header = 'Content-Type: multipart/form-data; boundary=' . MULTIPART_BOUNDARY;
						define('FORM_FIELD', 'uploadedfile');
						$filename = $_FILES['uploadedfile']['tmp_name'];
						$file_contents = file_get_contents($filename);
						$content = "--" . MULTIPART_BOUNDARY . "\r\n" .
							"Content-Disposition: form-data; name=\"" . FORM_FIELD . "\"; filename=\"" . basename($filename) . "\"\r\n" .
							"Content-Type: application/zip\r\n\r\n" .
							$file_contents . "\r\n";

						// add some POST fields to the request too: $_POST['foo'] = 'bar'
						$content .= "--" . MULTIPART_BOUNDARY . "\r\n" .
							"Content-Disposition: form-data; name=\"getDATA\"\r\n\r\n" .
							"true\r\n";

						// signal end of request (note the trailing "--")
						$content .= "--" . MULTIPART_BOUNDARY . "--\r\n";
						$url = 'https://nienhausen.com/mypdftk';
						$context = stream_context_create(
							array(
								'http' => array(
									'method' => 'POST',
									'header' => $header,
									'content' => $content,
								)
							)
						);
						$url = file_get_contents($url);
						$result = file_get_contents($url, false, $context);
						if ($result === FALSE) { /* Handle error */
						} else {
							$result = iconv("ISO-8859-1", "UTF-8", $result);
							$fdf_meldung = parsefdf($result);
							//echo ("Bis hierhin ok ... <br>$result");
							if ($fdf_meldung['JGHV'] == '1') {
								$mitgliedsnummer = '';
								if ($fdf_meldung['Geschlecht'] == 'Hündin') {
									$geschlecht = 'H';
								} else {
									$geschlecht = 'R';
								}
								$chip = $fdf_meldung['Text10'] . $fdf_meldung['Text11'] . $fdf_meldung['Text12'] . $fdf_meldung['Text13'] . $fdf_meldung['Text14'] . $fdf_meldung['Text15'] . $fdf_meldung['Text16'] . $fdf_meldung['Text17'] . $fdf_meldung['Text18'] . $fdf_meldung['Text19'] . $fdf_meldung['Text110'] . $fdf_meldung['Text111'] . $fdf_meldung['Text112'] . $fdf_meldung['Text113'] . $fdf_meldung['Text114'];
								$wpdb->insert(
									$wpdb->prefix . 'lgmeldungen',
									//Tabellenname 
									array(
										'postid' => $post_id,
										'hund_name' => esc_html(lg_check_string($fdf_meldung['NamedesHundes'])),
										'hund_rh' => esc_html(lg_check_string($geschlecht)),
										'hund_zbnr' => esc_html(lg_check_string($fdf_meldung['ZBNr'])),
										'hund_wurftag' => esc_html(lg_check_string($fdf_meldung['gew'])),
										'hund_chipnr' => esc_html(lg_check_string($chip)),
										'hund_mutter' => esc_html(lg_check_string($fdf_meldung['Mutter'])),
										'hund_mutter_zbnr' => esc_html(lg_check_string($fdf_meldung['ZBNr_2'])),
										'hund_vater' => esc_html(lg_check_string($fdf_meldung['Vater'])),
										'hund_vater_zbnr' => esc_html(lg_check_string($fdf_meldung['ZBNr_3'])),
										'e_name' => esc_html(lg_check_string($fdf_meldung['Eigentümer vollständige Anschrift 1'])),
										'e_mitglied' => esc_html(lg_check_string($mitgliedsnummer)),
										'e_plzort' => esc_html(('k.a.')),
										'e_strasse' => esc_html(lg_check_string($fdf_meldung['Eigentümer vollständige Anschrift 2'])),
										'e_email' => esc_html(('k.a.')),
										'e_telefon' => esc_html(lg_check_string($fdf_meldung['Telefon'])),
										'f_name' => esc_html(lg_check_string($fdf_meldung['Führer'])),
										'f_telefon' => esc_html(lg_check_string($fdf_meldung['Telefon_3'])),
										'f_plzort' => esc_html(lg_check_string($fdf_meldung['PLZ']) . ' ' . lg_check_string($fdf_meldung['Wohnort'])),
										'f_strasse' => esc_html(lg_check_string($fdf_meldung['undefined_15'])),
										'posteingang' => 'N',
										'meldungok' => 'N',
										'zahlung' => 'N',
										'zahlung_betrag' => '0,00',
										'preis' => '0',
										'laut' => '0',
										'fw' => '0',
										'bp_vorhanden' => '0',
										'lt_vorhanden' => '0',
										'schussjp_vorhanden' => '0',
										'sortierung' => '0',
										'mail_code' => randomString(30)
									),
									array(
										'%d',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s' //String-Wert (column1)

									)
								);
							} else {
								$mitgliedsnummer = $fdf_meldung['Nr_1'] . $fdf_meldung['Nr_2'] . $fdf_meldung['Nr_3'] . $fdf_meldung['Nr_4'];
								if ($fdf_meldung['Hund_RH'] == 'R') {
									$geschlecht = 'R';
								} else {
									$geschlecht = 'H';
								}
								$wpdb->insert(
									$wpdb->prefix . 'lgmeldungen',
									//Tabellenname 
									array(
										'postid' => $post_id,
										'hund_name' => esc_html(lg_check_string($fdf_meldung['Name_Hund'])),
										'hund_rh' => esc_html($geschlecht),
										'hund_zbnr' => esc_html(lg_check_string($fdf_meldung['ZBNR'])),
										'hund_wurftag' => esc_html(lg_check_string($fdf_meldung['W_Tag'])),
										'hund_chipnr' => esc_html(lg_check_string($fdf_meldung['Chip_Nr'])),
										'hund_mutter' => esc_html(lg_check_string($fdf_meldung['Mutter'])),
										'hund_vater' => esc_html(lg_check_string($fdf_meldung['Vater'])),
										'e_name' => esc_html(lg_check_string($fdf_meldung['B_Name'])),
										'e_mitglied' => esc_html(lg_check_string($mitgliedsnummer)),
										'e_plzort' => esc_html(lg_check_string($fdf_meldung['B_PLZOrt'])),
										'e_strasse' => esc_html(lg_check_string($fdf_meldung['B_Strasse'])),
										'e_email' => esc_html(lg_check_string($fdf_meldung['B_Mail'])),
										'e_telefon' => esc_html(lg_check_string($fdf_meldung['B_Telefon'])),
										'f_name' => esc_html(lg_check_string($fdf_meldung['HF_Name'])),
										'f_telefon' => esc_html(lg_check_string($fdf_meldung['HF_Telefon'])),
										'f_plzort' => esc_html(lg_check_string($fdf_meldung['HF_PLZOrt'])),
										'f_strasse' => esc_html(lg_check_string($fdf_meldung['HF_Strasse'])),
										'posteingang' => 'N',
										'meldungok' => 'N',
										'zahlung' => 'N',
										'zahlung_betrag' => '0,00',
										'preis' => '0',
										'laut' => '0',
										'fw' => '0',
										'bp_vorhanden' => '0',
										'lt_vorhanden' => '0',
										'schussjp_vorhanden' => '0',
										'sortierung' => '0',
										'mail_code' => randomString(30)
									),
									array(
										'%d',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s',
										'%s' //String-Wert (column1)

									)
								);
							}
							//echo ($wpdb->last_error);
							if ($post_id <> $fdf_meldung['postid']) {
								echo ("<script>location.href = '" . $post_url_meldungen . '&warnung=import' . "'</script>");
								//wp_redirect($post_url_meldungen . '&warnung=import');
							} else {
								echo ("<script>location.href = '" . $post_url_meldungen . "'</script>");
								//wp_redirect($post_url_meldungen);
							}
							//exit;
						}
					}
				} else {
					$lg_content .= "<div id='lgkalender'><br><br><form enctype='multipart/form-data' method='POST'>
<input type='hidden' name='getDATA' value='true'>
wähle den Meldeschein zum Upload: <input name='uploadedfile' type='file'><br><br>
<input type='submit' value='Upload'>
</form><br>";
				}
			}
			if ($insert_code == get_query_var('insert')) {
				if ($_POST['pincode'] == $insert_pin) {
					$lg_content = '
				<tr><td>Pin OK !!!</td></tr>
				</table>
				';
					if ($CB == 'SJG') {
						if ($_POST['dogid']) {
							$wpdb->update(
								$wpdb->prefix . 'lgmeldungen',
								//Tabellenname 
								array(
									'preis' => esc_html($_POST['preis']),
									'sortierung' => esc_html($_POST['sortierung'])
								),
								array('id' => esc_html($_POST['dogid'])),
								array(
									'%s',
									'%s' //String-Wert (column1)
								),
								array('%d')
							);
						}
						if ($_POST['schleife']) {
							$schleife = esc_html($_POST['schleife']);
						} else {
							$schleife = 0;
						}
						if ($_POST['schleife'] == 'pdata') {
							$lg_content .= lg_input_edvdata($_POST['pincode'], $post_id);
						} elseif ($_POST['schleife'] == 'sdata') {
							lg_write_edvdata($post_id);
							echo ("<script>location.href = '" . home_url() . "'</script>");
							//wp_redirect(home_url());
						} else {
							$meldungen = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id);
							$max = count($meldungen);
							$i = 0;
							foreach ($meldungen as $meldung) {
								$i++;
								if ($i > $schleife) {
									if ($max == $i) {
										$i_in = 'pdata';
									} else {
										$i_in = $i;
									}
									$lg_content .= "<form method='post'><input type='hidden' name='dogid' value='" . $meldung->id . "'><input type='hidden' name='pincode' value='" . $_POST['pincode'] . "'><input type='hidden' name='schleife' value='" . $i_in . "'><table>";
									$lg_content .= "<tr><th>" . stripslashes($meldung->hund_name) . "</th></tr>";
									$lg_content .= "<tr><td>bestanden ?</td></tr>";
									$lg_content .= "<tr><td><select name='preis'>
							<option value='0'" . selected('0', $meldung->preis, false) . ">" . getPreis('0') . "</option>
							<option value='8'" . selected('8', $meldung->preis, false) . ">" . getPreis('8') . "</option>
							<option value='4'" . selected('4', $meldung->preis, false) . ">" . getPreis('4') . "</option>
							<option value='5'" . selected('5', $meldung->preis, false) . ">" . getPreis('5') . "</option>
							</select></td></tr>";
									$lg_content .= "<tr><td>Sortierung Reihenfolge ?</td></tr>";
									$lg_content .= "<tr><td><select name='sortierung'>";
									//$wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id);
									for ($y = 1; $y < ((getMeldungen_Count($post_id_global)) + 1); $y++) {
										$lg_content .= "<option value='" . $y . "'" . selected($y, $meldung->sortierung, false) . ">" . $y . "</option>";
									}
									$lg_content .= "</td></tr>";
									$lg_content .= "<tr><td><input type='submit' value='weiter'></td></tr>";
									$lg_content .= "</table></form>";
									break;
								}
							}
							if ($i == $schleife) {
								echo ("<script>location.href = '" . home_url() . "'</script>");
								//wp_redirect(home_url());
							}
						}
					}

					if ($CB == 'WT') {
						if ($_POST['dogid']) {
							$sortierung = '';
							if (esc_html($_POST['preis']) == '8') {
								$sortierung = '1';
							}
							if (esc_html($_POST['preis']) == '4') {
								$sortierung = '3';
							}
							if (esc_html($_POST['preis']) == '5') {
								$sortierung = '5';
							}
							$wpdb->update(
								$wpdb->prefix . 'lgmeldungen',
								//Tabellenname 
								array(
									'preis' => esc_html($_POST['preis']),
									'sortierung' => $sortierung
								),
								array('id' => esc_html($_POST['dogid'])),
								array(
									'%s',
									'%s' //String-Wert (column1)
								),
								array('%d')
							);
						}
						if ($_POST['schleife']) {
							$schleife = esc_html($_POST['schleife']);
						} else {
							$schleife = 0;
						}
						if ($_POST['schleife'] == 'pdata') {
							$lg_content .= lg_input_edvdata($_POST['pincode'], $post_id);
						} elseif ($_POST['schleife'] == 'sdata') {
							lg_write_edvdata($post_id);
							echo ("<script>location.href = '" . home_url() . "'</script>");
							//wp_redirect(home_url());
						} else {
							$meldungen = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id);
							$max = count($meldungen);
							$i = 0;
							foreach ($meldungen as $meldung) {
								$i++;
								if ($i > $schleife) {
									if ($max == $i) {
										$i_in = 'pdata';
									} else {
										$i_in = $i;
									}
									$lg_content .= "<form method='post'><input type='hidden' name='dogid' value='" . $meldung->id . "'><input type='hidden' name='pincode' value='" . $_POST['pincode'] . "'><input type='hidden' name='schleife' value='" . $i_in . "'><table>";
									$lg_content .= "<tr><th>" . stripslashes($meldung->hund_name) . "</th></tr>";
									$lg_content .= "<tr><td>bestanden ?</td></tr>";
									$lg_content .= "<tr><td><select name='preis'>
							<option value='0'" . selected('0', $meldung->preis, false) . ">" . getPreis('0') . "</option>
							<option value='8'" . selected('8', $meldung->preis, false) . ">" . getPreis('8') . "</option>
							<option value='4'" . selected('4', $meldung->preis, false) . ">" . getPreis('4') . "</option>
							<option value='5'" . selected('5', $meldung->preis, false) . ">" . getPreis('5') . "</option>
							</select></td></tr>";
									$lg_content .= "<tr><td>Sortierung Reihenfolge ?</td></tr>";
									$lg_content .= "<tr><td><select name='sortierung'>";
									//$wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id);
									for ($y = 1; $y < ((getMeldungen_Count($post_id_global)) + 1); $y++) {
										$lg_content .= "<option value='" . $y . "'" . selected($y, $meldung->sortierung, false) . ">" . $y . "</option>";
									}
									$lg_content .= "</td></tr>";
									$lg_content .= "<tr><td><input type='submit' value='weiter'></td></tr>";
									$lg_content .= "</table></form>";
									break;
								}
							}
							if ($i == $schleife) {
								echo ("<script>location.href = '" . home_url() . "'</script>");
								//wp_redirect(home_url());
							}
						}
					}

					if ($CB == 'ZS') {
						if ($_POST['dogid']) {
							if ($_POST['fw'] < 4) {
								$sortierung = '1';
							} else {
								$sortierung = '2';
							}
							$wpdb->update(
								$wpdb->prefix . 'lgmeldungen',
								//Tabellenname 
								array(
									'fw' => esc_html($_POST['fw']),
									'wh' => esc_html($_POST['wh']),
									'bu' => esc_html($_POST['bu']),
									'haar' => esc_html($_POST['haar']),
									'gebiss' => esc_html($_POST['gebiss']),
									'sortierung' => $sortierung
								),
								array('id' => esc_html($_POST['dogid'])),
								array(
									'%s',
									'%s',
									'%s',
									'%s',
									'%s',
									'%s' //String-Wert (column1)
								),
								array('%d')
							);
						}
						if ($_POST['schleife']) {
							$schleife = esc_html($_POST['schleife']);
						} else {
							$schleife = 0;
						}
						if ($_POST['schleife'] == 'pdata') {
							$lg_content .= lg_input_edvdata($_POST['pincode'], $post_id);
						} elseif ($_POST['schleife'] == 'sdata') {
							lg_write_edvdata($post_id);
							echo ("<script>location.href = '" . home_url() . "'</script>");
							//wp_redirect(home_url());
						} else {
							$meldungen = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id);
							$max = count($meldungen);
							$i = 0;
							foreach ($meldungen as $meldung) {
								$i++;
								if ($i > $schleife) {
									if ($max == $i) {
										$i_in = 'pdata';
									} else {
										$i_in = $i;
									}
									$lg_content .= "<form method='post'><input type='hidden' name='dogid' value='" . $meldung->id . "'><input type='hidden' name='pincode' value='" . $_POST['pincode'] . "'><input type='hidden' name='schleife' value='" . $i_in . "'><table>";
									$lg_content .= "<tr><th>" . stripslashes($meldung->hund_name) . "</th></tr>";
									$lg_content .= "<tr><td>Formwert ?</td></tr>";
									$lg_content .= "<tr><td><select name='fw'>
							<option value='0'" . selected('0', $meldung->fw, false) . ">" . getFormwert('0') . "</option>
							<option value='1'" . selected('1', $meldung->fw, false) . ">" . getFormwert('1') . "</option>
							<option value='2'" . selected('2', $meldung->fw, false) . ">" . getFormwert('2') . "</option>
							<option value='3'" . selected('3', $meldung->fw, false) . ">" . getFormwert('3') . "</option>
							<option value='4'" . selected('5', $meldung->fw, false) . ">" . getFormwert('4') . "</option>
							<option value='5'" . selected('6', $meldung->fw, false) . ">" . getFormwert('5') . "</option>
							</select></td></tr>";
									$lg_content .= "<tr><td>Widerristhöhe (WH) ?</td></tr>";
									$lg_content .= "<tr><td><input type='text' name='wh' size='10' maxlength='4' value='" . $meldung->wh . "'></td></tr>";
									$lg_content .= "<tr><td>Brustumfang (BU) ?</td></tr>";
									$lg_content .= "<tr><td><input type='text' name='bu' size='10' maxlength='4' value='" . $meldung->bu . "'></td></tr>";
									$lg_content .= "<tr><td>Haar ?</td></tr>";
									$lg_content .= '<tr><td><input list="haars" name="haar" id="haar" value="' . $meldung->haar . '">
							<datalist id="haars">
								<option value="glatt">
								<option value="rau">
							</datalist></td></tr>';
									$lg_content .= "<tr><td>Gebiss ?</td></tr>";
									$lg_content .= "<tr><td><input list='gebisss' name='gebiss' id='gebiss' value='" . stripslashes($meldung->gebiss) . "'>
							<datalist id='gebisss'>
								<option value='vollz. Schere'>
								<option value='P1 u.re.fehlt'>
								<option value='P1 u.li.fehlt'>
								<option value='P1 u.li+re.fehlt'>
								<option value='P2 u.re.fehlt'>
								<option value='P2 u.li.fehlt'>
								<option value='P2 u.li+re.fehlt'>
								<option value='P4 u.re.fehlt'>
								<option value='P4 u.li.fehlt'>
								<option value='P4 u.li+re.fehlt'>
							</datalist></td></tr>";
									$lg_content .= "</td></tr>";
									$lg_content .= "<tr><td><input type='submit' value='weiter'></td></tr>";
									$lg_content .= "</table></form>";
									break;
								}
							}
							if ($i == $schleife) {
								echo ("<script>location.href = '" . home_url() . "'</script>");
								//wp_redirect(home_url());
							}
						}
					}

					if (($CB == 'JP') || ($CB == 'ZP') || ($CB == 'VStP') || ($CB == 'GP')) {
						if ($_POST['dogid']) {
							$wpdb->update(
								$wpdb->prefix . 'lgmeldungen',
								//Tabellenname 
								array(
									'preis' => esc_html($_POST['preis']),
									'laut' => esc_html($_POST['laut']),
									'punkte' => esc_html($_POST['punkte']),
									'sortierung' => esc_html($_POST['sortierung'])
								),
								array('id' => esc_html($_POST['dogid'])),
								array(
									'%s',
									'%s',
									'%s',
									'%s' //String-Wert (column1)
								),
								array('%d')
							);
						}
						if ($_POST['schleife']) {
							$schleife = esc_html($_POST['schleife']);
						} else {
							$schleife = 0;
						}
						if ($_POST['schleife'] == 'pdata') {
							$lg_content .= lg_input_edvdata($_POST['pincode'], $post_id);
						} elseif ($_POST['schleife'] == 'sdata') {
							lg_write_edvdata($post_id);
							echo ("<script>location.href = '" . home_url() . "'</script>");
							//wp_redirect(home_url());
						} else {
							$meldungen = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id);
							$max = count($meldungen);
							$i = 0;
							foreach ($meldungen as $meldung) {
								$i++;
								if ($i > $schleife) {
									if ($max == $i) {
										$i_in = 'pdata';
									} else {
										$i_in = $i;
									}
									$lg_content .= "<form method='post'><input type='hidden' name='dogid' value='" . $meldung->id . "'><input type='hidden' name='pincode' value='" . $_POST['pincode'] . "'><input type='hidden' name='schleife' value='" . $i_in . "'><table>";
									$lg_content .= "<tr><th>" . $meldung->hund_name . "</th></tr>";
									$lg_content .= "<tr><td>Laut ?</td></tr>";
									$lg_content .= "<tr><td><select name='laut'>
							<option value='0'" . selected('0', $meldung->laut, false) . ">" . getLaut('0') . "</option>
							<option value='1'" . selected('1', $meldung->laut, false) . ">" . getLaut('1') . "</option>
							<option value='2'" . selected('2', $meldung->laut, false) . ">" . getLaut('2') . "</option>
							<option value='3'" . selected('3', $meldung->laut, false) . ">" . getLaut('3') . "</option>
							<option value='3'" . selected('4', $meldung->laut, false) . ">" . getLaut('4') . "</option>
							<option value='5'" . selected('5', $meldung->laut, false) . ">" . getLaut('5') . "</option>
							<option value='6'" . selected('6', $meldung->laut, false) . ">" . getLaut('6') . "</option>
							<option value='7'" . selected('7', $meldung->laut, false) . ">" . getLaut('7') . "</option>
							</select></td></tr>";
									$lg_content .= "<tr><td>Punkte ?</td></tr>";
									$lg_content .= "<tr><td><input type='text' name='punkte' size='10' maxlength='3' value='" . $meldung->punkte . "'></td></tr>";
									$lg_content .= "<tr><td>Preis ?</td></tr>";
									$lg_content .= "<tr><td><select name='preis'>
							<option value='0'" . selected('0', $meldung->preis, false) . ">" . getPreis('0') . "</option>'";
									if ($CB != 'VStP') {
										$lg_content .= "
							<option value='1'" . selected('1', $meldung->preis, false) . ">" . getPreis('1') . "</option>
							<option value='2'" . selected('2', $meldung->preis, false) . ">" . getPreis('2') . "</option>
							<option value='3'" . selected('3', $meldung->preis, false) . ">" . getPreis('3') . "</option>";
									} else {
										$lg_content .= "<option value='8'" . selected('3', $meldung->preis, false) . ">" . getPreis('8') . "</option>";
									}
									$lg_content .= "
							<option value='4'" . selected('4', $meldung->preis, false) . ">" . getPreis('4') . "</option>
							<option value='5'" . selected('5', $meldung->preis, false) . ">" . getPreis('5') . "</option>
							</select></td></tr>";
									$lg_content .= "<tr><td>Sortierung Reihenfolge ?</td></tr>";
									$lg_content .= "<tr><td><select name='sortierung'>";
									//$wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id);
									for ($y = 1; $y < ((getMeldungen_Count($post_id_global)) + 1); $y++) {
										$lg_content .= "<option value='" . $y . "'" . selected($y, $meldung->sortierung, false) . ">" . $y . "</option>";
									}
									$lg_content .= "</td></tr>";
									$lg_content .= "<tr><td><input type='submit' value='weiter'></td></tr>";
									$lg_content .= "</table></form>";
									break;
								}
							}
							if ($i == $schleife) {
								echo ("<script>location.href = '" . home_url() . "'</script>");
								//wp_redirect(home_url());
							}
						}
					}


					if (($CB == 'BP')) {
						if ($_POST['dogid']) {
							$wpdb->update(
								$wpdb->prefix . 'lgmeldungen',
								//Tabellenname 
								array(
									'preis' => esc_html($_POST['preis']),
									'punkte' => esc_html($_POST['punkte']),
									'sortierung' => esc_html($_POST['sortierung'])
								),
								array('id' => esc_html($_POST['dogid'])),
								array(
									'%s',
									'%s',
									'%s' //String-Wert (column1)
								),
								array('%d')
							);
						}
						if ($_POST['schleife']) {
							$schleife = esc_html($_POST['schleife']);
						} else {
							$schleife = 0;
						}
						if ($_POST['schleife'] == 'pdata') {
							$lg_content .= lg_input_edvdata($_POST['pincode'], $post_id);
						} elseif ($_POST['schleife'] == 'sdata') {
							lg_write_edvdata($post_id);
							echo ("<script>location.href = '" . home_url() . "'</script>");
							//wp_redirect(home_url());
						} else {
							$meldungen = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id);
							$max = count($meldungen);
							$i = 0;
							foreach ($meldungen as $meldung) {
								$i++;
								if ($i > $schleife) {
									if ($max == $i) {
										$i_in = 'pdata';
									} else {
										$i_in = $i;
									}
									$lg_content .= "<form method='post'><input type='hidden' name='dogid' value='" . $meldung->id . "'><input type='hidden' name='pincode' value='" . $_POST['pincode'] . "'><input type='hidden' name='schleife' value='" . $i_in . "'><table>";
									$lg_content .= "<tr><th>" . $meldung->hund_name . "</th></tr>";
									$lg_content .= "<tr><td>Punkte ?</td></tr>";
									$lg_content .= "<tr><td><input type='text' name='punkte' size='10' maxlength='3' value='" . $meldung->punkte . "'></td></tr>";
									$lg_content .= "<tr><td>Preis ?</td></tr>";
									$lg_content .= "<tr><td><select name='preis'>
							<option value='0'" . selected('0', $meldung->preis, false) . ">-</option>
							<option value='1'" . selected('1', $meldung->preis, false) . ">1.Preis</option>
							<option value='2'" . selected('2', $meldung->preis, false) . ">2.Preis</option>
							<option value='3'" . selected('3', $meldung->preis, false) . ">3.Preis</option>
							<option value='4'" . selected('4', $meldung->preis, false) . ">nicht bestanden</option>
							<option value='5'" . selected('5', $meldung->preis, false) . ">nicht erschienen</option>
							</select></td></tr>";
									$lg_content .= "<tr><td>Sortierung Reihenfolge ?</td></tr>";
									$lg_content .= "<tr><td><select name='sortierung'>";
									//$wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id);
									for ($y = 1; $y < ((getMeldungen_Count($post_id_global)) + 1); $y++) {
										$lg_content .= "<option value='" . $y . "'" . selected($y, $meldung->sortierung, false) . ">" . $y . "</option>";
									}
									$lg_content .= "</td></tr>";
									$lg_content .= "<tr><td><input type='submit' value='weiter'></td></tr>";
									$lg_content .= "</table></form>";
									break;
								}
							}
							if ($i == $schleife) {
								echo ("<script>location.href = '" . home_url() . "'</script>");
								//wp_redirect(home_url());
							}
						}
					}
				} else {
					$lg_content .= '
				<tr><td><form method="post" id="mailform"><input type="text" name="pincode" placeholder="Pin-Code" maxlength="10" size="10"><br><input type="submit" value="abschicken"></td></tr>
				';
				}
				$lg_content .= "</table></div></div>";
				return $lg_content;
				exit;
			}
			if ('sendmail' == get_query_var('insert')) {
				if (get_query_var('mailcode')) {
					$wpdb->update(
						$wpdb->prefix . 'lgmeldungen',
						//Tabellenname 
						array(
							'gelesen' => 'J'
						),
						array('mail_code' => esc_html(get_query_var('mailcode'))),
						array(
							'%s' //String-Wert (column1)
						),
						array('%s')
					);
					$wpdb->update(
						$wpdb->prefix . 'lgmeldungenrichter',
						//Tabellenname 
						array(
							'gelesen_pl' => 'J'
						),
						array('mail_code_pl' => esc_html(get_query_var('mailcode'))),
						array(
							'%s' //String-Wert (column1)
						),
						array('%s')
					);
					$wpdb->update(
						$wpdb->prefix . 'lgmeldungenrichter',
						//Tabellenname 
						array(
							'gelesen_po' => 'J'
						),
						array('mail_code_po' => esc_html(get_query_var('mailcode'))),
						array(
							'%s' //String-Wert (column1)
						),
						array('%s')
					);
					$wpdb->update(
						$wpdb->prefix . 'lgmeldungenrichter',
						//Tabellenname 
						array(
							'gelesen_r2' => 'J'
						),
						array('mail_code_r2' => esc_html(get_query_var('mailcode'))),
						array(
							'%s' //String-Wert (column1)
						),
						array('%s')
					);
					$wpdb->update(
						$wpdb->prefix . 'lgmeldungenrichter',
						//Tabellenname 
						array(
							'gelesen_r3' => 'J'
						),
						array('mail_code_r3' => esc_html(get_query_var('mailcode'))),
						array(
							'%s' //String-Wert (column1)
						),
						array('%s')
					);
					$wpdb->update(
						$wpdb->prefix . 'lgmeldungenrichter',
						//Tabellenname 
						array(
							'gelesen_ra' => 'J'
						),
						array('mail_code_ra' => esc_html(get_query_var('mailcode'))),
						array(
							'%s' //String-Wert (column1)
						),
						array('%s')
					);
					$lg_content .= '<br><p>Vielen Dank für die Empfangsbestätigung !';
					$lg_content .= "</table></div></div>";
					return $lg_content;
					exit;
				} else {
					$issend = false;
					if ('abschicken' == ($_POST['submit'] ?? '')) {
						if (($_POST['reply'] == $_POST['reply2']) && ($_POST['reply'] > '')) {
							$error = $_FILES['uploadedfile']['error'];
							if ($error == UPLOAD_ERR_OK) {
								$filename = $_FILES['uploadedfile']['tmp_name'];
								$target = WP_PLUGIN_DIR . "/lg-kalender/inc/temp/Einladung.pdf";
								move_uploaded_file($filename, $target);
								$file_contents = file_get_contents($filename);
								$issend = true;
								$lg_content = '<p>Einladung wird verschickt !';
								$body = $_POST['body'];
								$subject = $_POST['subject'];
								$reply = $_POST['reply'];
								$to = "<$reply>";
								$separator = md5(time());
								$eol = PHP_EOL;
								$protocols = array('http://', 'https://', 'http://www.', 'https://www.', 'www.');
								$mydomain = str_replace($protocols, '', site_url());
								// main header (multipart mandatory)
								$headers = 'From: PRTCD LG-' . get_option('lg_kalender_settings_name', true) . ' <noreply@' . $mydomain . '>' . "\r\n";
								$headers .= 'Reply-To: <' . $reply . '>' . "\r\n";
								$headers .= "MIME-Version: 1.0" . $eol;
								//$headers .= "Content-Type: multipart/mixed; boundary=\"".$separator."\"".$eol; // see below 
								$headers .= "'Content-Type: text/html; charset=UTF-8'";
								//$headers .= "Content-Transfer-Encoding: 7bit".$eol;
								// message
								//$attachment = array($PdfFileUrl);
								$report_msg = '';
								// send message Teilnehmer
								$gesendet = array();
								$meldungen = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id);
								foreach ($meldungen as $meldung) {
									$emailadresse = $meldung->e_email;
									if ((isEmail($emailadresse)) && (!in_array($emailadresse, $gesendet))) {
										$gesendet[] = $emailadresse;
										$to = '<' . $emailadresse . '>';
										$mailcode = $meldung->mail_code;
										$maillink = get_page_link(get_option('lg_kalender_settings_pagemeldungen', '')) . '?bericht=' . $post_id . '&insert=sendmail&mailcode=' . $mailcode;
										$email_message = str_replace("{maillink}", $maillink, $body);
										$msg = $email_message . $eol . $eol;
										if (wp_mail($to, $subject, $msg, $headers, $target)) {
											//break 2;
											$report_msg .= "An " . $to . " erfolgreich gesendet (" . stripslashes($meldung->hund_name) . " / " . stripslashes($meldung->e_name) . ")\n" . $eol;
										} else {
											$report_msg .= "An " . $to . " nicht gesendet (" . stripslashes($meldung->hund_name) . " / " . stripslashes($meldung->e_name) . ")\n" . $eol;
										}
									} else {
										$report_msg .= " An " . $emailadresse . " nicht gesendet. (" . stripslashes($meldung->hund_name) . " / " . stripslashes($meldung->e_name) . ") => E-Mail doppelt vorhanden oder falsche E-Mail\n" . $eol;
									}
								}
								// send message Richter
								/*
								$gesendet = array();
								$meldungen = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgmeldungenrichter where postid like " . $post_id);
								$richter = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgrichter where id like " . $meldungen->pl);
								$emailadresse = filter_var($richter->email, FILTER_SANITIZE_EMAIL);
								if (isEmail($emailadresse)) {
									$gesendet[] = $emailadresse;
									$to = '<' . $emailadresse . '>';
									$mailcode = $meldungen->mail_code_pl;
									$maillink = get_page_link(get_option('lg_kalender_settings_pagemeldungen', '')) . '?bericht=' . $post_id . '&insert=sendmail&mailcode=' . $mailcode;
									$email_message = str_replace("{maillink}", $maillink, $body);
									$msg = $email_message . $eol . $eol;
									if (wp_mail($to, $subject, $msg, $headers, $target)) {
										//break 2;
										$report_msg .= "An " . $to . " erfolgreich gesendet (Prüfungleiter, " . stripslashes($richter->vorname) . " " . stripslashes($richter->nachname) . ")\n" . $eol;
									} else {
										$report_msg .= "An " . $to . " nicht gesendet (Prüfungleiter, " . stripslashes($richter->vorname) . " " . stripslashes($richter->nachname) . ")\n" . $eol;
									}
								} else {
									$report_msg .= " An " . $emailadresse . " nicht gesendet. (Prüfungsleiter, " . stripslashes($richter->vorname) . " " . stripslashes($richter->nachname) . ") => E-Mail doppelt vorhanden oder falsche E-Mail\n" . $eol;
								}
								$richter = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgrichter where id like " . $meldungen->po);
								$emailadresse = filter_var($richter->email, FILTER_SANITIZE_EMAIL);
								if ((isEmail($emailadresse)) && (!in_array($emailadresse, $gesendet))) {
									$gesendet[] = $emailadresse;
									$to = '<' . $emailadresse . '>';
									$mailcode = $meldungen->mail_code_po;
									$maillink = get_page_link(get_option('lg_kalender_settings_pagemeldungen', '')) . '?bericht=' . $post_id . '&insert=sendmail&mailcode=' . $mailcode;
									$email_message = str_replace("{maillink}", $maillink, $body);
									$msg = $email_message . $eol . $eol;
									if (wp_mail($to, $subject, $msg, $headers, $target)) {
										//break 2;
										$report_msg .= "An " . $to . " erfolgreich gesendet (Prüfungsobmann, " . stripslashes($richter->vorname) . " " . stripslashes($richter->nachname) . ")\n" . $eol;
									} else {
										$report_msg .= "An " . $to . " nicht gesendet (Prüfungsobmann, " . stripslashes($richter->vorname) . " " . stripslashes($richter->nachname) . ")\n" . $eol;
									}
								} else {
									$report_msg .= " An " . $emailadresse . " nicht gesendet. (Prüfungsobmann, " . stripslashes($richter->vorname) . " " . stripslashes($richter->nachname) . ") => E-Mail doppelt vorhanden oder falsche E-Mail\n" . $eol;
								}
								$richter = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgrichter where id like " . $meldungen->r2);
								$emailadresse = filter_var($richter->email, FILTER_SANITIZE_EMAIL);
								if ((isEmail($emailadresse)) && (!in_array($emailadresse, $gesendet))) {
									$gesendet[] = $emailadresse;
									$to = '<' . $emailadresse . '>';
									$mailcode = $meldung->mail_code_r2;
									$maillink = get_page_link(get_option('lg_kalender_settings_pagemeldungen', '')) . '?bericht=' . $post_id . '&insert=sendmail&mailcode=' . $mailcode;
									$email_message = str_replace("{maillink}", $maillink, $body);
									$msg = $email_message . $eol . $eol;
									if (wp_mail($to, $subject, $msg, $headers, $target)) {
										//break 2;
										$report_msg .= "An " . $to . " erfolgreich gesendet (Richter 2, " . stripslashes($richter->vorname) . " " . stripslashes($richter->nachname) . ")\n" . $eol;
									} else {
										$report_msg .= "An " . $to . " nicht gesendet (Richter 2, " . stripslashes($richter->vorname) . " " . stripslashes($richter->nachname) . ")\n" . $eol;
									}
								} else {
									$report_msg .= " An " . $emailadresse . " nicht gesendet. (Richter 2, " . stripslashes($richter->vorname) . " " . stripslashes($richter->nachname) . ") => E-Mail doppelt vorhanden oder falsche E-Mail\n" . $eol;
								}
								$richter = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgrichter where id like " . $meldungen->r3);
								$emailadresse = filter_var($richter->email, FILTER_SANITIZE_EMAIL);
								if ((isEmail($emailadresse)) && (!in_array($emailadresse, $gesendet))) {
									$gesendet[] = $emailadresse;
									$to = '<' . $emailadresse . '>';
									$mailcode = $meldungen->mail_code_r3;
									$maillink = get_page_link(get_option('lg_kalender_settings_pagemeldungen', '')) . '?bericht=' . $post_id . '&insert=sendmail&mailcode=' . $mailcode;
									$email_message = str_replace("{maillink}", $maillink, $body);
									$msg = $email_message . $eol . $eol;
									if (wp_mail($to, $subject, $msg, $headers, $target)) {
										//break 2;
										$report_msg .= "An " . $to . " erfolgreich gesendet (Richter 3, " . stripslashes($richter->vorname) . " " . stripslashes($richter->nachname) . ")\n" . $eol;
									} else {
										$report_msg .= "An " . $to . " nicht gesendet (Richter 3, " . stripslashes($richter->vorname) . " " . stripslashes($richter->nachname) . ")\n" . $eol;
									}
								} else {
									$report_msg .= " An " . $emailadresse . " nicht gesendet. (Richter 3, " . stripslashes($richter->vorname) . " " . stripslashes($richter->nachname) . ") => E-Mail doppelt vorhanden oder falsche E-Mail\n" . $eol;
								}
								$richter = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgrichter where id like " . $meldungen->ra);
								$emailadresse = filter_var($richter->email, FILTER_SANITIZE_EMAIL);
								if ((isEmail($emailadresse)) && (!in_array($emailadresse, $gesendet))) {
									$gesendet[] = $emailadresse;
									$to = '<' . $emailadresse . '>';
									$mailcode = $meldungen->mail_code_ra;
									$maillink = get_page_link(get_option('lg_kalender_settings_pagemeldungen', '')) . '?bericht=' . $post_id . '&insert=sendmail&mailcode=' . $mailcode;
									$email_message = str_replace("{maillink}", $maillink, $body);
									$msg = $email_message . $eol . $eol;
									if (wp_mail($to, $subject, $msg, $headers, $target)) {
										//break 2;
										$report_msg .= "An " . $to . " erfolgreich gesendet (Richteranwärter, " . stripslashes($richter->vorname) . " " . stripslashes($richter->nachname) . ")\n" . $eol;
									} else {
										$report_msg .= "An " . $to . " nicht gesendet (Richteranwärter, " . stripslashes($richter->vorname) . " " . stripslashes($richter->nachname) . ")\n" . $eol;
									}
								} else {
									$report_msg .= " An " . $emailadresse . " nicht gesendet. (Richteranwärter, " . stripslashes($richter->vorname) . " " . stripslashes($richter->nachname) . ") => E-Mail doppelt vorhanden oder falsche E-Mail\n" . $eol;
								}
								*/
								$to = "<" . $reply . ">";
								$report_msg = iconv('UTF-8', 'UTF-8', $report_msg); //utf8_encode($report_msg);
								wp_mail($to, "Report zum Versand Einladung", $report_msg, $headers, $target);
								unlink($target);
								$wpdb->update(
									$wpdb->prefix . 'lgmeldungendaten',
									//Tabellenname 
									array(
										'versendet' => 'J'
									),
									array('postid' => $post_id),
									array(
										'%s' //String-Wert (column1)
									),
									array('%d')
								);
							} else {
								$lg_content .= '<p>Keine Datei hochgeladen !';
							}
						} else {
							$lg_content .= '<p>E-Mail Adressen stimmen nicht überein !';
						}
					}
					if ($issend == false) {
						if (isset($_POST['subject'])) {
							$subject = $_POST['subject'];
						} else {
							$subject = 'Einladung ' . $CB . ' am ' . date('d.m.Y', strtotime(get_post_meta($post_id, 'termindate', true)));
						}
						if (isset($_POST['body'])) {
							$body = $_POST['body'];
						} else {

							$body = (get_option('lg_kalender_settings_emailbody', ''));
						}
						if (isset($_POST['reply'])) {
							$reply = $_POST['reply'];
						} else {
							$reply = '';
						}
						$lg_content .= "<form method='post' id='mailform' enctype='multipart/form-data'><table width=100%>";
						$lg_content .= "<tr><td>Einladung als PDF</td><td><input name='uploadedfile' id='uploadedfile' type='file' accept='application/pdf'></td></tr>";
						$lg_content .= "<tr><td>Betreff</td><td><input type='text' name='subject' value='" . $subject . "' size='50'></td></tr>";
						$lg_content .= "<tr><td>Mail Text</td><td><textarea form='mailform' name='body' rows='30' cols='80'>" . $body . "</textarea>";
						$lg_content .= "<tr><td>E-Mail Absender</td><td><input type='email' name='reply' value='" . $reply . "' size='50'></td></tr>";
						$lg_content .= "<tr><td>E-Mail wiederholen</td><td><input type='email' name='reply2' value='' size='50'></td></tr>";
						$lg_content .= "<tr><td colspan='2'><input type='submit' name='submit' value='abschicken'></td></tr>";
						$lg_content .= "</table></form>";
					}
				}
			}
		}
		if (isset($_POST['dogid'])) {
			if (isset($_POST['submit'])) {
				if ($_POST['submit'] == 'delete') {
					$wpdb->delete($wpdb->prefix . "lgmeldungen", array('id' => esc_html($_POST['dogid'])));
					echo ("<script>location.href = '" . $post_url_meldungen . '&warnung=delete' . "'</script>");
					//ob_end_clean();
					//wp_redirect($post_url_meldungen . '&warnung=delete');
					exit;
				} elseif ($_POST['submit'] == 'speichern') {
					if ($_POST['copymeldung'] == 'true') {

						$wpdb->insert(
							$wpdb->prefix . 'lgmeldungen',
							//Tabellenname 
							array(
								'postid' => esc_html($_POST['newpostid']),
								'hund_name' => esc_html($_POST['hund_name']),
								'hund_rh' => esc_html($_POST['hund_rh']),
								'hund_zbnr' => esc_html($_POST['hund_zbnr']),
								'hund_wurftag' => esc_html($_POST['hund_wurftag']),
								'hund_chipnr' => esc_html($_POST['hund_chipnr']),
								'hund_mutter' => esc_html($_POST['hund_mutter']),
								'hund_mutter_zbnr' => esc_html($_POST['hund_mutter_zbnr']),
								'hund_vater' => esc_html($_POST['hund_vater']),
								'hund_vater_zbnr' => esc_html($_POST['hund_vater_zbnr']),
								'e_name' => esc_html($_POST['e_name']),
								'e_mitglied' => esc_html($_POST['e_mitglied']),
								'e_plzort' => esc_html($_POST['e_plzort']),
								'e_strasse' => esc_html($_POST['e_strasse']),
								'e_email' => esc_html($_POST['e_email']),
								'e_telefon' => esc_html($_POST['e_telefon']),
								'f_name' => esc_html($_POST['f_name']),
								'f_telefon' => esc_html($_POST['f_telefon']),
								'f_plzort' => esc_html($_POST['f_plzort']),
								'f_strasse' => esc_html($_POST['f_strasse']),
								'posteingang' => 'N',
								'meldungok' => 'N',
								'zahlung' => 'N',
								'zahlung_betrag' => '0,00',
								'preis' => '0',
								'laut' => '0',
								'fw' => '0',
								'bp_vorhanden' => '0',
								'lt_vorhanden' => '0',
								'schussjp_vorhanden' => '0',
								'sortierung' => '0',
								'mail_code' => randomString(30)
							),
							array(
								'%d',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s'
							)
						);
					} else {
						$sortierung = esc_html($_POST['sortierung']);
						if ($CB == 'WT') {
							if (esc_html($_POST['preis']) == '8') {
								$sortierung = '1';
								if (esc_html($_POST['hund_rh']) == 'H') {
									$sortierung = '2';
								}
							}
							if (esc_html($_POST['preis']) == '4') {
								$sortierung = '3';
								if (esc_html($_POST['hund_rh']) == 'H') {
									$sortierung = '4';
								}
							}
							if (esc_html($_POST['preis']) == '5') {
								$sortierung = '5';
							}
						}
						$wpdb->update(
							$wpdb->prefix . 'lgmeldungen',
							//Tabellenname 
							array(
								'postid' => esc_html($_POST['newpostid']),
								'hund_name' => esc_html($_POST['hund_name']),
								'hund_rh' => esc_html($_POST['hund_rh']),
								'hund_zbnr' => esc_html($_POST['hund_zbnr']),
								'hund_wurftag' => esc_html($_POST['hund_wurftag']),
								'hund_chipnr' => esc_html($_POST['hund_chipnr']),
								'hund_mutter' => esc_html($_POST['hund_mutter']),
								'hund_mutter_zbnr' => esc_html($_POST['hund_mutter_zbnr']),
								'hund_vater' => esc_html($_POST['hund_vater']),
								'hund_vater_zbnr' => esc_html($_POST['hund_vater_zbnr']),
								'e_name' => esc_html($_POST['e_name']),
								'e_mitglied' => esc_html($_POST['e_mitglied']),
								'e_plzort' => esc_html($_POST['e_plzort']),
								'e_strasse' => esc_html($_POST['e_strasse']),
								'e_email' => esc_html($_POST['e_email']),
								'e_telefon' => esc_html($_POST['e_telefon']),
								'f_name' => esc_html($_POST['f_name']),
								'f_telefon' => esc_html($_POST['f_telefon']),
								'f_plzort' => esc_html($_POST['f_plzort']),
								'f_strasse' => esc_html($_POST['f_strasse']),
								'posteingang' => esc_html($_POST['posteingang']),
								'meldungok' => esc_html($_POST['meldungok']),
								'zahlung' => esc_html($_POST['zahlung']),
								'zahlung_datum' => esc_html($_POST['zahlung_datum']),
								'zahlung_betrag' => esc_html($_POST['zahlung_betrag']),
								'punkte' => esc_html($_POST['punkte']),
								'laut' => esc_html($_POST['laut']),
								'preis' => esc_html($_POST['preis']),
								'haar' => esc_html($_POST['haar']),
								'bu' => esc_html($_POST['bu']),
								'wh' => esc_html($_POST['wh']),
								'fw' => esc_html($_POST['fw']),
								'bp_vorhanden' => esc_html($_POST['bp_vorhanden']),
								'lt_vorhanden' => esc_html($_POST['lt_vorhanden']),
								'schussjp_vorhanden' => esc_html($_POST['schussjp_vorhanden']),
								'gebiss' => esc_html($_POST['gebiss']),
								'sortierung' => $sortierung,
								'gelesen' => esc_html($_POST['gelesen']),
								'mail_code' => esc_html($_POST['mail_code'])
							),
							array('id' => ($_POST['dogid'])),
							array(
								'%d',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s' //String-Wert (column1)

							),
							array('%d')
						);
					}
					echo ("<script>location.href = '" . $post_url_meldungen . '&warnung=save' . "'</script>");
					//wp_redirect($post_url_meldungen . '&warnung=save');
					exit;
				}
			} else {
				$meldung = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where id like " . $_POST['dogid']);
				$pagemeldungen = get_option('lg_kalender_settings_pagemeldungen', '');
				$lg_content .= '<div id="lgkalender"><form method="post"><input type="hidden" name="dogid" value="' . $meldung->id . '"><table id="lg_kalender_table_meldung" cellspacing="0" cellpadding="0"><tr><th>Feld</th><th>Wert</th><th> </th></tr>';
				$lg_content .= "<tr><th colspan='3' style='background-color: #8a9da8;'>Meldung verschieben</th></tr>";
				$lg_content .= "<tr><td>gehört zur Prüfung</td><td><select name='newpostid'>";

				$year_2 = date("Y", strtotime(get_post_meta($post_id, 'termindate', true)));
				$start_date_2 = $year_2 . '-01-01';
				$end_date_2 = $year_2 . '-12-31';
				$args_2 = array(
					'post_type' => 'lgkalender_termin',
					'post_status' => array('publish', 'draft', 'pending'),
					'posts_per_page' => -1,
					'meta_key' => 'termindate',
					'orderby' => 'meta_value',
					'order' => 'ASC',
					'meta_query' => array(
						'relation' => 'AND',
						array(
							'key' => 'termindate',
							'value' => array($start_date_2, $end_date_2),
							'compare' => 'BETWEEN',
							'type' => 'DATE'
						),
						array(
							'key' => 'terminmeldeschein',
							'value' => 'on',
							'compare' => '='
						)
					)
				);
				$loop_2 = new WP_Query($args_2);
				// start des WordPress Loops für unseren post type
				while ($loop_2->have_posts()) :
					$loop_2->the_post();
					// post id abfragen
					$post_id_2 = get_the_ID();
					$title_2 = get_the_title($post_id_2);
					$termin_date_2 = date("d.m.Y", strtotime(get_post_meta($post_id_2, 'termindate', true)));
					$termin_ort_2 = get_post_meta($post_id_2, 'terminort', true);
					$lg_content .= "<option value='" . $post_id_2 . "' " . selected($post_id_2, $meldung->postid, false) . ">" . $title_2 . " " . $termin_ort_2 . "(" . $termin_date_2 . ")</option>";
				endwhile;
				$lg_content .= "</select><br><input type='checkbox' id='copymeldung' name='copymeldung' value='true'><label for='copymeldung'>kopieren</label>
			</td><td></td></tr>";
				$lg_content .= "<tr><th colspan='3' style='background-color: #8a9da8;'>Daten zum Hund</th></tr>";
				$lg_content .= "<tr><td>Name des Hundes</td><td><input type='text' name='hund_name' size='50' maxlength='100' value='" . stripslashes($meldung->hund_name) . "'></td><td></td></tr>";
				$lg_content .= "<tr><td>Hund R/H</td><td><select name='hund_rh'>
			<option value='R'" . selected('R', $meldung->hund_rh, false) . ">R</option>
			<option value='H'" . selected('H', $meldung->hund_rh, false) . ">H</option>
			</select>
			</td><td></td></tr>";
				$lg_content .= "<tr><td>Zuchtbuchnummer</td><td><input type='text' name='hund_zbnr' size='30' maxlength='30' value='" . $meldung->hund_zbnr . "'></td><td></td></tr>";
				$lg_content .= "<tr><td>Wurftag</td><td><input type='text' name='hund_wurftag' size='20' maxlength='20' value='" . $meldung->hund_wurftag . "'></td><td></td></tr>";
				$lg_content .= "<tr><td>Chipnummer</td><td><input type='text' name='hund_chipnr' size='50' maxlength='100' value='" . $meldung->hund_chipnr . "'></td><td></td></tr>";
				$lg_content .= "<tr><td>Mutter</td><td><input type='text' name='hund_mutter' size='50' maxlength='100' value='" . stripslashes($meldung->hund_mutter) . "'></td><td></td></tr>";
				if ($CB == 'VStP') {
					$lg_content .= "<tr><td>ZB-Nummer Mutter</td><td><input type='text' name='hund_mutter_zbnr' size='30' maxlength='30' value='" . $meldung->hund_mutter_zbnr . "'></td><td></td></tr>";
				}
				$lg_content .= "<tr><td>Vater</td><td><input type='text' name='hund_vater' size='50' maxlength='100' value='" . stripslashes($meldung->hund_vater) . "'></td><td></td></tr>";
				if ($CB == 'VStP') {
					$lg_content .= "<tr><td>ZB-Nummer Vater</td><td><input type='text' name='hund_vater_zbnr' size='30' maxlength='30' value='" . $meldung->hund_vater_zbnr . "'></td><td></td></tr>";
				}
				$lg_content .= "<tr><th colspan='3' style='background-color: #8a9da8;'>Eigentümer</th></tr>";
				$lg_content .= "<tr><td>Eigentümer Name</td><td><input type='text' name='e_name' size='50' maxlength='100' value='" . stripslashes($meldung->e_name) . "'></td><td></td></tr>";
				$lg_content .= "<tr><td>Eigentümer Mitgliedsnummer</td><td><input type='text' name='e_mitglied' size='10' maxlength='10' value='" . stripslashes($meldung->e_mitglied) . "'></td><td></td></tr>";
				$lg_content .= "<tr><td>Eigentümer Strasse</td><td><input type='text' name='e_strasse' size='50' maxlength='100' value='" . stripslashes($meldung->e_strasse) . "'></td><td></td></tr>";
				$lg_content .= "<tr><td>Eigentümer PLZ/Ort</td><td><input type='text' name='e_plzort' size='50' maxlength='100' value='" . stripslashes($meldung->e_plzort) . "'></td><td></td></tr>";
				$lg_content .= "<tr><td>Eigentümer E-Mail</td><td><input type='text' name='e_email' size='50' maxlength='150' value='" . $meldung->e_email . "'></td><td></td></tr>";
				$lg_content .= "<tr><td>Eigentümer Telefon</td><td><input type='text' name='e_telefon' size='50' maxlength='50' value='" . $meldung->e_telefon . "'></td><td></td></tr>";
				$lg_content .= "<tr><th colspan='3' style='background-color: #8a9da8;'>Hundeführer</th></tr>";
				$lg_content .= "<tr><td>Hundeführer Name</td><td><input type='text' name='f_name' size='50' maxlength='100' value='" . stripslashes($meldung->f_name) . "'></td><td></td></tr>";
				$lg_content .= "<tr><td>Hundeführer Strasse</td><td><input type='text' name='f_strasse' size='50' maxlength='100' value='" . stripslashes($meldung->f_strasse) . "'></td><td></td></tr>";
				$lg_content .= "<tr><td>Hundeführer PLZ/Ort</td><td><input type='text' name='f_plzort' size='50' maxlength='100' value='" . stripslashes($meldung->f_plzort) . "'></td><td></td></tr>";
				$lg_content .= "<tr><td>Hundeführer Telefon</td><td><input type='text' name='f_telefon' size='50' maxlength='50' value='" . $meldung->f_telefon . "'></td><td></td></tr>";
				$lg_content .= "<tr><th colspan='3' style='background-color: #8a9da8;'>Sonstige Angaben</th></tr>";
				$lg_content .= "<tr><td>bestandene BP vorhanden</td><td><select name='bp_vorhanden'>
			<option value='1'" . selected('1', $meldung->bp_vorhanden, false) . ">Ja</option>
			<option value='0'" . selected('0', $meldung->bp_vorhanden, false) . ">Nein</option>
			</select>
			</td><td></td></tr>";
				$lg_content .= "<tr><td>Lautnachweis vorhanden</td><td><select name='lt_vorhanden'>
			<option value='1'" . selected('1', $meldung->lt_vorhanden, false) . ">Ja</option>
			<option value='0'" . selected('0', $meldung->lt_vorhanden, false) . ">Nein</option>
			</select>
			</td><td></td></tr>";
				$lg_content .= "<tr><td>Schussfestigkeit JP vorhanden</td><td><select name='schussjp_vorhanden'>
			<option value='1'" . selected('1', $meldung->schussjp_vorhanden, false) . ">Ja</option>
			<option value='0'" . selected('0', $meldung->schussjp_vorhanden, false) . ">Nein</option>
			</select>
			</td><td></td></tr>";
				$lg_content .= "<tr><th colspan='3' style='background-color: #8a9da8;'>Unterlagen Meldung</th></tr>";
				$lg_content .= "<tr><td>Posteingang</td><td><select name='posteingang'>
			<option value='J'" . selected('J', $meldung->posteingang, false) . ">Ja</option>
			<option value='N'" . selected('N', $meldung->posteingang, false) . ">Nein</option>
			</select>
			</td><td></td></tr>";
				$lg_content .= "<tr><td>Meldung OK</td><td><select name='meldungok'>
			<option value='J'" . selected('J', $meldung->meldungok, false) . ">Ja</option>
			<option value='N'" . selected('N', $meldung->meldungok, false) . ">Nein</option>
			</select>
			</td><td></td></tr>";
				$lg_content .= "<tr><th colspan='3' style='background-color: #8a9da8;'>Zahlungseingang</th></tr>";
				$lg_content .= "<tr><td>Zahlung</td><td><select name='zahlung'>
			<option value='J'" . selected('J', $meldung->zahlung, false) . ">Ja</option>
			<option value='N'" . selected('N', $meldung->zahlung, false) . ">Nein</option>
			</select>
			</td><td></td></tr>";
				$lg_content .= "<tr><td>Datum Zahlung</td><td><input type='date' name='zahlung_datum' size='20' maxlength='20' value='" . $meldung->zahlung_datum . "'></td><td></td></tr>";
				$lg_content .= "<tr><td>Zahlbetrag</td><td><input type='text' name='zahlung_betrag' size='10' maxlength='10' value='" . $meldung->zahlung_betrag . "'></td><td></td></tr>";
				$lg_content .= "<tr><th colspan='3' style='background-color: #8a9da8;'>Ergebnis</th></tr>";
				if (($CB == 'BP') || ($CB == 'JP') || ($CB == 'ZP') || ($CB == 'GP')) {
					$lg_content .= "<tr><td>Prüfung Punkte erreicht</td><td><input type='text' name='punkte' size='10' maxlength='3' value='" . $meldung->punkte . "'></td><td></td></tr>";
				}
				if (($CB == 'BP') || ($CB == 'JP') || ($CB == 'ZP') || ($CB == 'GP') || ($CB == 'VSwP')) {
					$lg_content .= "<tr><td>Prüfung im Preis/bestanden</td><td><select name='preis'>
				<option value='0'" . selected('0', $meldung->preis, false) . ">" . getPreis('0') . "</option>
				<option value='1'" . selected('1', $meldung->preis, false) . ">" . getPreis('1') . "</option>
				<option value='2'" . selected('2', $meldung->preis, false) . ">" . getPreis('2') . "</option>
				<option value='3'" . selected('3', $meldung->preis, false) . ">" . getPreis('3') . "</option>
				<option value='8'" . selected('8', $meldung->preis, false) . ">" . getPreis('8') . "</option>
				<option value='4'" . selected('4', $meldung->preis, false) . ">" . getPreis('4') . "</option>
				<option value='5'" . selected('5', $meldung->preis, false) . ">" . getPreis('5') . "</option>
				<option value='6'" . selected('6', $meldung->preis, false) . ">" . getPreis('6') . "</option>
				<option value='7'" . selected('7', $meldung->preis, false) . ">" . getPreis('7') . "</option>
				</select>
				</td><td></td></tr>";
				}
				if ($CB == 'WT') {
					$lg_content .= "<tr><td>bestanden</td><td><select name='preis'>
				<option value='0'" . selected('0', $meldung->preis, false) . ">" . getPreis('0') . "</option>
				<option value='8'" . selected('8', $meldung->preis, false) . ">" . getPreis('8') . "</option>
				<option value='4'" . selected('4', $meldung->preis, false) . ">" . getPreis('4') . "</option>
				<option value='5'" . selected('5', $meldung->preis, false) . ">" . getPreis('5') . "</option>
				<option value='7'" . selected('7', $meldung->preis, false) . ">" . getPreis('7') . "</option>
				</select>
				</td><td></td></tr>";
				}
				if (($CB == 'SJG') || ($CB == 'VStP')) {
					if ($CB == 'VStP') {
						$lg_content .= "<tr><td>Prüfung Punkte erreicht</td><td><input type='text' name='punkte' size='10' maxlength='3' value='" . $meldung->punkte . "'></td><td></td></tr>";
					}
					$lg_content .= "<tr><td>bestanden</td><td><select name='preis'>
				<option value='0'" . selected('0', $meldung->preis, false) . ">" . getPreis('0') . "</option>
				<option value='8'" . selected('8', $meldung->preis, false) . ">" . getPreis('8') . "</option>
				<option value='4'" . selected('4', $meldung->preis, false) . ">" . getPreis('4') . "</option>
				<option value='5'" . selected('5', $meldung->preis, false) . ">" . getPreis('5') . "</option>
				</select>
				</td><td></td></tr>";
				}
				if (($CB == 'JP') || ($CB == 'ZP') || ($CB == 'VStP') || ($CB == 'GP')) {
					$lg_content .= "<tr><td>Laut</td><td><select name='laut'>
				<option value='0'" . selected('0', $meldung->laut, false) . ">" . getLaut('0') . "</option>
				<option value='1'" . selected('1', $meldung->laut, false) . ">" . getLaut('1') . "</option>
				<option value='2'" . selected('2', $meldung->laut, false) . ">" . getLaut('2') . "</option>
				<option value='3'" . selected('3', $meldung->laut, false) . ">" . getLaut('3') . "</option>
				<option value='4'" . selected('4', $meldung->laut, false) . ">" . getLaut('4') . "</option>
				<option value='5'" . selected('5', $meldung->laut, false) . ">" . getLaut('5') . "</option>
				<option value='6'" . selected('6', $meldung->laut, false) . ">" . getLaut('6') . "</option>
				<option value='7'" . selected('7', $meldung->laut, false) . ">" . getLaut('7') . "</option>
				</select>
				</td><td></td></tr>";
				}
				if ($CB == 'ZS') {
					$lg_content .= "<tr><td>Haar</td><td><input type='text' name='haar' size='20' maxlength='20' value='" . $meldung->haar . "'></td></tr>";
					$lg_content .= "<tr><td>Brustumfang in cm</td><td><input type='text' name='bu' size='5' maxlength='5' value='" . $meldung->bu . "'></td></tr>";
					$lg_content .= "<tr><td>Höhe in cm</td><td><input type='text' name='wh' size='5' maxlength='5' value='" . $meldung->wh . "'></td></tr>";
					$lg_content .= "<tr><td>Gebiss</td><td><input type='text' name='gebiss' size='50' maxlength='150' value='" . $meldung->gebiss . "'></td></tr>";
					$lg_content .= "<tr><td>Formwert</td><td><select name='fw'>
				<option value='0'" . selected('0', $meldung->fw, false) . ">" . getFormwert('0') . "</option>
				<option value='1'" . selected('1', $meldung->fw, false) . ">" . getFormwert('1') . "</option>
				<option value='2'" . selected('2', $meldung->fw, false) . ">" . getFormwert('2') . "</option>
				<option value='3'" . selected('3', $meldung->fw, false) . ">" . getFormwert('3') . "</option>
				<option value='4'" . selected('4', $meldung->fw, false) . ">" . getFormwert('4') . "</option>
				<option value='5'" . selected('5', $meldung->fw, false) . ">" . getFormwert('5') . "</option>
				</select>
				</td><td></td></tr>";
				}
				$lg_content .= "<tr><th colspan='3' style='background-color: #8a9da8;'>Sortierung Reihenfolge EDV-Bericht</th></tr>";
				$lg_content .= "<tr><td>Sortierung Reihenfolge</td><td><select name='sortierung'>";
				//$wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id);
				for ($y = 1; $y < ((getMeldungen_Count($post_id_global)) + 1); $y++) {
					$lg_content .= "<option value='" . $y . "'" . selected($y, $meldung->sortierung, false) . ">" . $y . "</option>";
				}
				$lg_content .= "</td><td></td></tr>";
				$lg_content .= "<tr><th colspan='3' style='background-color: #8a9da8;'>Einladung Lesebestätigung</th></tr>";
				$lg_content .= "<tr><td>gelesen</td><td><select name='gelesen'>
			<option value='J'" . selected('J', $meldung->gelesen, false) . ">Ja</option>
			<option value='N'" . selected('N', $meldung->gelesen, false) . ">Nein</option>
			</select>";
				$mail_code = stripslashes($meldung->mail_code);
				if (strlen($mail_code) != 30) {
					$mail_code = randomString(30);
				}
				$lg_content .= "
			<input type='hidden' name='mail_code' value='" . $mail_code . "'
			</td><td></td></tr>";
				//$lg_content .= "<tr><td>Mailcode</td><td>" . $mail_code . "</td><td></td></tr>";
				$lg_content .= "<tr><td>";
				$user = wp_get_current_user();
				$allowed_roles = array(get_option('lg_kalender_settings_allowMeldungEdit', ''));
				if (array_intersect($allowed_roles, $user->roles)) {
					$lg_content .= "<input type='submit' name='submit' value='delete' onclick=\"return confirm('Meldung löschen ?');\">";
				}

				$lg_content .= "</td><td><a href='" . $post_url_meldungen . "' class='button'>zurück zu den Meldungen</a></td><td>";
				$user = wp_get_current_user();
				$allowed_roles = array(get_option('lg_kalender_settings_allowMeldungEdit', ''));
				if (array_intersect($allowed_roles, $user->roles)) {
					$lg_content .= "<input type='submit' name='submit' value='speichern'>";
				}
				$lg_content .= "</td></tr>";
				//$lg_content .= "<tr><td></td><td><a href='" . $post_url_meldungen . "' class='button'>zurück zu den Meldungen</a></td><td></td></tr>";
				$lg_content .= "</table></form></div>";
			}
		} else {
			if (get_query_var('warnung') == 'import') {
				$lg_content .= "<div id='lgkalender'><p>Die importierte Meldung gehört nicht zu dieser Prüfung !!!</div>";
			}
			if (get_query_var('warnung') == 'delete') {
				$lg_content .= "<div id='lgkalender'><p>Datensatz wurde gelöscht !!!</div>";
			}
			if (get_query_var('warnung') == 'new') {
				$lg_content .= "<div id='lgkalender'><p>Ein leerer Datensatz wurde hinzugefügt.</div>";
			}
			if (get_query_var('warnung') == 'save') {
				$lg_content .= "<div id='lgkalender'><p>Datensatz wurde gespeichert.</div>";
			}
			if (isset($_POST['datenset'])) {
				$lg_content .= '<p>Datenset wird geschrieben';
				$wpdb->update(
					$wpdb->prefix . 'lgmeldungendaten',
					//Tabellenname 
					array(
						'postid' => $post_id,
						'meldung_p_ort' => esc_html($_POST['meldung_p_ort']),
						'meldung_p_erschienen' => esc_html($_POST['meldung_p_erschienen']),
						'meldung_p_durchgp' => esc_html($_POST['meldung_p_durchgp']),
						'meldung_p_bestanden' => esc_html($_POST['meldung_p_bestanden']),
						'meldung_p_revier' => esc_html($_POST['meldung_p_revier']),
						'meldung_p_wasser' => esc_html($_POST['meldung_p_wasser']),
						'meldung_p_wild' => esc_html($_POST['meldung_p_wild']),
						'meldung_p_witterung' => esc_html($_POST['meldung_p_witterung']),
						'meldung_p_vorkommnisse' => esc_html($_POST['meldung_p_vorkommnisse'])
					),
					array('id' => esc_html($_POST['datenset'])),
					array(
						'%d',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s'
					),
					array('%d')
				);
			}
			if (isset($_POST['datensetstatistik'])) {
				$lg_content .= '<p>Datenset wird geschrieben';
				$wpdb->update(
					$wpdb->prefix . 'lgmeldungendaten',
					//Tabellenname 
					array(
						'postid' => $post_id,
						'meldung_s_kostenrichter' => esc_html($_POST['meldung_s_kostenrichter']),
						'meldung_s_kostensonstige' => esc_html($_POST['meldung_s_kostensonstige']),
						'meldung_s_spenderichter' => esc_html($_POST['meldung_s_spenderichter']),
						'meldung_s_einnahmensonstige' => esc_html($_POST['meldung_s_einnahmensonstige'])
					),
					array('id' => esc_html($_POST['datensetstatistik'])),
					array(
						'%d',
						'%s',
						'%s',
						'%s',
						'%s'
					),
					array('%d')
				);
			}
			$meldung_daten = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgmeldungendaten where postid like " . $post_id);
			if ($meldung_daten == null) {
				$wpdb->insert(
					$wpdb->prefix . 'lgmeldungendaten',
					//Tabellenname 
					array(
						'postid' => $post_id,
						'meldung_p_ort' => get_post_meta($post_id, 'terminort', true)
					),
					array(
						'%d',
						'%s'
					)
				);
				$meldung_daten = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgmeldungendaten where postid like " . $post_id);
				//$lg_content.="<p>Datensatz Daten zur Prüfung wurde erstellt ...<br>";  //DEBUG
			}
			$lg_content .= '<div id="lgkalender"><table id="lg_kalender_table_meldung" cellspacing="0" cellpadding="0"><tr style="background-color: #8a9da8;"><th id="lg_kalender_meldung_cell1">Nr.</th><th id="lg_kalender_meldung_cell2">Name Hund</th><th id="lg_kalender_meldung_cell3">R/H</th><th id="lg_kalender_meldung_cell4">ZB-Nr.</th><th id="lg_kalender_meldung_cell5">Eigentümer</th><th id="lg_kalender_meldung_cell6">Hundeführer</th><th id="lg_kalender_meldung_cell7">Wurftag</th><th id="lg_kalender_meldung_cell8">bezahlt</th><th id="lg_kalender_meldung_cell9">Meldung</th><th id="lg_kalender_meldung_cell10"> </th><th></th></tr>';
			$meldungen = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id . " ORDER BY sortierung,id");
			$pagemeldungen = get_option('lg_kalender_settings_pagemeldungen', '');
			$post_url_meldungen = get_page_link($pagemeldungen) . '?bericht=' . $post_id;
			$i = 0;
			$alleBP = 1;
			//$einnahmen_kostenrechnung = 0;
			foreach ($meldungen as $meldung) {
				$i++;
				$lg_content .= "<form method='post'><input type='hidden' name='dogid' value='" . $meldung->id . "'>";
				if ($meldung_daten->versendet == 'J') {
					$background = "style='background-color: #f77f77;'";
					if ($meldung->gelesen == 'J') {
						$background = "style='background-color: #a2faba;'";
					}
				} else {
					$background = '';
				}
				$lg_content .= "<tr><td " . $background . ">" . $i . "</td><td " . $background . ">" . stripslashes($meldung->hund_name);
				$lg_content .= "</td><td " . $background . ">" . $meldung->hund_rh;
				$lg_content .= "</td><td " . $background . ">" . $meldung->hund_zbnr;
				$lg_content .= "</td><td " . $background . ">" . stripslashes($meldung->e_name) . "<br>" . stripslashes($meldung->e_plzort);
				$lg_content .= "</td><td " . $background . ">" . stripslashes($meldung->f_name) . "<br>" . stripslashes($meldung->f_plzort);
				$lg_content .= "</td><td " . $background . ">" . $meldung->hund_wurftag;
				if (($meldung->zahlung ?? '') == 'J') {
					$lg_content .= "</td><td>X";
					//$einnahmen_kostenrechnung = $einnahmen_kostenrechnung + (float)$meldung->zahlung_betrag;
				} else {
					$lg_content .= "</td><td>O";
				}
				if ($meldung->meldungok == 'J') {
					$lg_content .= "</td><td>OK";
				} else {
					if ($meldung->posteingang == 'J') {
						$lg_content .= "</td><td>X";
					} else {
						$lg_content .= "</td><td>O";
					}
				}
				if ($meldung->bp_vorhanden == '0') {
					$alleBP = 0;
				}
				$lg_content .= "</td><td><input type='submit' value='edit'>";
				if (($CB == 'SJG') || ($CB == 'VStP')) {
					$lg_content .= "</td><td><p><a href='" . $post_url_meldungen . "&leistungsnachweis=" . $meldung->id . "' class='button' target='_blank'>Formblatt</a></p>";
				} else {
					$lg_content .= "<td></td>";
				}
				$lg_content .= "</td></form></tr>";
			}
			if ($i == 0) {
				$alleBP = 0;
			} //wenn keine Meldung dan Zeiger BP vorhanden auch auf negativ setzen
			/*
																								   <tr><td colspan=9></td><td><p><a href="'.$post_url_meldungen.'&leistungsnachweis=alle" class="button" target="_blank">Formblätter alle</a></p></td></tr>
																								   */
			$lg_content .= '
		<tr><td colspan=9></td><td>';
			if (($CB == 'SJG') || $CB == 'VStP') {
				$lg_content .= '<p><a href="' . $post_url_meldungen . '&leistungsnachweis=alle" class="button" target="_blank">Formblätter alle</a></p>';
			}
			$lg_content .= '</td></tr>
<tr>
<td colspan=4><p>';
			$user = wp_get_current_user();
			$allowed_roles = array(get_option('lg_kalender_settings_allowMeldungEdit', ''));
			if (array_intersect($allowed_roles, $user->roles)) {
				$lg_content .= '<a href="' . $post_url_meldungen . '&insert=new" class="button">neue Meldung anlegen</a>';
			}
			$lg_content .= '</p></td>
<td colspan=3><p>';
			$user = wp_get_current_user();
			$allowed_roles = array(get_option('lg_kalender_settings_allowMeldungEdit', ''));
			if (array_intersect($allowed_roles, $user->roles)) {
				$lg_content .= '<a href="' . $post_url_meldungen . '&insert=import" class="button">neue Meldung importieren</a>';
			}
			$lg_content .= '</p></td>
<td colspan=3><p>';
			$user = wp_get_current_user();
			$allowed_roles = array(get_option('lg_kalender_settings_allowRead', ''));
			if (array_intersect($allowed_roles, $user->roles)) {
				$lg_content .= '<a href="' . $post_url_meldungen . '&downloadpdf=meldungen" class="button" target="_blank">Meldungen<br><br>Liste drucken</a>';
			}
			$lg_content .= '</p></td>
</tr>';
			$meldungen_clip = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "lgmeldungen where postid like " . $post_id);
			$content = '';
			$content_mail = '';
			$zaehler_clip = 0;
			$i_clip = 0;
			foreach ($meldungen_clip as $meldung_clip) {
				$i_clip++;
				$content .= $i_clip . chr(59) . stripslashes($meldung_clip->hund_name) . chr(59) . chr(59) . chr(59) . $meldung_clip->hund_rh . chr(59) . 'ZB-Nr.: ' . $meldung_clip->hund_zbnr . chr(35);
				$content .= chr(59) . 'gew.: ' . $meldung_clip->hund_wurftag . chr(59) . chr(59) . chr(59) . 'Chip-Nr.:' . $meldung_clip->hund_chipnr . chr(35);
				$content .= chr(59) . 'nach: ' . stripslashes($meldung_clip->hund_vater) . chr(59) . chr(59) . 'aus: ' . stripslashes($meldung_clip->hund_mutter) . chr(35);
				$content .= chr(59) . 'Besitzer: ' . stripslashes($meldung_clip->e_name) . ' (' . stripslashes($meldung_clip->e_plzort) . ')' . chr(35);
				$content .= chr(59) . 'Führer: ' . stripslashes($meldung_clip->f_name) . chr(35);
				$content .= chr(35);
				$content_mail .= stripslashes($meldung_clip->e_email) . chr(59);
			}
			//	$content .= "</table>";
			$lg_content .= '
<tr><td colspan=4>';
			wp_get_current_user();
			$allowed_roles = array(get_option('lg_kalender_settings_allowRead', ''));
			if (array_intersect($allowed_roles, $user->roles)) {
				$lg_content .= '<button id="copyButton" onclick="copyMeldung(\'' . htmlentities(esc_html($content)) . '\')">Copy Meldungen to clipboard</button>';
			}
			$lg_content .= '</td><td colspan=3>';
			wp_get_current_user();
			$allowed_roles = array(get_option('lg_kalender_settings_allowRead', ''));
			if (array_intersect($allowed_roles, $user->roles)) {
				$lg_content .= '<button id="copyButton" onclick="copyEMail(\'' . htmlentities($content_mail) . '\')">Copy E-Mail to clipboard</button>';
			}
			$lg_content .= '</td><td colspan=2>';
			wp_get_current_user();
			$allowed_roles = array(get_option('lg_kalender_settings_allowRead', ''));
			if (array_intersect($allowed_roles, $user->roles)) {
				$insert_code = get_post_meta($post_id, 'terminmeldescheincode', true);;
				// set font
				// QRCODE,H : QR-CODE Best error correction
				$theLink = '<a href="' . get_page_link(get_option('lg_kalender_settings_pagemeldungen', '')) . '?bericht=' . $post_id . '&insert=' . $insert_code . '" class="button" target="_blank">Ergebnisse<br><br> mitteilen</a>';

				$lg_content .= $theLink;
			}
			$lg_content .= '</td></tr>
</table>
</div>';
			if (($alleBP == 1) && ($CB == 'JP')) {
				$lg_content .= "<p>alle gemeldeten Hunde haben eine bestandene BP !<br>";
			}
			if (isset($_POST['richterset'])) {
				$wpdb->delete($wpdb->prefix . "lgmeldungenrichter", array('postid' => $post_id));
				//$lg_content.="Datensatz Richter wurde gelöscht: ".$_POST['pl_set']."<br>".$_POST['po_set']."<br>".$_POST['r2_set']."<br>".$_POST['r3_set']."<br>".$_POST['ra_set']."<br>";//DEBUG
				if (isset($_POST['pl_set'])) {
					$pl_set = esc_html($_POST['pl_set']);
				} else {
					$pl_set = '0';
				}
				if (isset($_POST['pl_check'])) {
					$pl_check = esc_html($_POST['pl_check']);
				} else {
					$pl_check = '0';
				}
				if (isset($_POST['po_set'])) {
					$po_set = esc_html($_POST['po_set']);
				} else {
					$po_set = '0';
				}
				if (isset($_POST['po_check'])) {
					$po_check = esc_html($_POST['po_check']);
				} else {
					$po_check = '0';
				}
				if (isset($_POST['r2_set'])) {
					$r2_set = esc_html($_POST['r2_set']);
				} else {
					$r2_set = '0';
				}
				if (isset($_POST['r2_check'])) {
					$r2_check = esc_html($_POST['r2_check']);
				} else {
					$r2_check = '0';
				}
				if (isset($_POST['r3_set'])) {
					$r3_set = esc_html($_POST['r3_set']);
				} else {
					$r3_set = '0';
				}
				if (isset($_POST['r3_check'])) {
					$r3_check = esc_html($_POST['r3_check']);
				} else {
					$r3_check = '0';
				}
				if (isset($_POST['ra_set'])) {
					$ra_set = esc_html($_POST['ra_set']);
				} else {
					$ra_set = '0';
				}
				if (isset($_POST['ra_check'])) {
					$ra_check = esc_html($_POST['ra_check']);
				} else {
					$ra_check = '0';
				}
				if (isset($_POST['gelesen_pl'])) {
					$gelesen_pl = esc_html($_POST['gelesen_pl']);
				} else {
					$gelesen_pl = 'N';
				}
				if (isset($_POST['gelesen_po'])) {
					$gelesen_po = esc_html($_POST['gelesen_po']);
				} else {
					$gelesen_po = 'N';
				}
				if (isset($_POST['gelesen_r2'])) {
					$gelesen_r2 = esc_html($_POST['gelesen_r2']);
				} else {
					$gelesen_r2 = 'N';
				}
				if (isset($_POST['gelesen_r3'])) {
					$gelesen_r3 = esc_html($_POST['gelesen_r3']);
				} else {
					$gelesen_r3 = 'N';
				}
				if (isset($_POST['gelesen_ra'])) {
					$gelesen_ra = esc_html($_POST['gelesen_ra']);
				} else {
					$gelesen_ra = 'N';
				}
				if (isset($_POST['mail_code_pl'])) {
					$mail_code_pl = esc_html($_POST['mail_code_pl']);
				} else {
					$mail_code_pl = 'N';
				}
				if (isset($_POST['mail_code_po'])) {
					$mail_code_po = esc_html($_POST['mail_code_po']);
				} else {
					$mail_code_po = 'N';
				}
				if (isset($_POST['mail_code_r2'])) {
					$mail_code_r2 = esc_html($_POST['mail_code_r2']);
				} else {
					$mail_code_r2 = 'N';
				}
				if (isset($_POST['mail_code_r3'])) {
					$mail_code_r3 = esc_html($_POST['mail_code_r3']);
				} else {
					$mail_code_r3 = 'N';
				}
				if (isset($_POST['mail_code_ra'])) {
					$mail_code_ra = esc_html($_POST['mail_code_ra']);
				} else {
					$mail_code_ra = 'N';
				}

				$wpdb->insert(
					$wpdb->prefix . 'lgmeldungenrichter',
					//Tabellenname 
					array(
						'postid' => $post_id,
						'pl' => $pl_set,
						'pl_check' => $pl_check,
						'po' => $po_set,
						'po_check' => $po_check,
						'r2' => $r2_set,
						'r2_check' => $r2_check,
						'r3' => $r3_set,
						'r3_check' => $r3_check,
						'ra' => $ra_set,
						'ra_check' => $ra_check,
						'gelesen_pl' => $gelesen_pl,
						'gelesen_po' => $gelesen_po,
						'gelesen_r2' => $gelesen_r2,
						'gelesen_r3' => $gelesen_r3,
						'gelesen_ra' => $gelesen_ra,
						'mail_code_pl' => $mail_code_pl,
						'mail_code_po' => $mail_code_po,
						'mail_code_r2' => $mail_code_r2,
						'mail_code_r3' => $mail_code_r3,
						'mail_code_ra' => $mail_code_ra
					),
					array(
						'%d',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s'
					)
				);
			}
			$meldung_richter = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgmeldungenrichter where postid like " . $post_id);
			if ($meldung_richter == null) {
				$wpdb->insert(
					$wpdb->prefix . 'lgmeldungenrichter',
					//Tabellenname 
					array(
						'postid' => $post_id,
						'pl' => '0',
						'pl_check' => '0',
						'po' => '0',
						'po_check' => '0',
						'r2' => '0',
						'r2_check' => '0',
						'r3' => '0',
						'r3_check' => '0',
						'ra' => '0',
						'ra_check' => '0'
					),
					array(
						'%d',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s'
					)
				);
				$meldung_richter = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "lgmeldungenrichter where postid like " . $post_id);
				//$lg_content.="<p>Datensatz Richter wurde erstellt ...<br>";  //DEBUG
			}

			$lg_content .= '<div id="lgkalender"><table id="lg_kalender_table_meldung" cellspacing="0" cellpadding="0"><form method="post"><input type="hidden" name="richterset" value="true"><tr style="background-color: #8a9da8;"><th>Richter</th><th>Auswahl</th><th>Zusage</th><th>gelesen</th><th></th></tr>';
			// Die Abfragen je Position

			$content_mail_richter = '';
			$content_richter = '';
			$filter = 'norm';
			/*
			$pl_content = 'Prüfungsleiter';
			$po_content = 'Prüfungsobmann';
			$r2_content = 'Richter';
			$r3_content = 'Richter';
			$ra_content = 'Richteranwärter';
			if ($CB == 'WT') {
				$filter = 'wt';
				$pl_content = 'WS-Leitung';
				$po_content = 'WS-Obmann';
				$r2_content = 'WS-Richter';
				$r3_content = 'WS-Richter';
				$ra_content = 'WS-Richteranwärter';
			}
			if ($CB == 'ZS') {
				$filter = 'zs';
				$pl_content = 'ZS-Leitung';
				$po_content = 'ZS-Richter';
				$r2_content = 'Ringschreiber';
				$r3_content = '';
				$ra_content = 'ZS-Richteranwärter';
			}
			*/
			//Prüfungsleitung - JGHV Richter ohne Einschränkung
			//$beschreibung=getPLTEXT($CB);
			if ($meldung_daten->versendet == 'J') {
				$background = "style='background-color: #f77f77;'";
				if ($meldung_richter->gelesen_pl == 'J') {
					$background = "style='background-color: #a2faba;'";
				}
			} else {
				$background = '';
			}
			$lg_content .= '<tr ' . $background . '><td><a href="' . get_page_link(get_option('lg_kalender_settings_pagerichter', '')) . '?richterid=' . $meldung_richter->pl . '" target="_blank">' . getPLTEXT($CB) . '</a></td><td><select name="pl_set">';
			//$lg_content .= '<tr ' . $background . '><td>' . getPLTEXT($CB) . '</td><td><select name="pl_set">';
			//ab hier Richterliste zur Auswahl
			if (($CB == 'JP') || ($CB == 'BP') || ($CB == 'ZP') || ($CB == 'GP') || ($CB == 'VStP')) {
				$sql_zusatz = "and (norm like '1') and (ra like '')";
			} else {
				$sql_zusatz = "";
			}
			$richterliste = $wpdb->get_results("SELECT " . $wpdb->prefix . "lgrichter.*,SUM(bau) AS bau, SUM(wt) AS wt, SUM(norm) AS norm, SUM(sw) AS sw, SUM(ra) AS ra, SUM(zs) AS zs FROM " . $wpdb->prefix . "lgrichter," . $wpdb->prefix . "lgrichternummer where (" . $wpdb->prefix . "lgrichter.id=" . $wpdb->prefix . "lgrichternummer.richterid)" . $sql_zusatz . " GROUP BY id order by nachname,vorname");
			$lg_content .= "<option value='0'" . selected('0', $meldung_richter->pl, false) . ">--</option>";
			foreach ($richterliste as $richter) {
				$lg_content .= "<option value='" . $richter->id . "' " . selected($richter->id, $meldung_richter->pl, false) . ">" . stripslashes($richter->nachname) . "," . stripslashes($richter->vorname) . "</option>";
				if ($meldung_richter->pl == $richter->id) {
					$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . $richter->id . ") and (" . $filter . " > 0)");
					$content_richter .= getPLTEXT($CB) . ':' . chr(59) . $richter->vorname . ' ' . $richter->nachname . ', ' . $richternummer->richternummer . ' (' . stripslashes($richternummer->verein) . ')' . chr(35);
					if (!str_contains($content_mail_richter, $richter->email)) {
						$content_mail_richter .= $richter->email . ';';
					}
				}
			}

			$lg_content .= '</select></td><td><input type="checkbox" name="pl_check" value="1"' . checked($meldung_richter->pl_check, 1, false) . '></td><td><select name="gelesen_pl">
			<option value="J"' . selected('J', $meldung_richter->gelesen_pl, false) . '>Ja</option>
			<option value="N"' . selected('N', $meldung_richter->gelesen_pl, false) . '>Nein</option>
			</select>';
			$mail_code = $meldung_richter->mail_code_pl;
			if ($mail_code == '') {
				$mail_code = randomString(30);
			}
			$lg_content .= '<input type="hidden" name="mail_code_pl" value="' . $mail_code . '"></td><td><p>';
			wp_get_current_user();
			$allowed_roles = array(get_option('lg_kalender_settings_allowRead', ''));
			if (array_intersect($allowed_roles, $user->roles)) {
				$lg_content .= '<a href="' . $post_url_meldungen . '&leistungsnachweis=rkbeleg&insert=' . $meldung_richter->pl . '" class="button" target="_blank">RK-Beleg drucken</a>';
			}
			$lg_content .= '</p></td></tr>';


			//Richterobmann - Mitglied PRTCD,DJT,DFV und bei Bau und JP Baubrechtigung
			if ($meldung_daten->versendet == 'J') {
				$background = "style='background-color: #f77f77;'";
				if ($meldung_richter->gelesen_po == 'J') {
					$background = "style='background-color: #a2faba;'";
				}
			} else {
				$background = '';
			}
			$lg_content .= '<tr ' . $background . '><td><a href="' . get_page_link(get_option('lg_kalender_settings_pagerichter', '')) . '?richterid=' . $meldung_richter->po . '" target="_blank">' . getPOTEXT($CB) . '</a></td><td><select name="po_set">';
			//ab hier Richterliste zur Auswahl
			if (($CB == 'JP') || ($CB == 'BP')) {
				$sql_zusatz = "and (norm like '1') and (bau like '1')";
				if (($CB == 'JP') && ($alleBP == 1)) {
					$sql_zusatz = "and (norm like '1')";
				}
			} elseif (($CB == 'ZP') || ($CB == 'GP') || ($CB == 'SJG') || ($CB == 'VStP')) {
				$sql_zusatz = "and (norm like '1')";
			} elseif (($CB == 'WT')) {
				$sql_zusatz = "and (wt like '1')";
			} elseif (($CB == 'ZS')) {
				$sql_zusatz = "and (zs like '1')";
			} else {
				$sql_zusatz = "";
			}
			$sql_zusatz .= " and (ra like '')";
			$sql_zusatz_mitgliedschaft = " and (" . $wpdb->prefix . "lgrichter.mitgliedschaft like '1')";
			if (($CB == 'SJG') || ($CB == 'VStP')) {
				$sql_zusatz_mitgliedschaft = '';
			}
			$richterliste = $wpdb->get_results("SELECT " . $wpdb->prefix . "lgrichter.*,SUM(bau) AS bau, SUM(wt) AS wt, SUM(norm) AS norm, SUM(sw) AS sw, SUM(ra) AS ra, SUM(zs) AS zs FROM " . $wpdb->prefix . "lgrichter," . $wpdb->prefix . "lgrichternummer where (" . $wpdb->prefix . "lgrichter.id=" . $wpdb->prefix . "lgrichternummer.richterid)" . $sql_zusatz_mitgliedschaft . " " . $sql_zusatz . " GROUP BY " . $wpdb->prefix . "lgrichternummer.richternummer,id order by nachname,vorname");
			$lg_content .= "<option value='0'" . selected('0', $meldung_richter->po, false) . ">--</option>";
			foreach ($richterliste as $richter) {
				$lg_content .= "<option value='" . $richter->id . "'" . selected($richter->id, $meldung_richter->po, false) . ">" . stripslashes($richter->nachname) . "," . stripslashes($richter->vorname) . "</option>";
				if ($meldung_richter->po == $richter->id) {
					$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . $richter->id . ") and (" . $filter . " > 0)");
					$content_richter .= getPOTEXT($CB) . ':' . chr(59) . $richter->vorname . ' ' . $richter->nachname . ', ' . $richternummer->richternummer . ' (' . stripslashes($richternummer->verein) . ')' . chr(35);
					if (!str_contains($content_mail_richter, $richter->email)) {
						$content_mail_richter .= $richter->email . ';';
					}
				}
			}
			$lg_content .= '</select></td><td><input type="checkbox" name="po_check" value="1"' . checked($meldung_richter->po_check, 1, false) . '></td><td><select name="gelesen_po">
			<option value="J"' . selected('J', $meldung_richter->gelesen_po, false) . '>Ja</option>
			<option value="N"' . selected('N', $meldung_richter->gelesen_po, false) . '>Nein</option>
			</select>';
			$mail_code = $meldung_richter->mail_code_po;
			if ($mail_code == '') {
				$mail_code = randomString(30);
			}
			$lg_content .= '<input type="hidden" name="mail_code_po" value="' . $mail_code . '"></td><td><p>';
			wp_get_current_user();
			$allowed_roles = array(get_option('lg_kalender_settings_allowRead', ''));
			if (array_intersect($allowed_roles, $user->roles)) {
				$lg_content .= '<a href="' . $post_url_meldungen . '&leistungsnachweis=rkbeleg&insert=' . $meldung_richter->po . '" class="button" target="_blank">RK-Beleg drucken</a>';
			}
			$lg_content .= '</p></td></tr>';



			//Richter 2 - Bei Bau und JP Berechtigung Bau beachten, nicht ZS


			if ($meldung_daten->versendet == 'J') {
				$background = "style='background-color: #f77f77;'";
				if ($meldung_richter->gelesen_r2 == 'J') {
					$background = "style='background-color: #a2faba;'";
				}
			} else {
				$background = '';
			}
			$lg_content .= '<tr ' . $background . '><td><a href="' . get_page_link(get_option('lg_kalender_settings_pagerichter', '')) . '?richterid=' . $meldung_richter->r2 . '" target="_blank">' . getR2TEXT($CB) . '</a></td><td><select name="r2_set">';
			//ab hier Richterliste zur Auswahl
			if (($CB == 'JP') || ($CB == 'BP')) {
				$sql_zusatz = "and (norm like '1') and (bau like '1')";
				if (($CB == 'JP') && ($alleBP == 1)) {
					$sql_zusatz = "and (norm like '1')";
				}
			} elseif (($CB == 'ZP') || ($CB == 'GP') || ($CB == 'SJG') || ($CB == 'VStP')) {
				$sql_zusatz = "and (norm like '1')";
			} elseif (($CB == 'WT')) {
				$sql_zusatz = "and (wt like '1')";
			} else {
				$sql_zusatz = "";
			}
			$sql_zusatz .= " and (ra like '')";
			$richterliste = $wpdb->get_results("SELECT " . $wpdb->prefix . "lgrichter.*,SUM(bau) AS bau, SUM(wt) AS wt, SUM(norm) AS norm, SUM(sw) AS sw, SUM(ra) AS ra, SUM(zs) AS zs FROM " . $wpdb->prefix . "lgrichter," . $wpdb->prefix . "lgrichternummer where (" . $wpdb->prefix . "lgrichter.id=" . $wpdb->prefix . "lgrichternummer.richterid)" . $sql_zusatz . " GROUP BY " . $wpdb->prefix . "lgrichternummer.richternummer,id order by nachname,vorname");
			if ($CB == 'ZS') {
				$richterliste = $wpdb->get_results("SELECT " . $wpdb->prefix . "lgrichter.*,SUM(bau) AS bau, SUM(wt) AS wt, SUM(norm) AS norm, SUM(sw) AS sw, SUM(ra) AS ra, SUM(zs) AS zs FROM " . $wpdb->prefix . "lgrichter," . $wpdb->prefix . "lgrichternummer where (" . $wpdb->prefix . "lgrichter.id=" . $wpdb->prefix . "lgrichternummer.richterid) GROUP BY id order by nachname,vorname");
			}
			$lg_content .= "<option value='0'" . selected('0', $meldung_richter->r2, false) . ">--</option>";
			foreach ($richterliste as $richter) {
				$lg_content .= "<option value='" . $richter->id . "'" . selected($richter->id, $meldung_richter->r2, false) . ">" . stripslashes($richter->nachname) . "," . stripslashes($richter->vorname) . "</option>";
				if ($meldung_richter->r2 == $richter->id) {
					$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . $richter->id . ") and (" . $filter . " > 0)");
					$content_richter .= getR2TEXT($CB) . ':' . chr(59) . chr(59) . $richter->vorname . ' ' . $richter->nachname . ', ' . $richternummer->richternummer . ' (' . stripslashes($richternummer->verein) . ')' . chr(35);
					if (!str_contains($content_mail_richter, $richter->email)) {
						$content_mail_richter .= $richter->email . ';';
					}
				}
			}
			$lg_content .= '</select></td><td><input type="checkbox" name="r2_check" value="1"' . checked($meldung_richter->r2_check, 1, false) . '></td><td><select name="gelesen_r2">
			<option value="J"' . selected('J', $meldung_richter->gelesen_r2, false) . '>Ja</option>
			<option value="N"' . selected('N', $meldung_richter->gelesen_r2, false) . '>Nein</option>
			</select>';
			$mail_code = $meldung_richter->mail_code_r2;
			if ($mail_code == '') {
				$mail_code = randomString(30);
			}
			$lg_content .= '<input type="hidden" name="mail_code_r2" value="' . $mail_code . '"></td><td><p>';
			wp_get_current_user();
			$allowed_roles = array(get_option('lg_kalender_settings_allowRead', ''));
			if (array_intersect($allowed_roles, $user->roles)) {
				$lg_content .= '<a href="' . $post_url_meldungen . '&leistungsnachweis=rkbeleg&insert=' . $meldung_richter->r2 . '" class="button" target="_blank">RK-Beleg drucken</a>';
			}
			$lg_content .= '</p></td></tr>';


			//Richter 3 - nur bei nicht BP nicht ZS bei WT für den Fall dass ein 3. Richter benötigt wird
			if (($CB == 'BP') || ($CB == 'ZS')) {
			} else {
				if ($meldung_daten->versendet == 'J') {
					$background = "style='background-color: #f77f77;'";
					if ($meldung_richter->gelesen_r3 == 'J') {
						$background = "style='background-color: #a2faba;'";
					}
				} else {
					$background = '';
				}
				$lg_content .= '<tr ' . $background . '><td><a href="' . get_page_link(get_option('lg_kalender_settings_pagerichter', '')) . '?richterid=' . $meldung_richter->r3 . '" target="_blank">' . getR3TEXT($CB) . '</a></td><td><select name="r3_set">';
				//ab hier Richterliste zur Auswahl
				if (($CB == 'ZP') || ($CB == 'GP') || ($CB == 'JP') || ($CB == 'SJG') || ($CB == 'VStP')) {
					$sql_zusatz = "and (norm like '1')";
				} elseif (($CB == 'WT')) {
					$sql_zusatz = "and (wt like '1')";
				} else {
					$sql_zusatz = "";
				}
				$sql_zusatz .= " and (ra like '')";
				$richterliste = $wpdb->get_results("SELECT " . $wpdb->prefix . "lgrichter.*,SUM(bau) AS bau, SUM(wt) AS wt, SUM(norm) AS norm, SUM(sw) AS sw, SUM(ra) AS ra, SUM(zs) AS zs FROM " . $wpdb->prefix . "lgrichter," . $wpdb->prefix . "lgrichternummer where (" . $wpdb->prefix . "lgrichter.id=" . $wpdb->prefix . "lgrichternummer.richterid)" . $sql_zusatz . " GROUP BY id order by nachname,vorname");
				$lg_content .= "<option value='0'" . selected('0', $meldung_richter->r3, false) . ">--</option>";
				foreach ($richterliste as $richter) {
					$lg_content .= "<option value='" . $richter->id . "'" . selected($richter->id, $meldung_richter->r3, false) . ">" . stripslashes($richter->nachname) . "," . stripslashes($richter->vorname) . "</option>";
					if ($meldung_richter->r3 == $richter->id) {
						$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . $richter->id . ") and (" . $filter . " > 0)");
						$content_richter .= getR3TEXT($CB) . ':' . chr(59) . chr(59) . $richter->vorname . ' ' . $richter->nachname . ', ' . $richternummer->richternummer . ' (' . stripslashes($richternummer->verein) . ')' . chr(35);
						if (!str_contains($content_mail_richter, $richter->email)) {
							$content_mail_richter .= $richter->email . ';';
						}
					}
				}
				$lg_content .= '</select></td><td><input type="checkbox" name="r3_check" value="1"' . checked($meldung_richter->r3_check, 1, false) . '></td><td><select name="gelesen_r3">
			<option value="J"' . selected('J', $meldung_richter->gelesen_r3, false) . '>Ja</option>
			<option value="N"' . selected('N', $meldung_richter->gelesen_r3, false) . '>Nein</option>
			</select>';
				$mail_code = $meldung_richter->mail_code_r3;
				if ($mail_code == '') {
					$mail_code = randomString(30);
				}
				$lg_content .= '<input type="hidden" name="mail_code_r3" value="' . $mail_code . '"></td><td><p>';
				wp_get_current_user();
				$allowed_roles = array(get_option('lg_kalender_settings_allowRead', ''));
				if (array_intersect($allowed_roles, $user->roles)) {
					$lg_content .= '<a href="' . $post_url_meldungen . '&leistungsnachweis=rkbeleg&insert=' . $meldung_richter->r3 . '" class="button" target="_blank">RK-Beleg drucken</a>';
				}
				$lg_content .= '</p></td></tr>';
			}


			//Richteranwärter
			if (($CB == 'SJG')) {
			} else {
				if ($meldung_daten->versendet == 'J') {
					$background = "style='background-color: #f77f77;'";
					if ($meldung_richter->gelesen_ra == 'J') {
						$background = "style='background-color: #a2faba;'";
					}
				} else {
					$background = '';
				}
				$lg_content .= '<tr ' . $background . '><td><a href="' . get_page_link(get_option('lg_kalender_settings_pagerichter', '')) . '?richterid=' . $meldung_richter->ra . '" target="_blank">' . getRATEXT($CB) . '</a></td><td><select name="ra_set">';
				//ab hier Richterliste zur Auswahl
				if (($CB == 'BP')) {
					$sql_zusatz = "and (bau like '1')";
				} elseif (($CB == 'ZP') || ($CB == 'GP') || ($CB == 'JP')) {
					$sql_zusatz = "and (norm like '1')";
				} elseif (($CB == 'WT')) {
					$sql_zusatz = "and (wt like '1')";
				} elseif (($CB == 'ZS')) {
					$sql_zusatz = "and (zs like '1')";
				} else {
					$sql_zusatz = "";
				}
				$sql_zusatz .= " and (ra like '1')";
				$richterliste = $wpdb->get_results("SELECT " . $wpdb->prefix . "lgrichter.*,SUM(bau) AS bau, SUM(wt) AS wt, SUM(norm) AS norm, SUM(sw) AS sw, SUM(ra) AS ra, SUM(zs) AS zs FROM " . $wpdb->prefix . "lgrichter," . $wpdb->prefix . "lgrichternummer where (" . $wpdb->prefix . "lgrichter.id=" . $wpdb->prefix . "lgrichternummer.richterid)" . $sql_zusatz . " GROUP BY id order by nachname,vorname");
				$lg_content .= "<option value='0'" . selected('0', $meldung_richter->ra, false) . ">--</option>";
				foreach ($richterliste as $richter) {
					$lg_content .= "<option value='" . $richter->id . "'" . selected($richter->id, $meldung_richter->ra, false) . ">" . stripslashes($richter->nachname) . "," . stripslashes($richter->vorname) . "</option>";
					if ($meldung_richter->ra == $richter->id) {
						$richternummer = $wpdb->get_row("SELECT verein,richternummer, sum(" . $filter . ") as " . $filter . " from " . $wpdb->prefix . "lgrichternummer where (richterid like " . $richter->id . ") and (" . $filter . " > 0)");
						$content_richter .= getRATEXT($CB) . ':' . chr(59) . $richter->vorname . ' ' . $richter->nachname . ', ' . $richternummer->richternummer . ' (' . stripslashes($richternummer->verein) . ')' . chr(35);
						if (!str_contains($content_mail_richter, $richter->email)) {
							$content_mail_richter .= $richter->email . ';';
						}
					}
				}
				$lg_content .= '</select></td><td><input type="checkbox" name="ra_check" value="1"' . checked($meldung_richter->ra_check, 1, false) . '></td><td><select name="gelesen_ra">
			<option value="J"' . selected('J', $meldung_richter->gelesen_ra, false) . '>Ja</option>
			<option value="N"' . selected('N', $meldung_richter->gelesen_ra, false) . '>Nein</option>
			</select>';
				$mail_code = $meldung_richter->mail_code_ra;
				if ($mail_code == '') {
					$mail_code = randomString(30);
				}
				$lg_content .= '<input type="hidden" name="mail_code_ra" value="' . $mail_code . '"></td><td><p>';
				wp_get_current_user();
				$allowed_roles = array(get_option('lg_kalender_settings_allowRead', ''));
				if (array_intersect($allowed_roles, $user->roles)) {
					$lg_content .= '<a href="' . $post_url_meldungen . '&leistungsnachweis=rkbeleg&insert=' . $meldung_richter->ra . '" class="button" target="_blank">RK-Beleg drucken</a>';
				}
				$lg_content .= '</p></td></tr>';
			}
			//zum Schluss der Richterliste Tabelle ende....
			$lg_content .= '<tr><td colspan="4">';
			$user = wp_get_current_user();
			$allowed_roles = array(get_option('lg_kalender_settings_allowMeldungEdit', ''));
			if (array_intersect($allowed_roles, $user->roles)) {
				$lg_content .= '<input type="submit" value="speichern">';
			}
			$lg_content .= '</td>
			<td colspan=1><p>';
			wp_get_current_user();
			$allowed_roles = array(get_option('lg_kalender_settings_allowRead', ''));
			if (array_intersect($allowed_roles, $user->roles)) {
				$lg_content .= '<a href="' . $post_url_meldungen . '&downloadpdf=richterbuch" class="button" target="_blank">Richterbuch drucken</a>';
				if ($CB == 'VStP') {
					$lg_content .= "<br><p><a href='" . $post_url_meldungen . "&leistungsnachweis=form2' class='button' target='_blank'>Formblatt 2</a></p>";
				}
			}
			$lg_content .= '</p></td>
			</tr></form>';
			$lg_content .= '<tr><td colspan=1>';
			wp_get_current_user();
			$allowed_roles = array(get_option('lg_kalender_settings_allowRead', ''));
			if (array_intersect($allowed_roles, $user->roles)) {
				$lg_content .= '<button id="copyButton" onclick="copyMeldung(\'' . htmlentities($content_richter) . '\')">Copy Richter to clipboard</button>';
				$lg_content .= '</td><td colspan=3><button id="copyButton" onclick="copyEMail(\'' . htmlentities($content_mail_richter) . '\')">Copy E-Mail Richter to clipboard</button>';
			}
			$lg_content .= '</td></tr>';

			//Daten zur Prüfung, wird für den EDV-Bericht genutzt

			if ($termin_gruppe == '-1'){
				$i = getMeldungen_Count ($post_id);
			$lg_content .= '<form method="post"><input type="hidden" name="datenset" value=' . $meldung_daten->id . '><tr style="background-color: #8a9da8;"><th colspan="5">Daten zum EDV-Bericht</th></tr>';
			$lg_content .= '<tr><td>Prüfungsort</td><td><input type="text" name="meldung_p_ort" size="50" maxlength="100" value="' . stripslashes($meldung_daten->meldung_p_ort) . '"></td><td colspan="3"></td></tr>';
			$lg_content .= '<tr><td>gemeldet</td><td>' . $i . '</td><td colspan="3"></td></tr>';
			$lg_content .= '<tr><td>erschienen</td><td><select name="meldung_p_erschienen">';
			for ($y = 0; $y < ($i + 1); $y++) {
				$lg_content .= "<option value='" . $y . "'" . selected($y, $meldung_daten->meldung_p_erschienen, false) . ">" . $y . "</option>";
			}
			$lg_content .= '</select></td><td colspan="3"></td></tr>';
			$lg_content .= '<tr><td>durchgeprüft</td><td><select name="meldung_p_durchgp">';
			for ($y = 0; $y < ($i + 1); $y++) {
				$lg_content .= "<option value='" . $y . "'" . selected($y, $meldung_daten->meldung_p_durchgp, false) . ">" . $y . "</option>";
			}
			$lg_content .= '</select></td><td colspan="3"></td></tr>';
			$lg_content .= '<tr><td>bestanden</td><td><select name="meldung_p_bestanden">';
			for ($y = 0; $y < ($i + 1); $y++) {
				$lg_content .= "<option value='" . $y . "'" . selected($y, $meldung_daten->meldung_p_bestanden, false) . ">" . $y . "</option>";
			}
			$lg_content .= '</select></td><td colspan="3"></td></tr>';
			$lg_content .= '<tr><td>Revierverhältnisse</td><td><input type="text" name="meldung_p_revier" size="50" maxlength="150" value="' . stripslashes($meldung_daten->meldung_p_revier) . '"></td><td colspan="3"></td></tr>';
			$lg_content .= '<tr><td>Wasserverhältnisse</td><td><input type="text" name="meldung_p_wasser" size="50" maxlength="150" value="' . stripslashes($meldung_daten->meldung_p_wasser) . '"></td><td colspan="3"></td></tr>';
			/*
			$wild = array(
				"1" => "sehr gut",
				"2" => "gut",
				"3" => "ausreichend",
				"4" => "kein",
			);
			*/
			$lg_content .= "<tr><td>Wildbesatz</td><td><select name='meldung_p_wild'>
				<option value='1'" . selected('1', $meldung_daten->meldung_p_wild, false) . ">" . getWild('1') . "</option>
				<option value='2'" . selected('2', $meldung_daten->meldung_p_wild, false) . ">" . getWild('2') . "</option>
				<option value='3'" . selected('3', $meldung_daten->meldung_p_wild, false) . ">" . getWild('3') . "</option>
				<option value='4'" . selected('4', $meldung_daten->meldung_p_wild, false) . ">" . getWild('4') . "</option>
				<option value='5'" . selected('5', $meldung_daten->meldung_p_wild, false) . ">" . getWild('5') . "</option>
				</select>
				</td><td colspan='3'></td></tr>";
			$lg_content .= '<tr><td>Witterung</td><td><input type="text" name="meldung_p_witterung" size="50" maxlength="150" value="' . stripslashes($meldung_daten->meldung_p_witterung) . '"></td><td colspan="3"></td></tr>';
			$lg_content .= '<tr><td>besondere Vorkommnisse</td><td><input type="text" name="meldung_p_vorkommnisse" size="50" maxlength="150" value="' . stripslashes($meldung_daten->meldung_p_vorkommnisse) . '"></td><td colspan="3"></td></tr>';
			$lg_content .= '<tr><td>';
			$user = wp_get_current_user();
			$allowed_roles = array(get_option('lg_kalender_settings_allowMeldungEdit', ''));
			if (array_intersect($allowed_roles, $user->roles)) {
				$lg_content .= '<input type="submit" value="speichern">';
			}
			$lg_content .= '</td><td colspan="3"></td>';

			if (($CB == 'JP') || ($CB == 'BP') || ($CB == 'ZP') || ($CB == 'GP') || ($CB == 'WT') || ($CB == 'ZS') || ($CB == 'VStP')) {
				$lg_content .= '<td><p>';
				wp_get_current_user();
				$allowed_roles = array(get_option('lg_kalender_settings_allowRead', ''));
				if (array_intersect($allowed_roles, $user->roles)) {
					$lg_content .= '<a href="' . $post_url_meldungen . '&downloadpdf=edvbericht" class="button" target="_blank">EDV-Bericht drucken</a>';
					if ($CB == 'VStP') {
						$lg_content .= "<br><p><a href='" . $post_url_meldungen . "&leistungsnachweis=form91' class='button' target='_blank'>Formblatt 91</a></p>";
					}
				}
				$lg_content .= '</p></td></tr>';
			} else {
				$lg_content .= '<td></td></tr>';
			}
			$lg_content .= '<tr><td colspan="5"><p>';
			$user = wp_get_current_user();
			$allowed_roles = array(get_option('lg_kalender_settings_allowMeldungEdit', ''));
			if (array_intersect($allowed_roles, $user->roles)) {
				$lg_content .= '<a href="' . $post_url_meldungen . '&insert=sendmail" class="button">Einladung Teilnehmer verschicken</a>';
			}
			$lg_content .= '</p></td></tr></form>';

			$einnahmen_kostenrechnung = getMeldegeld($post_id);
			$meldung_s_kostenrichter = str_replace(',','.',stripslashes($meldung_daten->meldung_s_kostenrichter));
			$meldung_s_kostensonstige = str_replace(',','.',stripslashes($meldung_daten->meldung_s_kostensonstige));
			$meldung_s_spenderichter = str_replace(',','.',stripslashes($meldung_daten->meldung_s_spenderichter));
			$meldung_s_einnahmensonstige = str_replace(',','.',stripslashes($meldung_daten->meldung_s_einnahmensonstige));

			$lg_content .= '<form method="post"><input type="hidden" name="datensetstatistik" value=' . $meldung_daten->id . '><tr style="background-color: #8a9da8;"><th colspan="5">Kassenwart Kostenrechnung</th></tr>';
			$ergebniss_kostenrechnung = $einnahmen_kostenrechnung - $meldung_s_kostenrichter - $meldung_s_kostensonstige + $meldung_s_spenderichter + $meldung_s_einnahmensonstige;
			$lg_content .= '<tr><td>Meldegeld</td><td>' . number_format($einnahmen_kostenrechnung, 2, ',', '') . '</td><td colspan="3"></td></tr>';
			$lg_content .= '<tr><td>Kosten Richter</td><td><input type="text" onkeypress="return isNumberKey(event)" name="meldung_s_kostenrichter" size="50" maxlength="100" value="' . number_format($meldung_s_kostenrichter,2,',','') . '"></td><td colspan="3"></td></tr>';
			$lg_content .= '<tr><td>Kosten Sonstiges</td><td><input type="text" onkeypress="return isNumberKey(event)" name="meldung_s_kostensonstige" size="50" maxlength="150" value="' . number_format($meldung_s_kostensonstige,2,',','') . '"></td><td colspan="3"></td></tr>';
			$lg_content .= '<tr><td>Spenden (Verzicht Richter)</td><td><input type="text" onkeypress="return isNumberKey(event)" name="meldung_s_spenderichter" size="50" maxlength="150" value="' . number_format($meldung_s_spenderichter,2,',','') . '"></td><td colspan="3"></td></tr>';
			$lg_content .= '<tr><td>Einnahmen sonstiges</td><td><input type="text" onkeypress="return isNumberKey(event)" name="meldung_s_einnahmensonstige" size="50" maxlength="150" value="' . number_format($meldung_s_einnahmensonstige,2,',','') . '"></td><td colspan="3"></td></tr>';
			$lg_content .= '<tr><td>Ergebnis</td><td>' . number_format($ergebniss_kostenrechnung, 2, ',', '') . '</td><td colspan="3"></td></tr>';
			$lg_content .= '<tr><td>';
			$user = wp_get_current_user();
			$allowed_roles = array(get_option('lg_kalender_settings_allowMeldungKostenEdit', ''));
			if (array_intersect($allowed_roles, $user->roles)) {
				$lg_content .= '<input type="submit" value="speichern"></td><td colspan="3">';
			}
		}

			$lg_content .= '</td></table></div></div>';
		}
	}
	if (is_user_logged_in()) {
		return $lg_content;
	} else {
		return '';
	}
}
